/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import com.google.common.base.Preconditions;
import net.conquiris.api.index.IndexException;
import net.conquiris.api.index.IndexInfo;
import net.conquiris.api.index.Writer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

abstract class AbstractWriter
implements Writer {
    static boolean isTermNull(Term term) {
        return term == null || term.field() == null || term.text() == null;
    }

    static String checkKey(String key) {
        Preconditions.checkNotNull((Object)"key", (Object)"Null user property keys not allowed");
        Preconditions.checkArgument((!IndexInfo.isReserved((String)key) ? 1 : 0) != 0, (Object)"Reserved key");
        return key;
    }

    AbstractWriter() {
    }

    abstract boolean ensureAvailable() throws InterruptedException;

    @Override
    public final Writer add(Document document) throws InterruptedException, IndexException {
        if (this.ensureAvailable() && document != null) {
            this.add(document, null);
        }
        return this;
    }

    @Override
    public final Writer delete(String field, String text) throws InterruptedException, IndexException {
        if (this.ensureAvailable() && field != null && text != null) {
            this.delete(new Term(field, text));
        }
        return this;
    }

    @Override
    public final Writer update(String field, String text, Document document) throws InterruptedException, IndexException {
        if (this.ensureAvailable() && field != null && text != null && document != null) {
            this.update(new Term(field, text), document, null);
        }
        return this;
    }

    @Override
    public final Writer update(String field, String text, Document document, Analyzer analyzer) throws InterruptedException, IndexException {
        if (this.ensureAvailable() && field != null && text != null && document != null) {
            this.update(new Term(field, text), document, analyzer);
        }
        return this;
    }

    @Override
    public final Writer update(Term term, Document document) throws InterruptedException, IndexException {
        if (this.ensureAvailable() && !AbstractWriter.isTermNull(term) && document != null) {
            this.update(term, document, null);
        }
        return this;
    }
}

