/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Atomics;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.conquiris.api.index.Delays;
import net.conquiris.api.index.IndexInfo;
import net.conquiris.api.index.IndexReport;
import net.conquiris.api.index.IndexReportLevel;
import net.conquiris.api.index.IndexStatus;
import net.conquiris.api.index.IndexerActivationPolicies;
import net.conquiris.api.index.IndexerActivationPolicy;
import net.conquiris.api.index.LocalIndexerService;
import net.derquinse.common.log.ContextLog;

public abstract class AbstractLocalIndexerService
implements LocalIndexerService {
    private static final Delays DEFAULT_DELAYS = Delays.constant((long)5000L);
    private volatile Delays delays = DEFAULT_DELAYS;
    private volatile IndexerActivationPolicy activationPolicy = IndexerActivationPolicies.alwaysActive();
    private volatile String name = null;
    private final AtomicReference<ContextLog> logRef = Atomics.newReference();
    private final AtomicReference<ContextLog> writerLogRef = Atomics.newReference();

    protected AbstractLocalIndexerService() {
    }

    public final IndexReport getIndexReport(IndexReportLevel level) {
        switch ((IndexReportLevel)Preconditions.checkNotNull((Object)level, (Object)"The index report level must be provided")) {
            case BASIC: {
                return IndexReport.basic((boolean)this.isIndexStarted(), (boolean)this.isIndexActive(), (IndexStatus)this.getIndexStatus());
            }
            case NORMAL: {
                return IndexReport.normal((boolean)this.isIndexStarted(), (boolean)this.isIndexActive(), (IndexStatus)this.getIndexStatus(), (Delays)this.getDelays(), (IndexInfo)this.getIndexInfo());
            }
            case DETAILED: {
                return IndexReport.detailed((boolean)this.isIndexStarted(), (boolean)this.isIndexActive(), (IndexStatus)this.getIndexStatus(), (Delays)this.getDelays(), (IndexInfo)this.getIndexInfo());
            }
        }
        throw new AssertionError();
    }

    public final Delays getDelays() {
        return this.delays;
    }

    public final void setDelays(Delays delays) {
        this.delays = (Delays)Preconditions.checkNotNull((Object)delays, (Object)"The delays configuration must be provided");
    }

    public final boolean isIndexActive() {
        try {
            return this.activationPolicy.isActive() && this.isIndexStarted();
        }
        catch (RuntimeException e) {
            this.log().error((Throwable)e, "Unable to get current activation state", new Object[0]);
            return false;
        }
    }

    public void setActivationPolicy(@Nullable IndexerActivationPolicy activationPolicy) {
        this.activationPolicy = (IndexerActivationPolicy)Objects.firstNonNull((Object)activationPolicy, (Object)IndexerActivationPolicies.alwaysActive());
    }

    public final String getName() {
        if (this.name == null) {
            return this.getClass().getSimpleName();
        }
        return this.name;
    }

    public final void setName(String name) {
        if (!Objects.equal((Object)name, (Object)this.name)) {
            this.name = name;
            this.logRef.set(null);
            this.writerLogRef.set(null);
        }
    }

    protected String logContextFormat() {
        return "IndexerService[%s]";
    }

    protected ContextLog baseLog() {
        return ContextLog.of((String)"net.conquiris.index");
    }

    protected final ContextLog log() {
        ContextLog log;
        while ((log = this.logRef.get()) == null) {
            log = this.baseLog().to(String.format(this.logContextFormat(), this.getName()));
            this.logRef.compareAndSet(null, log);
        }
        return log;
    }

    protected final ContextLog writerLog() {
        ContextLog log;
        while ((log = this.writerLogRef.get()) == null) {
            log = this.log().to("writer");
            this.writerLogRef.compareAndSet(null, log);
        }
        return log;
    }
}

