/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.search;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.util.Version;

public abstract class Highlight {
    private static final Predicate<Map.Entry<String, Integer>> FILTER = new Predicate<Map.Entry<String, Integer>>(){

        public boolean apply(Map.Entry<String, Integer> input) {
            String k = input.getKey();
            Integer v = input.getValue();
            return k != null && v != null && v >= 0;
        }
    };
    private static final No NO = new No();
    private static final HighlightedQuery UNHIGHLIGHTED = new HighlightedQuery();

    private static ImmutableMap<String, Integer> filter(Map<String, Integer> fields) {
        if (fields == null || fields.isEmpty()) {
            return ImmutableMap.of();
        }
        return ImmutableMap.copyOf((Map)Maps.filterEntries(fields, FILTER));
    }

    public static Highlight of(Analyzer analyzer, Formatter formatter, Map<String, Integer> fields) {
        ImmutableMap<String, Integer> f = Highlight.filter(fields);
        if (f.isEmpty()) {
            return Highlight.no();
        }
        Preconditions.checkNotNull((Object)analyzer);
        Preconditions.checkNotNull((Object)formatter);
        return new Some(analyzer, formatter, f);
    }

    public static Highlight of(Map<String, Integer> fields) {
        ImmutableMap<String, Integer> f = Highlight.filter(fields);
        if (f.isEmpty()) {
            return Highlight.no();
        }
        return new Some((Analyzer)new StandardAnalyzer(Version.LUCENE_34), (Formatter)new SimpleHTMLFormatter(), f);
    }

    public static Highlight no() {
        return NO;
    }

    Highlight() {
    }

    public abstract HighlightedQuery highlight(Query var1);

    public static class HighlightedQuery {
        HighlightedQuery() {
        }

        public Multimap<String, String> getFragments(Document doc) {
            return ImmutableListMultimap.of();
        }
    }

    private static class Some
    extends Highlight {
        private final ImmutableMap<String, Integer> fields;
        private final Analyzer analyzer;
        private final Formatter formatter;

        Some(Analyzer analyzer, Formatter formatter, ImmutableMap<String, Integer> fields) {
            this.analyzer = analyzer;
            this.formatter = formatter;
            this.fields = fields;
        }

        @Override
        public HighlightedQuery highlight(Query query) {
            return new HQuery(query);
        }

        private final class HQuery
        extends HighlightedQuery {
            private final Highlighter highlighter;

            private HQuery(Query query) {
                Preconditions.checkNotNull((Object)query, (Object)"The rewritten query to highlight must be provided");
                this.highlighter = new Highlighter(Some.this.formatter, (Scorer)new QueryScorer(query));
            }

            @Override
            public Multimap<String, String> getFragments(Document doc) {
                ArrayListMultimap fragments = ArrayListMultimap.create();
                for (Map.Entry entry : Some.this.fields.entrySet()) {
                    String field = (String)entry.getKey();
                    Integer maxNumFragments = (Integer)entry.getValue();
                    String text = doc.get(field);
                    if (text == null) continue;
                    try {
                        this.highlighter.setTextFragmenter((Fragmenter)(maxNumFragments > 0 ? new SimpleFragmenter() : new NullFragmenter()));
                        String[] fr = this.highlighter.getBestFragments(Some.this.analyzer, field, text, maxNumFragments.intValue());
                        if (fr == null || fr.length <= 0) continue;
                        fragments.putAll((Object)field, Arrays.asList(fr));
                    }
                    catch (IOException e) {
                    }
                    catch (InvalidTokenOffsetsException e) {}
                }
                return fragments;
            }
        }
    }

    private static class No
    extends Highlight {
        No() {
        }

        @Override
        public HighlightedQuery highlight(Query query) {
            return UNHIGHLIGHTED;
        }
    }
}

