/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;
import net.conquiris.api.search.IndexNotAvailableException;
import net.conquiris.api.search.Reader;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.api.search.SearchException;

abstract class AbstractReaderSupplier
implements ReaderSupplier {
    private final AtomicLong requests = new AtomicLong();

    AbstractReaderSupplier() {
    }

    @Override
    public final Reader get() {
        try {
            Reader r = (Reader)Preconditions.checkNotNull((Object)this.doGet(), (Object)"Null reader supplied");
            this.requests.incrementAndGet();
            return r;
        }
        catch (SearchException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IndexNotAvailableException((Throwable)e);
        }
    }

    abstract Reader doGet() throws Exception;

    @Override
    public final long getRequested() {
        return this.requests.get();
    }
}

