/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.search;

import net.conquiris.api.search.ManagedReaderSupplier;
import net.conquiris.api.search.ReaderSupplier;
import net.conquiris.search.DefaultManagedReaderSupplier;
import net.conquiris.search.DirectoryReaderSupplier;
import net.conquiris.search.EmptyIndex;
import net.conquiris.search.IndexWriterReaderSupplier;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public final class ReaderSuppliers {
    private ReaderSuppliers() {
        throw new AssertionError();
    }

    public static ReaderSupplier empty() {
        return EmptyIndex.getInstance();
    }

    public static ReaderSupplier directory(Directory directory) {
        return new DirectoryReaderSupplier(directory);
    }

    public static ReaderSupplier writer(IndexWriter writer) {
        return new IndexWriterReaderSupplier(writer);
    }

    public static ManagedReaderSupplier managed(ReaderSupplier supplier, long holdTime) {
        return new DefaultManagedReaderSupplier(supplier, holdTime);
    }

    public static ManagedReaderSupplier managed(ReaderSupplier supplier) {
        return ReaderSuppliers.managed(supplier, 0L);
    }

    public static ReaderSupplier managed(Directory directory, long holdTime) {
        return ReaderSuppliers.managed(ReaderSuppliers.directory(directory), holdTime);
    }

    public static ReaderSupplier managed(Directory directory) {
        return ReaderSuppliers.managed(ReaderSuppliers.directory(directory), 0L);
    }

    public static ReaderSupplier managed(IndexWriter writer, long holdTime) {
        return ReaderSuppliers.managed(ReaderSuppliers.writer(writer), holdTime);
    }

    public static ReaderSupplier managed(IndexWriter writer) {
        return ReaderSuppliers.managed(ReaderSuppliers.writer(writer), 0L);
    }
}

