/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.search;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.conquiris.api.search.Result;

public final class CountResult
extends Result {
    private static final long serialVersionUID = 4419889292418874612L;
    private static final CountResult EMPTY = CountResult.of(0, 0.0f, 0L);

    public static CountResult of(int totalHits, float maxScore, long time) {
        return new CountResult(totalHits, maxScore, time);
    }

    public static CountResult empty() {
        return EMPTY;
    }

    private CountResult(int totalHits, float maxScore, long time) {
        super(totalHits, maxScore, time);
    }

    @Override
    public boolean equals(Object obj) {
        return this.equalsResult(obj, CountResult.class) != null;
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 3058933937818618604L;
        private final int totalHits;
        private final float maxScore;
        private final long time;

        public SerializationProxy(CountResult r) {
            this.totalHits = r.getTotalHits();
            this.maxScore = r.getMaxScore();
            this.time = r.getTime();
        }

        private Object readResolve() {
            return new CountResult(this.totalHits, this.maxScore, this.time);
        }
    }
}

