/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.search;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public abstract class Result
implements Serializable {
    private static final long serialVersionUID = 2164177824714263309L;
    private final int totalHits;
    private final float maxScore;
    private final long time;

    Result(int totalHits, float maxScore, long time) {
        Preconditions.checkArgument((totalHits >= 0 ? 1 : 0) != 0, (Object)"The number of hits must be >= 0");
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (Object)"The query time must be >= 0");
        this.totalHits = totalHits;
        this.maxScore = maxScore;
        this.time = time;
    }

    public final float getMaxScore() {
        return this.maxScore;
    }

    public final long getTime() {
        return this.time;
    }

    public final int getTotalHits() {
        return this.totalHits;
    }

    final <T extends Result> T equalsResult(Object obj, Class<T> klass) {
        if (obj != null && klass.equals(obj.getClass())) {
            Result r = (Result)obj;
            if (this.totalHits == r.totalHits && this.maxScore == r.maxScore && this.time == r.time) {
                return (T)r;
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this.equalsResult(obj, Result.class) != null;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.totalHits, Float.valueOf(this.maxScore), this.time});
    }
}

