/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class Delays
implements Serializable {
    private static final long serialVersionUID = 1969811896715857676L;
    private final long normal;
    private final long idle;
    private final long error;

    private static long checkNormal(long normal) {
        Preconditions.checkArgument((normal >= 0L ? 1 : 0) != 0, (Object)"The normal delay must be >= 0");
        return normal;
    }

    private static long checkIdle(long idle) {
        Preconditions.checkArgument((idle >= 0L ? 1 : 0) != 0, (Object)"The idle delay must be >= 0");
        return idle;
    }

    private static long checkError(long error) {
        Preconditions.checkArgument((error >= 0L ? 1 : 0) != 0, (Object)"The error delay must be >= 0");
        return error;
    }

    private Delays(long normal, long idle, long error) {
        this.normal = Delays.checkNormal(normal);
        this.idle = Delays.checkIdle(idle);
        this.error = Delays.checkError(error);
    }

    public static Delays constant(long delay) {
        return new Delays(delay, delay, delay);
    }

    public static Delays of(long normal, long idle, long error) {
        return new Delays(normal, idle, error);
    }

    public long getNormal() {
        return this.normal;
    }

    public Delays setNormal(long normal) {
        if (normal == this.normal) {
            return this;
        }
        return Delays.of(Delays.checkNormal(normal), this.idle, this.error);
    }

    public Delays setIdle(long idle) {
        if (idle == this.idle) {
            return this;
        }
        return Delays.of(this.normal, Delays.checkIdle(idle), this.error);
    }

    public Delays setError(long error) {
        if (error == this.error) {
            return this;
        }
        return Delays.of(this.normal, this.idle, Delays.checkError(error));
    }

    public long getIdle() {
        return this.idle;
    }

    public long getError() {
        return this.error;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.normal, this.idle, this.error});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Delays) {
            Delays other = (Delays)obj;
            return this.normal == other.normal && this.idle == other.idle && this.error == other.error;
        }
        return false;
    }

    public String toString() {
        return String.format("Delays(%d, %d, %d)", this.normal, this.idle, this.error);
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -7402734122441533946L;
        private final long normal;
        private final long idle;
        private final long error;

        public SerializationProxy(Delays d) {
            this.normal = d.getNormal();
            this.idle = d.getIdle();
            this.error = d.getError();
        }

        private Object readResolve() {
            return Delays.of(this.normal, this.idle, this.error);
        }
    }
}

