/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.search;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import net.conquiris.api.search.Result;

public final class PageResult<T>
extends Result
implements Iterable<T> {
    private static final long serialVersionUID = -1123023188407973900L;
    private static final PageResult<Object> EMPTY = new PageResult(0, 0.0f, 0L, 0, ImmutableList.of());
    private final int firstResult;
    private final ImmutableList<T> items;

    public static <T> PageResult<T> empty() {
        return EMPTY;
    }

    public static <T> PageResult<T> notFound(int totalHits, float maxScore, long time, int firstResult) {
        return new PageResult<T>(totalHits, maxScore, time, firstResult, ImmutableList.of());
    }

    public static <T> PageResult<T> notFound(long time, int firstResult) {
        return PageResult.notFound(0, 0.0f, time, firstResult);
    }

    public static <T> PageResult<T> found(int totalHits, float maxScore, long time, int firstResult, List<T> items) {
        return new PageResult<T>(totalHits, maxScore, time, firstResult, items);
    }

    private PageResult(int totalHits, float maxScore, long time, int firstResult, List<T> items) {
        super(totalHits, maxScore, time);
        Preconditions.checkNotNull(items, (Object)"The items list must be provided");
        Preconditions.checkArgument((firstResult >= 0 ? 1 : 0) != 0, (Object)"The first result must be >= 0");
        this.items = ImmutableList.copyOf(items);
        int n = this.items.size();
        Preconditions.checkArgument((n == 0 || totalHits >= firstResult + n ? 1 : 0) != 0, (Object)"The total number of hits must be >= first result + number of items");
        this.firstResult = firstResult;
    }

    private void checkNotEmpty() {
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0, (Object)"The result is empty");
    }

    public int getFirstRequestedResult() {
        return this.firstResult;
    }

    public int getFirstResult() {
        this.checkNotEmpty();
        return this.firstResult;
    }

    public int getLastResult() {
        this.checkNotEmpty();
        return this.firstResult + this.items.size() - 1;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int size() {
        return this.items.size();
    }

    public List<T> getItems() {
        return this.items;
    }

    public T get(int index) {
        return (T)this.items.get(this.firstResult + index);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        PageResult other = this.equalsResult(obj, PageResult.class);
        if (other != null) {
            return this.firstResult == other.firstResult && Objects.equal(this.items, other.items);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.firstResult, this.items});
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 3709651284308359760L;
        private final int totalHits;
        private final float maxScore;
        private final long time;
        private final int firstResult;
        private final ImmutableList<T> items;

        public SerializationProxy(PageResult<T> r) {
            this.totalHits = r.getTotalHits();
            this.maxScore = r.getMaxScore();
            this.time = r.getTime();
            this.firstResult = r.getFirstRequestedResult();
            this.items = ((PageResult)r).items;
        }

        private Object readResolve() {
            return new PageResult(this.totalHits, this.maxScore, this.time, this.firstResult, (List)this.items);
        }
    }
}

