/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.index;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.conquiris.api.index.Delays;
import net.conquiris.api.index.IndexActiveFlag;
import net.conquiris.api.index.IndexInfo;
import net.conquiris.api.index.IndexReportLevel;
import net.conquiris.api.index.IndexStartedFlag;
import net.conquiris.api.index.IndexStatus;
import net.conquiris.api.index.IndexStatusProperty;
import net.derquinse.common.meta.Metas;

@Immutable
public final class IndexReport
implements IndexStatusProperty,
IndexStartedFlag,
IndexActiveFlag {
    private final IndexReportLevel level;
    private final boolean started;
    private final boolean active;
    private final IndexStatus status;
    private final Optional<Delays> delays;
    private final Optional<IndexInfo> info;

    public static IndexReport basic(boolean started, boolean active, IndexStatus status) {
        return new IndexReport(IndexReportLevel.BASIC, started, active, status, null, null);
    }

    public static IndexReport normal(boolean started, boolean active, IndexStatus status, Delays delays, IndexInfo info) {
        return new IndexReport(IndexReportLevel.NORMAL, started, active, status, delays, info);
    }

    public static IndexReport detailed(boolean started, boolean active, IndexStatus status, Delays delays, IndexInfo info) {
        return new IndexReport(IndexReportLevel.DETAILED, started, active, status, delays, info);
    }

    IndexReport(IndexReportLevel level, boolean started, boolean active, IndexStatus status, @Nullable Delays delays, @Nullable IndexInfo info) {
        this.level = (IndexReportLevel)((Object)Preconditions.checkNotNull((Object)((Object)level), (Object)"The index report level must be provided"));
        this.status = (IndexStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"The index status must be provided"));
        this.started = started;
        boolean bl = this.active = active && started;
        if (level == IndexReportLevel.BASIC) {
            this.delays = Optional.absent();
            this.info = Optional.absent();
        } else {
            this.delays = Optional.of((Object)Preconditions.checkNotNull((Object)delays, (Object)"The index delay configuration must be provided"));
            if (level == IndexReportLevel.NORMAL) {
                info = ((IndexInfo)Preconditions.checkNotNull((Object)info, (Object)"The index information must be provided")).asBasic();
            }
            this.info = Optional.of((Object)info);
        }
    }

    public IndexReportLevel getLevel() {
        return this.level;
    }

    @Override
    public IndexStatus getIndexStatus() {
        return this.status;
    }

    @Override
    public boolean isIndexStarted() {
        return this.started;
    }

    @Override
    public boolean isIndexActive() {
        return this.active;
    }

    public Optional<Delays> getDelays() {
        return this.delays;
    }

    public Optional<IndexInfo> getInfo() {
        return this.info;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.level, this.started, this.isIndexActive(), this.status, this.delays, this.info});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexReport) {
            IndexReport other = (IndexReport)obj;
            return this.level == other.level && this.started == other.started && this.active == other.active && this.status == other.status && Objects.equal(this.delays, other.delays) && Objects.equal(this.info, other.info);
        }
        return false;
    }

    public String toString() {
        Metas.ToStringHelper h = Metas.toStringHelper((Object)this).add(INDEX_STARTED).add(INDEX_ACTIVE).add(INDEX_STATUS);
        if (this.level != IndexReportLevel.BASIC) {
            h.add("delays", this.delays.get());
            h.add("info", this.info.get());
        }
        return h.toString();
    }
}

