/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.index;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IndexInfo {
    public static final String RESERVED_PREFIX = "cq:";
    public static final String CHECKPOINT_NAME = "checkpoint";
    public static final String TARGET_CHECKPOINT_NAME = "targetCheckpoint";
    public static final String TIMESTAMP_NAME = "timestamp";
    public static final String SEQUENCE_NAME = "sequence";
    public static final String CHECKPOINT = "cq:checkpoint";
    public static final String TARGET_CHECKPOINT = "cq:targetCheckpoint";
    public static final String TIMESTAMP = "cq:timestamp";
    public static final String SEQUENCE = "cq:sequence";
    private static final IndexInfo EMPTY = IndexInfo.of(null, null, 0, 0L, 0L, (Map<String, String>)ImmutableMap.of());
    private final String checkpoint;
    private final String targetCheckpoint;
    private final int documents;
    private final long timestamp;
    private final long sequence;
    private final ImmutableMap<String, String> properties;

    public static boolean isReserved(String key) {
        return key != null && key.startsWith(RESERVED_PREFIX);
    }

    public static Predicate<String> isReserved() {
        return IsReserved.INSTANCE;
    }

    public static boolean isUserProperty(String key, String value) {
        return key != null && value != null && !IndexInfo.isReserved(key);
    }

    public static boolean isUserProperty(Map.Entry<String, String> entry) {
        return entry != null && IndexInfo.isUserProperty(entry.getKey(), entry.getValue());
    }

    public static Predicate<Map.Entry<String, String>> isUserProperty() {
        return IsUserProperty.INSTANCE;
    }

    public static IndexInfo empty() {
        return EMPTY;
    }

    public static IndexInfo of(@Nullable String checkpoint, @Nullable String targetCheckpoint, int documents, long timestamp, long sequence, Map<String, String> properties) {
        return new IndexInfo(checkpoint, targetCheckpoint, documents, timestamp, sequence, properties);
    }

    private static long safe2Long(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return Math.max(0L, Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static IndexInfo fromMap(int documents, Map<String, String> data) {
        if (data == null || data.isEmpty()) {
            return IndexInfo.of(null, null, documents, 0L, 0L, (Map<String, String>)ImmutableMap.of());
        }
        return IndexInfo.of(data.get(CHECKPOINT), data.get(TARGET_CHECKPOINT), documents, IndexInfo.safe2Long(data.get(TIMESTAMP)), IndexInfo.safe2Long(data.get(SEQUENCE)), Maps.filterEntries(data, IndexInfo.isUserProperty()));
    }

    private IndexInfo(String checkpoint, String targetCheckpoint, int documents, long timestamp, long sequence, Map<String, String> properties) {
        Preconditions.checkArgument((documents >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((sequence >= 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull(properties);
        Preconditions.checkArgument((boolean)Iterables.all(properties.entrySet(), IndexInfo.isUserProperty()));
        this.checkpoint = checkpoint;
        this.targetCheckpoint = targetCheckpoint;
        this.documents = documents;
        this.timestamp = timestamp;
        this.sequence = sequence;
        this.properties = ImmutableMap.copyOf(properties);
    }

    public IndexInfo asBasic() {
        if (this.properties.isEmpty()) {
            return this;
        }
        return new IndexInfo(this.checkpoint, this.targetCheckpoint, this.documents, this.timestamp, this.sequence, (Map<String, String>)ImmutableMap.of());
    }

    public String getCheckpoint() {
        return this.checkpoint;
    }

    public String getTargetCheckpoint() {
        return this.targetCheckpoint;
    }

    public int getDocuments() {
        return this.documents;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getSequence() {
        return this.sequence;
    }

    public ImmutableMap<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.checkpoint, this.targetCheckpoint, this.documents, this.timestamp, this.sequence, this.properties});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IndexInfo) {
            IndexInfo other = (IndexInfo)obj;
            return this.documents == other.documents && this.timestamp == other.timestamp && this.sequence == other.sequence && Objects.equal((Object)this.checkpoint, (Object)other.checkpoint) && Objects.equal((Object)this.targetCheckpoint, (Object)other.targetCheckpoint) && Objects.equal(this.properties, other.properties);
        }
        return false;
    }

    public String toString() {
        Objects.ToStringHelper h = Objects.toStringHelper((Object)this).add(CHECKPOINT_NAME, (Object)this.checkpoint).add("documents", this.documents).add(TARGET_CHECKPOINT_NAME, (Object)this.targetCheckpoint).add(TIMESTAMP_NAME, this.timestamp).add(SEQUENCE_NAME, this.sequence);
        if (!this.properties.isEmpty()) {
            h.add("properties", this.properties);
        }
        return h.toString();
    }

    private static enum IsUserProperty implements Predicate<Map.Entry<String, String>>
    {
        INSTANCE;


        public boolean apply(Map.Entry<String, String> input) {
            return IndexInfo.isUserProperty(input);
        }

        public String toString() {
            return "Valid user property predicate";
        }
    }

    private static enum IsReserved implements Predicate<String>
    {
        INSTANCE;


        public boolean apply(String input) {
            return IndexInfo.isReserved(input);
        }

        public String toString() {
            return "Reserved property key predicate";
        }
    }
}

