/*
 * Decompiled with CFR 0.152.
 */
package net.conquiris.api.search;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.Nullable;
import net.conquiris.api.search.Result;

public final class ItemResult<T>
extends Result {
    private static final long serialVersionUID = 2086856876372169518L;
    private static final ItemResult<Object> EMPTY = new ItemResult<Object>(0, 0.0f, 0L, null);
    private final T item;

    public static <T> ItemResult<T> empty() {
        return EMPTY;
    }

    public static <T> ItemResult<T> notFound(long time) {
        return new ItemResult<Object>(0, 0.0f, time, null);
    }

    public static <T> ItemResult<T> found(int totalHits, float maxScore, long time, T item) {
        return new ItemResult<T>(totalHits, maxScore, time, item);
    }

    private ItemResult(int totalHits, float maxScore, long time, @Nullable T item) {
        super(totalHits, maxScore, time);
        if (totalHits > 0) {
            Preconditions.checkNotNull(item, (Object)"No item provided");
        } else {
            Preconditions.checkArgument((item == null ? 1 : 0) != 0, (Object)"Superfluous item provided");
        }
        this.item = item;
    }

    public boolean isFound() {
        return this.item != null;
    }

    public T getItem() {
        Preconditions.checkState((this.item != null ? 1 : 0) != 0, (Object)"Item not found");
        return this.item;
    }

    @Override
    public boolean equals(Object obj) {
        ItemResult other = this.equalsResult(obj, ItemResult.class);
        if (other != null) {
            return Objects.equal(this.item, other.item);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.item});
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = -7598986838377254525L;
        private final int totalHits;
        private final float maxScore;
        private final long time;
        private final T item;

        public SerializationProxy(ItemResult<T> r) {
            this.totalHits = r.getTotalHits();
            this.maxScore = r.getMaxScore();
            this.time = r.getTime();
            this.item = r.isFound() ? r.getItem() : null;
        }

        private Object readResolve() {
            return new ItemResult(this.totalHits, this.maxScore, this.time, this.item);
        }
    }
}

