/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.util.stopwatch.statistics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.codinux.util.stopwatch.Duration;
import net.codinux.util.stopwatch.DurationKt;
import net.codinux.util.stopwatch.collections.ConcurrentList;
import net.codinux.util.stopwatch.collections.ConcurrentMap;
import net.codinux.util.stopwatch.formatter.TimeFormatter;
import net.codinux.util.stopwatch.output.MessageLogger;
import net.codinux.util.stopwatch.statistics.DefaultTaskStatisticsCollector;
import net.codinux.util.stopwatch.statistics.TaskStatistics;
import net.codinux.util.stopwatch.statistics.TaskStatisticsCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J\u0018\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/codinux/util/stopwatch/statistics/DefaultTaskStatisticsCollector;", "Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;", "logger", "Lnet/codinux/util/stopwatch/output/MessageLogger;", "timeFormatter", "Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "(Lnet/codinux/util/stopwatch/output/MessageLogger;Lnet/codinux/util/stopwatch/formatter/TimeFormatter;)V", "stats", "Lnet/codinux/util/stopwatch/collections/ConcurrentMap;", "", "Lnet/codinux/util/stopwatch/collections/ConcurrentList;", "Lnet/codinux/util/stopwatch/Duration;", "getStats", "()Lnet/codinux/util/stopwatch/collections/ConcurrentMap;", "addElapsedTime", "", "task", "elapsed", "getMeasuredDurationsFor", "", "getStatisticsFor", "Lnet/codinux/util/stopwatch/statistics/TaskStatistics;", "logAllStatistics", "logStatistics", "Stopwatch"})
@SourceDebugExtension(value={"SMAP\nDefaultTaskStatisticsCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultTaskStatisticsCollector.kt\nnet/codinux/util/stopwatch/statistics/DefaultTaskStatisticsCollector\n+ 2 ConcurrentList.kt\nnet/codinux/util/stopwatch/collections/ConcurrentListKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n20#2,5:69\n1549#3:74\n1620#3,3:75\n1855#3,2:78\n*S KotlinDebug\n*F\n+ 1 DefaultTaskStatisticsCollector.kt\nnet/codinux/util/stopwatch/statistics/DefaultTaskStatisticsCollector\n*L\n32#1:69,5\n41#1:74\n41#1:75,3\n53#1:78,2\n*E\n"})
public class DefaultTaskStatisticsCollector
implements TaskStatisticsCollector {
    @NotNull
    private final MessageLogger logger;
    @NotNull
    private final TimeFormatter timeFormatter;
    @NotNull
    private final ConcurrentMap<String, ConcurrentList<Duration>> stats;

    public DefaultTaskStatisticsCollector(@NotNull MessageLogger logger, @NotNull TimeFormatter timeFormatter) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)timeFormatter, (String)"timeFormatter");
        this.logger = logger;
        this.timeFormatter = timeFormatter;
        this.stats = new ConcurrentMap();
    }

    @NotNull
    protected ConcurrentMap<String, ConcurrentList<Duration>> getStats() {
        return this.stats;
    }

    @Override
    public void addElapsedTime(@NotNull String task, @NotNull Duration elapsed) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)elapsed, (String)"elapsed");
        this.getStats().getOrPut(task, (Function0<ConcurrentList<Duration>>)((Function0)addElapsedTime.1.INSTANCE)).add(elapsed);
    }

    @Override
    @Nullable
    public List<Duration> getMeasuredDurationsFor(@NotNull String task) {
        ConcurrentList<Duration> taskStats;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        ConcurrentList<Duration> $this$isNullOrEmpty$iv = taskStats = this.getStats().get(task);
        boolean $i$f$isNullOrEmpty = false;
        return $this$isNullOrEmpty$iv == null || $this$isNullOrEmpty$iv.isEmpty() ? null : (List)new ArrayList<Duration>(taskStats.asCollection());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public TaskStatistics getStatisticsFor(@NotNull String task) {
        TaskStatistics taskStatistics;
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        List<Duration> list = this.getMeasuredDurationsFor(task);
        if (list != null) {
            void $this$mapTo$iv$iv;
            List<Duration> measurements = list;
            boolean bl = false;
            Iterable $this$map$iv = measurements;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Duration duration = (Duration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getInWholeNanoseconds());
            }
            List measurementsNanos = (List)destination$iv$iv;
            Comparable comparable = CollectionsKt.minOrNull((Iterable)measurementsNanos);
            Intrinsics.checkNotNull((Object)comparable);
            long min = ((Number)((Object)comparable)).longValue();
            Comparable comparable2 = CollectionsKt.maxOrNull((Iterable)measurementsNanos);
            Intrinsics.checkNotNull((Object)comparable2);
            long max = ((Number)((Object)comparable2)).longValue();
            long average = (long)CollectionsKt.averageOfLong((Iterable)measurementsNanos);
            long total = CollectionsKt.sumOfLong((Iterable)measurementsNanos);
            taskStatistics = new TaskStatistics(measurements, DurationKt.toDuration(min), DurationKt.toDuration(max), DurationKt.toDuration(average), DurationKt.toDuration(total));
        } else {
            taskStatistics = null;
        }
        return taskStatistics;
    }

    @Override
    public void logAllStatistics() {
        Iterable $this$forEach$iv = CollectionsKt.sorted((Iterable)this.getStats().getKeys());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String task = (String)element$iv;
            boolean bl = false;
            this.logStatistics(task);
        }
    }

    @Override
    public void logStatistics(@NotNull String task) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            TaskStatistics taskStatistics = this.getStatisticsFor(task);
            if (taskStatistics == null) break block0;
            TaskStatistics taskStats = taskStatistics;
            boolean bl = false;
            this.logger.info(task + " [" + taskStats.getCountMeasurements() + "]: min " + this.timeFormatter.format(taskStats.getMin()) + ", avg " + this.timeFormatter.format(taskStats.getAverage()) + ", max " + this.timeFormatter.format(taskStats.getMax()) + ", total " + this.timeFormatter.format(taskStats.getTotal()));
        }
    }
}

