/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.util.stopwatch.formatter;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.codinux.util.stopwatch.Duration;
import net.codinux.util.stopwatch.formatter.TimeFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lnet/codinux/util/stopwatch/formatter/DefaultTimeFormatter;", "Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "()V", "format", "", "duration", "Lnet/codinux/util/stopwatch/Duration;", "minPlaces", "number", "", "length", "", "toMillisPart", "toNanosPart", "toSecondsPart", "Stopwatch"})
public class DefaultTimeFormatter
implements TimeFormatter {
    @Override
    @NotNull
    public String format(@NotNull Duration duration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        if (duration.getInWholeMinutes() > 0L) {
            string = this.minPlaces(duration.getInWholeMinutes(), 2) + ':' + this.minPlaces(this.toSecondsPart(duration), 2) + '.' + this.minPlaces(this.toMillisPart(duration), 3) + " min";
        } else if (duration.getInWholeSeconds() > 0L) {
            string = this.minPlaces(duration.getInWholeSeconds(), 2) + '.' + this.minPlaces(this.toMillisPart(duration), 3) + " s";
        } else if (duration.getInWholeMilliseconds() > 0L) {
            string = this.minPlaces(duration.getInWholeMilliseconds(), 2) + '.' + this.minPlaces(duration.getInWholeMicroseconds() % (long)1000, 3) + " ms";
        } else {
            long durationMicroseconds = duration.getInWholeMicroseconds();
            string = this.minPlaces(durationMicroseconds, 2) + '.' + this.minPlaces(this.toNanosPart(duration) % (long)1000, 3) + " \u03bcs";
        }
        return string;
    }

    public long toSecondsPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.getInWholeSeconds() % (long)60;
    }

    public long toMillisPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.getInWholeMilliseconds() % (long)1000;
    }

    public long toNanosPart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.getInWholeNanoseconds() % (long)1000;
    }

    @NotNull
    protected String minPlaces(long number, int length) {
        return StringsKt.padStart((String)String.valueOf(number), (int)length, (char)'0');
    }
}

