/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.util.stopwatch;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.TimeSource;
import net.codinux.util.stopwatch.Duration;
import net.codinux.util.stopwatch.DurationUnit;
import net.codinux.util.stopwatch.formatter.DefaultTimeFormatter;
import net.codinux.util.stopwatch.formatter.TimeFormatter;
import net.codinux.util.stopwatch.output.KmpLogMessageLogger;
import net.codinux.util.stopwatch.output.MessageLogger;
import net.codinux.util.stopwatch.statistics.DefaultTaskStatisticsCollector;
import net.codinux.util.stopwatch.statistics.TaskStatisticsCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 <2\u00020\u0001:\u0001<B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010,\u001a\u00020\rH\u0014J\b\u0010-\u001a\u00020.H\u0014J\b\u0010/\u001a\u00020+H\u0016J\u0010\u0010\u000e\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0016J\u0010\u00102\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J$\u00102\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010(\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u0003H\u0016J\u0010\u00104\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u00105\u001a\u00020)H\u0016J\b\u00106\u001a\u00020\rH\u0016J\u001a\u00107\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u00103\u001a\u00020\u0003H\u0016J\b\u00108\u001a\u00020+H\u0016J\u0010\u00109\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J$\u00109\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\b\b\u0002\u0010(\u001a\u00020\u00032\b\b\u0002\u00103\u001a\u00020\u0003H\u0016J\b\u0010:\u001a\u00020\u0015H\u0016J\b\u0010;\u001a\u00020+H\u0016R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0084\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006="}, d2={"Lnet/codinux/util/stopwatch/Stopwatch;", "", "createStarted", "", "(Z)V", "logger", "Lnet/codinux/util/stopwatch/output/MessageLogger;", "timeFormatter", "Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "statisticsCollector", "Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;", "(ZLnet/codinux/util/stopwatch/output/MessageLogger;Lnet/codinux/util/stopwatch/formatter/TimeFormatter;Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;)V", "elapsed", "Lnet/codinux/util/stopwatch/Duration;", "getElapsed", "()Lnet/codinux/util/stopwatch/Duration;", "elapsedDurationWhenStopped", "getElapsedDurationWhenStopped", "setElapsedDurationWhenStopped", "(Lnet/codinux/util/stopwatch/Duration;)V", "elapsedNanos", "", "getElapsedNanos", "()J", "<set-?>", "isRunning", "()Z", "setRunning", "getLogger", "()Lnet/codinux/util/stopwatch/output/MessageLogger;", "startedAt", "Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "getStartedAt-LFT3Okc", "()Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;", "setStartedAt-rEXM0dE", "(Lkotlin/time/TimeSource$Monotonic$ValueTimeMark;)V", "getStatisticsCollector", "()Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;", "getTimeFormatter", "()Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "addToStatistics", "", "task", "", "calculateDuration", "createStopwatchHasNotBeenStartedException", "", "formatElapsedTime", "desiredUnit", "Lnet/codinux/util/stopwatch/DurationUnit;", "logElapsedTime", "logStatisticsNow", "logStatistics", "start", "stop", "stopAndAddToStatistics", "stopAndFormat", "stopAndLog", "stopNanos", "toString", "Companion", "Stopwatch"})
@SourceDebugExtension(value={"SMAP\nStopwatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stopwatch.kt\nnet/codinux/util/stopwatch/Stopwatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public class Stopwatch {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageLogger logger;
    @NotNull
    private final TimeFormatter timeFormatter;
    @NotNull
    private final TaskStatisticsCollector statisticsCollector;
    private boolean isRunning;
    @Nullable
    private TimeSource.Monotonic.ValueTimeMark startedAt;
    @Nullable
    private Duration elapsedDurationWhenStopped;
    @NotNull
    private static TimeFormatter DefaultTimeFormatter = new DefaultTimeFormatter();
    @NotNull
    private static MessageLogger DefaultLogger = new KmpLogMessageLogger(Reflection.getOrCreateKotlinClass(Stopwatch.class));
    @NotNull
    private static TaskStatisticsCollector DefaultStatisticsCollector = new DefaultTaskStatisticsCollector(DefaultLogger, DefaultTimeFormatter);
    public static final boolean DefaultAddToStatistics = false;
    public static final boolean DefaultLogStatisticsNow = false;

    public Stopwatch(boolean createStarted, @NotNull MessageLogger logger, @NotNull TimeFormatter timeFormatter, @NotNull TaskStatisticsCollector statisticsCollector) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)timeFormatter, (String)"timeFormatter");
        Intrinsics.checkNotNullParameter((Object)statisticsCollector, (String)"statisticsCollector");
        this.logger = logger;
        this.timeFormatter = timeFormatter;
        this.statisticsCollector = statisticsCollector;
        if (createStarted) {
            this.start();
        }
    }

    public /* synthetic */ Stopwatch(boolean bl, MessageLogger messageLogger, TimeFormatter timeFormatter, TaskStatisticsCollector taskStatisticsCollector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            messageLogger = DefaultLogger;
        }
        if ((n & 4) != 0) {
            timeFormatter = DefaultTimeFormatter;
        }
        if ((n & 8) != 0) {
            taskStatisticsCollector = DefaultStatisticsCollector;
        }
        this(bl, messageLogger, timeFormatter, taskStatisticsCollector);
    }

    @NotNull
    protected MessageLogger getLogger() {
        return this.logger;
    }

    @NotNull
    protected TimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    @NotNull
    protected TaskStatisticsCollector getStatisticsCollector() {
        return this.statisticsCollector;
    }

    public Stopwatch(boolean createStarted) {
        this(createStarted, DefaultLogger, null, null, 12, null);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    protected void setRunning(boolean bl) {
        this.isRunning = bl;
    }

    @Nullable
    protected final TimeSource.Monotonic.ValueTimeMark getStartedAt-LFT3Okc() {
        return this.startedAt;
    }

    protected final void setStartedAt-rEXM0dE(@Nullable TimeSource.Monotonic.ValueTimeMark valueTimeMark) {
        this.startedAt = valueTimeMark;
    }

    @Nullable
    protected final Duration getElapsedDurationWhenStopped() {
        return this.elapsedDurationWhenStopped;
    }

    protected final void setElapsedDurationWhenStopped(@Nullable Duration duration) {
        this.elapsedDurationWhenStopped = duration;
    }

    @NotNull
    public Duration getElapsed() {
        Duration duration = this.elapsedDurationWhenStopped;
        if (duration != null) {
            Duration it = duration;
            boolean bl = false;
            return it;
        }
        if (this.isRunning()) {
            return this.calculateDuration();
        }
        return Duration.Companion.getZero();
    }

    public long getElapsedNanos() {
        return this.getElapsed().getInWholeNanoseconds();
    }

    public void start() {
        this.elapsedDurationWhenStopped = null;
        this.setRunning(true);
        this.startedAt = TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto());
    }

    @NotNull
    public Duration stop() {
        if (this.isRunning()) {
            this.elapsedDurationWhenStopped = this.calculateDuration();
            this.setRunning(false);
        }
        return this.getElapsed();
    }

    public long stopNanos() {
        this.stop();
        return this.getElapsedNanos();
    }

    @NotNull
    public String stopAndFormat() {
        this.stop();
        return this.formatElapsedTime();
    }

    public void stopAndLog(@NotNull String task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Stopwatch.stopAndLog$default(this, task, false, false, 4, null);
    }

    public void stopAndLog(@NotNull String task, boolean addToStatistics, boolean logStatisticsNow) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.stop();
        this.logElapsedTime(task, addToStatistics, logStatisticsNow);
    }

    public static /* synthetic */ void stopAndLog$default(Stopwatch stopwatch, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopAndLog");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        stopwatch.stopAndLog(string, bl, bl2);
    }

    public long getElapsed(@NotNull DurationUnit desiredUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)desiredUnit), (String)"desiredUnit");
        return this.getElapsed().toLong(desiredUnit);
    }

    @NotNull
    protected Duration calculateDuration() {
        kotlin.time.Duration elapsed;
        TimeSource.Monotonic.ValueTimeMark valueTimeMark = this.startedAt;
        kotlin.time.Duration duration = elapsed = valueTimeMark != null ? kotlin.time.Duration.box-impl((long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)valueTimeMark.unbox-impl())) : null;
        if (this.startedAt == null || elapsed == null) {
            throw this.createStopwatchHasNotBeenStartedException();
        }
        return new Duration(kotlin.time.Duration.getInWholeNanoseconds-impl((long)elapsed.unbox-impl()));
    }

    @NotNull
    protected Throwable createStopwatchHasNotBeenStartedException() {
        return new IllegalStateException("Stopwatch has not been started. Start Stopwatch before calling [stop()] or [elapsed] on it.");
    }

    @NotNull
    public String formatElapsedTime() {
        return this.getTimeFormatter().format(this.getElapsed());
    }

    public void logElapsedTime(@NotNull String task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Stopwatch.logElapsedTime$default(this, task, false, false, 4, null);
    }

    public void logElapsedTime(@NotNull String task, boolean addToStatistics, boolean logStatisticsNow) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        String formattedElapsedTime = this.formatElapsedTime();
        this.getLogger().info(task + " took " + formattedElapsedTime);
        if (addToStatistics) {
            this.addToStatistics(task, this.getElapsed());
        }
        if (logStatisticsNow) {
            this.logStatistics(task);
        }
    }

    public static /* synthetic */ void logElapsedTime$default(Stopwatch stopwatch, String string, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logElapsedTime");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        stopwatch.logElapsedTime(string, bl, bl2);
    }

    public void stopAndAddToStatistics(@NotNull String task, boolean logStatisticsNow) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Duration elapsed = this.stop();
        this.addToStatistics(task, elapsed);
        if (logStatisticsNow) {
            this.logStatistics(task);
        }
    }

    public static /* synthetic */ void stopAndAddToStatistics$default(Stopwatch stopwatch, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: stopAndAddToStatistics");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        stopwatch.stopAndAddToStatistics(string, bl);
    }

    protected void addToStatistics(@NotNull String task, @NotNull Duration elapsed) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)elapsed, (String)"elapsed");
        this.getStatisticsCollector().addElapsedTime(task, elapsed);
    }

    public void logStatistics(@NotNull String task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        this.getStatisticsCollector().logStatistics(task);
    }

    @NotNull
    public String toString() {
        if (this.isRunning()) {
            return "Running, " + this.formatElapsedTime() + " elapsed";
        }
        return "Stopped, " + this.formatElapsedTime() + " elapsed";
    }

    public Stopwatch() {
        this(false, null, null, null, 15, null);
    }

    @NotNull
    public static final TimeFormatter getDefaultTimeFormatter() {
        return Companion.getDefaultTimeFormatter();
    }

    public static final void setDefaultTimeFormatter(@NotNull TimeFormatter timeFormatter) {
        Companion.setDefaultTimeFormatter(timeFormatter);
    }

    @NotNull
    public static final MessageLogger getDefaultLogger() {
        return Companion.getDefaultLogger();
    }

    public static final void setDefaultLogger(@NotNull MessageLogger messageLogger) {
        Companion.setDefaultLogger(messageLogger);
    }

    @NotNull
    public static final TaskStatisticsCollector getDefaultStatisticsCollector() {
        return Companion.getDefaultStatisticsCollector();
    }

    public static final void setDefaultStatisticsCollector(@NotNull TaskStatisticsCollector taskStatisticsCollector) {
        Companion.setDefaultStatisticsCollector(taskStatisticsCollector);
    }

    @JvmStatic
    @NotNull
    public static final Duration measureDuration(@NotNull Function0<Unit> task) {
        return Companion.measureDuration(task);
    }

    @JvmStatic
    @NotNull
    public static final String formatDuration(@NotNull Function0<Unit> task) {
        return Companion.formatDuration(task);
    }

    @JvmStatic
    public static final <T> T logDuration(@NotNull String taskName, @NotNull Function0<? extends T> task) {
        return Companion.logDuration(taskName, task);
    }

    @JvmStatic
    public static final <T> T logDuration(@NotNull String taskName, boolean addToStatistics, boolean logStatisticsNow, @NotNull Function0<? extends T> task) {
        return Companion.logDuration(taskName, addToStatistics, logStatisticsNow, task);
    }

    @JvmStatic
    public static final <T> T measureAndToStatistics(@NotNull String taskName, @NotNull Function0<? extends T> task) {
        return Companion.measureAndToStatistics(taskName, task);
    }

    @JvmStatic
    public static final <T> T measureAndToStatistics(@NotNull String taskName, boolean logStatisticsNow, @NotNull Function0<? extends T> task) {
        return Companion.measureAndToStatistics(taskName, logStatisticsNow, task);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0087\b\u00f8\u0001\u0000J\u0006\u0010 \u001a\u00020\u001fJ-\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\"0\u001eH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$JA\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u001c2\b\b\u0002\u0010%\u001a\u00020\u00042\b\b\u0002\u0010&\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\"0\u001eH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u000e\u0010(\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u001cJ-\u0010)\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\"0\u001eH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J7\u0010)\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2\u0006\u0010#\u001a\u00020\u001c2\b\b\u0002\u0010&\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\"0\u001eH\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010*J\u001a\u0010+\u001a\u00020,2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0087\b\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00158\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0016\u0010\u0002\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006-"}, d2={"Lnet/codinux/util/stopwatch/Stopwatch$Companion;", "", "()V", "DefaultAddToStatistics", "", "DefaultLogStatisticsNow", "DefaultLogger", "Lnet/codinux/util/stopwatch/output/MessageLogger;", "getDefaultLogger$annotations", "getDefaultLogger", "()Lnet/codinux/util/stopwatch/output/MessageLogger;", "setDefaultLogger", "(Lnet/codinux/util/stopwatch/output/MessageLogger;)V", "DefaultStatisticsCollector", "Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;", "getDefaultStatisticsCollector$annotations", "getDefaultStatisticsCollector", "()Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;", "setDefaultStatisticsCollector", "(Lnet/codinux/util/stopwatch/statistics/TaskStatisticsCollector;)V", "DefaultTimeFormatter", "Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "getDefaultTimeFormatter$annotations", "getDefaultTimeFormatter", "()Lnet/codinux/util/stopwatch/formatter/TimeFormatter;", "setDefaultTimeFormatter", "(Lnet/codinux/util/stopwatch/formatter/TimeFormatter;)V", "formatDuration", "", "task", "Lkotlin/Function0;", "", "logAllStatistics", "logDuration", "T", "taskName", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "addToStatistics", "logStatisticsNow", "(Ljava/lang/String;ZZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "logStatistics", "measureAndToStatistics", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "measureDuration", "Lnet/codinux/util/stopwatch/Duration;", "Stopwatch"})
    @SourceDebugExtension(value={"SMAP\nStopwatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stopwatch.kt\nnet/codinux/util/stopwatch/Stopwatch$Companion\n*L\n1#1,288:1\n71#1,7:289\n96#1,7:296\n*S KotlinDebug\n*F\n+ 1 Stopwatch.kt\nnet/codinux/util/stopwatch/Stopwatch$Companion\n*L\n67#1:289,7\n88#1:296,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeFormatter getDefaultTimeFormatter() {
            return DefaultTimeFormatter;
        }

        public final void setDefaultTimeFormatter(@NotNull TimeFormatter timeFormatter) {
            Intrinsics.checkNotNullParameter((Object)timeFormatter, (String)"<set-?>");
            DefaultTimeFormatter = timeFormatter;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultTimeFormatter$annotations() {
        }

        @NotNull
        public final MessageLogger getDefaultLogger() {
            return DefaultLogger;
        }

        public final void setDefaultLogger(@NotNull MessageLogger messageLogger) {
            Intrinsics.checkNotNullParameter((Object)messageLogger, (String)"<set-?>");
            DefaultLogger = messageLogger;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultLogger$annotations() {
        }

        @NotNull
        public final TaskStatisticsCollector getDefaultStatisticsCollector() {
            return DefaultStatisticsCollector;
        }

        public final void setDefaultStatisticsCollector(@NotNull TaskStatisticsCollector taskStatisticsCollector) {
            Intrinsics.checkNotNullParameter((Object)taskStatisticsCollector, (String)"<set-?>");
            DefaultStatisticsCollector = taskStatisticsCollector;
        }

        @JvmStatic
        public static /* synthetic */ void getDefaultStatisticsCollector$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Duration measureDuration(@NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$measureDuration = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            task.invoke();
            return stopwatch.stop();
        }

        @JvmStatic
        @NotNull
        public final String formatDuration(@NotNull Function0<Unit> task) {
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$formatDuration = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            task.invoke();
            return stopwatch.stopAndFormat();
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final <T> T logDuration(@NotNull String taskName, @NotNull Function0<? extends T> task) {
            void addToStatistics$iv;
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$logDuration = false;
            Companion companion = this;
            boolean bl = false;
            boolean logStatisticsNow$iv = false;
            boolean $i$f$logDuration2 = false;
            Stopwatch stopwatch$iv = new Stopwatch(false, null, null, null, 15, null);
            Object result$iv = task.invoke();
            stopwatch$iv.stopAndLog(taskName, (boolean)addToStatistics$iv, logStatisticsNow$iv);
            return (T)result$iv;
        }

        @JvmStatic
        public final <T> T logDuration(@NotNull String taskName, boolean addToStatistics, boolean logStatisticsNow, @NotNull Function0<? extends T> task) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$logDuration = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            Object result = task.invoke();
            stopwatch.stopAndLog(taskName, addToStatistics, logStatisticsNow);
            return (T)result;
        }

        public static /* synthetic */ Object logDuration$default(Companion $this, String taskName, boolean addToStatistics, boolean logStatisticsNow, Function0 task, int n, Object object) {
            if ((n & 2) != 0) {
                addToStatistics = false;
            }
            if ((n & 4) != 0) {
                logStatisticsNow = false;
            }
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            boolean $i$f$logDuration = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            Object result = task.invoke();
            stopwatch.stopAndLog(taskName, addToStatistics, logStatisticsNow);
            return result;
        }

        @JvmStatic
        public final <T> T measureAndToStatistics(@NotNull String taskName, @NotNull Function0<? extends T> task) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$measureAndToStatistics = false;
            Companion companion = this;
            boolean logStatisticsNow$iv = false;
            boolean $i$f$measureAndToStatistics2 = false;
            Stopwatch stopwatch$iv = new Stopwatch(false, null, null, null, 15, null);
            Object result$iv = task.invoke();
            stopwatch$iv.stopAndAddToStatistics(taskName, logStatisticsNow$iv);
            return (T)result$iv;
        }

        @JvmStatic
        public final <T> T measureAndToStatistics(@NotNull String taskName, boolean logStatisticsNow, @NotNull Function0<? extends T> task) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter(task, (String)"task");
            boolean $i$f$measureAndToStatistics = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            Object result = task.invoke();
            stopwatch.stopAndAddToStatistics(taskName, logStatisticsNow);
            return (T)result;
        }

        public static /* synthetic */ Object measureAndToStatistics$default(Companion $this, String taskName, boolean logStatisticsNow, Function0 task, int n, Object object) {
            if ((n & 2) != 0) {
                logStatisticsNow = false;
            }
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            boolean $i$f$measureAndToStatistics = false;
            Stopwatch stopwatch = new Stopwatch(false, null, null, null, 15, null);
            Object result = task.invoke();
            stopwatch.stopAndAddToStatistics(taskName, logStatisticsNow);
            return result;
        }

        public final void logStatistics(@NotNull String task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            this.getDefaultStatisticsCollector().logStatistics(task);
        }

        public final void logAllStatistics() {
            this.getDefaultStatisticsCollector().logAllStatistics();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

