/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.util.stopwatch;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.util.stopwatch.DurationUnit;
import net.codinux.util.stopwatch.formatter.DefaultTimeFormatter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b#\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010(\u001a\u00020)H\u0016R\u001b\u0010\t\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0012\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001b\u0010\u0016\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0017\u0010\u000bR\u001b\u0010\u0019\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\r\u001a\u0004\b\u001a\u0010\u000bR\u001b\u0010\u001c\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\r\u001a\u0004\b\u001d\u0010\u000bR\u001b\u0010\u001f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\r\u001a\u0004\b \u0010\u000bR\u001b\u0010\"\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\r\u001a\u0004\b#\u0010\u000b\u00a8\u0006+"}, d2={"Lnet/codinux/util/stopwatch/Duration;", "", "valueInUnit", "", "unit", "Lnet/codinux/util/stopwatch/DurationUnit;", "(JLnet/codinux/util/stopwatch/DurationUnit;)V", "nanoseconds", "(J)V", "inWholeMicroseconds", "getInWholeMicroseconds", "()J", "inWholeMicroseconds$delegate", "Lkotlin/Lazy;", "inWholeMilliseconds", "getInWholeMilliseconds", "inWholeMilliseconds$delegate", "inWholeMinutes", "getInWholeMinutes", "inWholeMinutes$delegate", "inWholeNanoseconds", "getInWholeNanoseconds", "inWholeSeconds", "getInWholeSeconds", "inWholeSeconds$delegate", "microsecondsPart", "getMicrosecondsPart", "microsecondsPart$delegate", "millisecondsPart", "getMillisecondsPart", "millisecondsPart$delegate", "nanosecondsPart", "getNanosecondsPart", "nanosecondsPart$delegate", "secondsPart", "getSecondsPart", "secondsPart$delegate", "plus", "other", "toLong", "toString", "", "Companion", "Stopwatch"})
public final class Duration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy inWholeMinutes$delegate;
    @NotNull
    private final Lazy inWholeSeconds$delegate;
    @NotNull
    private final Lazy secondsPart$delegate;
    @NotNull
    private final Lazy inWholeMilliseconds$delegate;
    @NotNull
    private final Lazy millisecondsPart$delegate;
    @NotNull
    private final Lazy inWholeMicroseconds$delegate;
    @NotNull
    private final Lazy microsecondsPart$delegate;
    private final long inWholeNanoseconds;
    @NotNull
    private final Lazy nanosecondsPart$delegate;
    @NotNull
    private static final Duration Zero = new Duration(0L);

    public Duration(long nanoseconds) {
        this.inWholeMinutes$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeSeconds() / (long)60;
            }
        }));
        this.inWholeSeconds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeMilliseconds() / (long)1000;
            }
        }));
        this.secondsPart$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeSeconds() % (long)60;
            }
        }));
        this.inWholeMilliseconds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeMicroseconds() / (long)1000;
            }
        }));
        this.millisecondsPart$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeMilliseconds() % (long)1000;
            }
        }));
        this.inWholeMicroseconds$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeNanoseconds() / (long)1000;
            }
        }));
        this.microsecondsPart$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeMicroseconds() % (long)1000;
            }
        }));
        this.inWholeNanoseconds = nanoseconds;
        this.nanosecondsPart$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Long>(this){
            final /* synthetic */ Duration this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Long invoke() {
                return this.this$0.getInWholeNanoseconds() % (long)1000;
            }
        }));
    }

    public Duration(long valueInUnit, @NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        this(valueInUnit * unit.getNanosecondsFactor());
    }

    public final long getInWholeMinutes() {
        Lazy lazy = this.inWholeMinutes$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getInWholeSeconds() {
        Lazy lazy = this.inWholeSeconds$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getSecondsPart() {
        Lazy lazy = this.secondsPart$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getInWholeMilliseconds() {
        Lazy lazy = this.inWholeMilliseconds$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getMillisecondsPart() {
        Lazy lazy = this.millisecondsPart$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getInWholeMicroseconds() {
        Lazy lazy = this.inWholeMicroseconds$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getMicrosecondsPart() {
        Lazy lazy = this.microsecondsPart$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long getInWholeNanoseconds() {
        return this.inWholeNanoseconds;
    }

    public final long getNanosecondsPart() {
        Lazy lazy = this.nanosecondsPart$delegate;
        return ((Number)lazy.getValue()).longValue();
    }

    public final long toLong(@NotNull DurationUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.inWholeNanoseconds / unit.getNanosecondsFactor();
    }

    @NotNull
    public final Duration plus(@NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Duration(this.inWholeNanoseconds + other.inWholeNanoseconds);
    }

    @NotNull
    public String toString() {
        return new DefaultTimeFormatter().format(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/codinux/util/stopwatch/Duration$Companion;", "", "()V", "Zero", "Lnet/codinux/util/stopwatch/Duration;", "getZero", "()Lnet/codinux/util/stopwatch/Duration;", "Stopwatch"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getZero() {
            return Zero;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

