/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import net.codinux.log.ConfigurableUnsynchronizedAppenderBase;
import net.codinux.log.LogWriter;
import net.codinux.log.config.LogAppenderConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H&J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lnet/codinux/log/LogbackAppenderBase;", "Lnet/codinux/log/ConfigurableUnsynchronizedAppenderBase;", "config", "Lnet/codinux/log/config/LogAppenderConfig;", "(Lnet/codinux/log/config/LogAppenderConfig;)V", "eventSupportsInstant", "", "getEventSupportsInstant", "()Z", "logWriter", "Lnet/codinux/log/LogWriter;", "getLogWriter", "()Lnet/codinux/log/LogWriter;", "setLogWriter", "(Lnet/codinux/log/LogWriter;)V", "append", "", "event", "Lch/qos/logback/classic/spi/ILoggingEvent;", "createLogWriter", "getThrowable", "", "start", "stop", "tryToInstantiateThrowable", "proxy", "Lch/qos/logback/classic/spi/IThrowableProxy;", "LogbackAppenderBase"})
@SourceDebugExtension(value={"SMAP\nLogbackAppenderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogbackAppenderBase.kt\nnet/codinux/log/LogbackAppenderBase\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n1282#2,2:88\n11335#2:90\n11670#2,3:91\n37#3,2:94\n*S KotlinDebug\n*F\n+ 1 LogbackAppenderBase.kt\nnet/codinux/log/LogbackAppenderBase\n*L\n73#1:88,2\n77#1:90\n77#1:91,3\n77#1:94,2\n*E\n"})
public abstract class LogbackAppenderBase
extends ConfigurableUnsynchronizedAppenderBase {
    @Nullable
    private LogWriter logWriter;
    private final boolean eventSupportsInstant;

    public LogbackAppenderBase(@NotNull LogAppenderConfig config) {
        boolean bl;
        LogbackAppenderBase logbackAppenderBase;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config);
        LogbackAppenderBase logbackAppenderBase2 = this;
        try {
            logbackAppenderBase = logbackAppenderBase2;
            ILoggingEvent.class.getDeclaredMethod("getInstant", new Class[0]);
            bl = true;
        }
        catch (Exception exception) {
            logbackAppenderBase = logbackAppenderBase2;
            bl = false;
        }
        logbackAppenderBase.eventSupportsInstant = bl;
    }

    public /* synthetic */ LogbackAppenderBase(LogAppenderConfig logAppenderConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            logAppenderConfig = new LogAppenderConfig(false, null, null, null, 15, null);
        }
        this(logAppenderConfig);
    }

    @Nullable
    protected final LogWriter getLogWriter() {
        return this.logWriter;
    }

    protected final void setLogWriter(@Nullable LogWriter logWriter) {
        this.logWriter = logWriter;
    }

    protected boolean getEventSupportsInstant() {
        return this.eventSupportsInstant;
    }

    @NotNull
    public abstract LogWriter createLogWriter(@NotNull LogAppenderConfig var1);

    public void start() {
        if (this.getConfig().getEnabled()) {
            this.logWriter = this.createLogWriter(this.getConfig());
        }
        super.start();
    }

    protected void append(@Nullable ILoggingEvent event) {
        block5: {
            if (!this.getConfig().getEnabled() || event == null) break block5;
            LogWriter logWriter = this.logWriter;
            if (logWriter != null) {
                String string;
                kotlinx.datetime.Instant instant;
                if (this.getEventSupportsInstant()) {
                    Instant instant2 = event.getInstant();
                    Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"event.instant");
                    instant = ConvertersKt.toKotlinInstant((Instant)instant2);
                } else {
                    instant = kotlinx.datetime.Instant.Companion.fromEpochMilliseconds(event.getTimeStamp());
                }
                String string2 = event.getLevel().levelStr;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"event.level.levelStr");
                String string3 = event.getFormattedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"event.formattedMessage");
                String string4 = this.getFields().getLogsLoggerName() ? event.getLoggerName() : null;
                String string5 = this.getFields().getLogsThreadName() ? event.getThreadName() : null;
                Throwable throwable = this.getFields().getLogsException() ? this.getThrowable(event) : null;
                Map map = this.getFields().getLogsMdc() ? event.getMDCPropertyMap() : null;
                if (this.getFields().getLogsMarker()) {
                    Marker marker = event.getMarker();
                    string = marker != null ? marker.getName() : null;
                } else {
                    string = null;
                }
                LogWriter.DefaultImpls.writeRecord$default((LogWriter)logWriter, (kotlinx.datetime.Instant)instant, (String)string2, (String)string3, (String)string4, (String)string5, (Throwable)throwable, (Map)map, (String)string, null, (int)256, null);
            }
        }
    }

    public void stop() {
        LogWriter logWriter = this.logWriter;
        if (logWriter != null) {
            logWriter.close();
        }
        super.stop();
    }

    @Nullable
    protected Throwable getThrowable(@NotNull ILoggingEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            IThrowableProxy proxy = iThrowableProxy;
            boolean bl = false;
            if (proxy instanceof ThrowableProxy) {
                return ((ThrowableProxy)proxy).getThrowable();
            }
            return this.tryToInstantiateThrowable(proxy);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Throwable tryToInstantiateThrowable(@NotNull IThrowableProxy proxy) {
        Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Object object;
            block8: {
                Class<?> throwableClass;
                block7: {
                    Object object2;
                    block6: {
                        throwableClass = Class.forName(proxy.getClassName());
                        Constructor<?>[] constructorArray = throwableClass.getDeclaredConstructors();
                        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"throwableClass.declaredConstructors");
                        Object[] $this$firstOrNull$iv = constructorArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Constructor it = (Constructor)element$iv;
                            boolean bl = false;
                            if (!(it.getParameterCount() == 1 && Intrinsics.areEqual(it.getParameterTypes()[0], String.class))) continue;
                            object2 = element$iv;
                            break block6;
                        }
                        object2 = null;
                    }
                    if ((object = (Constructor)object2) == null) break block7;
                    Constructor constructor = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{proxy.getMessage()};
                    Object t = constructor.newInstance(objectArray);
                    Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type kotlin.Throwable");
                    Throwable throwable = (Throwable)t;
                    object = throwable;
                    if (throwable != null) break block8;
                }
                Object obj = throwableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Throwable");
                object = (Throwable)obj;
            }
            Object throwable = object;
            StackTraceElementProxy[] stackTraceElementProxyArray = proxy.getStackTraceElementProxyArray();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementProxyArray, (String)"proxy.stackTraceElementProxyArray");
            Object[] objectArray = stackTraceElementProxyArray;
            Object object3 = throwable;
            boolean $i$f$map = false;
            void $i$f$firstOrNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                StackTraceElementProxy stackTraceElementProxy = (StackTraceElementProxy)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getStackTraceElement());
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ((Throwable)object3).setStackTrace(thisCollection$iv.toArray(new StackTraceElement[0]));
            return throwable;
        }
        catch (Exception e) {
            block9: {
                LogWriter logWriter = this.logWriter;
                if (logWriter == null || (logWriter = logWriter.getStateLogger()) == null) break block9;
                logWriter.error("Could not get Throwable from IThrowableProxy", (Throwable)e);
            }
            return null;
        }
    }

    public LogbackAppenderBase() {
        this(null, 1, null);
    }
}

