package net.codinux.log.config

interface CostlyFieldsConfig {

    val logsLoggerName: Boolean

    val logsThreadName: Boolean

    val logsException: Boolean

    val logsMdc: Boolean

    val logsMarker: Boolean

    val logsNdc: Boolean


    companion object {
        val None: CostlyFieldsConfig = object : CostlyFieldsConfig {
            override val logsLoggerName: Boolean = false
            override val logsThreadName: Boolean = false
            override val logsException: Boolean = false
            override val logsMdc: Boolean = false
            override val logsMarker: Boolean = false
            override val logsNdc: Boolean = false
        }

        val All: CostlyFieldsConfig = object : CostlyFieldsConfig {
            override val logsLoggerName: Boolean = true
            override val logsThreadName: Boolean = true
            override val logsException: Boolean = true
            override val logsMdc: Boolean = true
            override val logsMarker: Boolean = true
            override val logsNdc: Boolean = true
        }
    }

}