/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log;

import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import net.codinux.log.LogWriter;
import net.codinux.log.config.LogAppenderFieldsConfig;
import org.jboss.logmanager.ExtFormatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lnet/codinux/log/JBossLoggingAppenderBase;", "Lorg/jboss/logmanager/ExtHandler;", "logWriter", "Lnet/codinux/log/LogWriter;", "(Lnet/codinux/log/LogWriter;)V", "config", "Lnet/codinux/log/config/LogAppenderFieldsConfig;", "getConfig", "()Lnet/codinux/log/config/LogAppenderFieldsConfig;", "isAppenderEnabled", "", "()Z", "getLogWriter", "()Lnet/codinux/log/LogWriter;", "close", "", "doPublish", "record", "Lorg/jboss/logmanager/ExtLogRecord;", "flush", "JBossLoggingAppenderBase"})
public class JBossLoggingAppenderBase
extends ExtHandler {
    @NotNull
    private final LogWriter logWriter;
    private final boolean isAppenderEnabled;
    @NotNull
    private final LogAppenderFieldsConfig config;

    public JBossLoggingAppenderBase(@NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.logWriter = logWriter;
        this.isAppenderEnabled = this.getLogWriter().getConfig().getEnabled();
        this.config = this.getLogWriter().getConfig().getFields();
        this.setFormatter((Formatter)new ExtFormatter(){

            @NotNull
            public String format(@NotNull ExtLogRecord record) {
                Intrinsics.checkNotNullParameter((Object)record, (String)"record");
                String string = this.formatMessage((LogRecord)record);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatMessage(record)");
                return string;
            }
        });
    }

    @NotNull
    protected LogWriter getLogWriter() {
        return this.logWriter;
    }

    protected boolean isAppenderEnabled() {
        return this.isAppenderEnabled;
    }

    @NotNull
    protected LogAppenderFieldsConfig getConfig() {
        return this.config;
    }

    protected void doPublish(@Nullable ExtLogRecord record) {
        if (this.isAppenderEnabled() && record != null) {
            String string;
            CharSequence charSequence;
            String message = this.getFormatter().formatMessage((LogRecord)record);
            String ndc = this.getConfig().getLogsNdc() && !((charSequence = (CharSequence)record.getNdc()) == null || StringsKt.isBlank((CharSequence)charSequence)) ? record.getNdc() : null;
            LogWriter logWriter = this.getLogWriter();
            java.time.Instant instant = record.getInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"record.instant");
            Instant instant2 = ConvertersKt.toKotlinInstant((java.time.Instant)instant);
            String string2 = record.getLevel().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"record.level.name");
            Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
            String string3 = this.getConfig().getLogsLoggerName() ? record.getLoggerName() : null;
            String string4 = this.getConfig().getLogsThreadName() ? record.getThreadName() : null;
            Throwable throwable = this.getConfig().getLogsException() ? record.getThrown() : null;
            Map map = this.getConfig().getLogsMdc() ? record.getMdcCopy() : null;
            if (this.getConfig().getLogsMarker()) {
                Object object = record.getMarker();
                string = object != null ? object.toString() : null;
            } else {
                string = null;
            }
            logWriter.writeRecord(instant2, string2, message, string3, string4, throwable, map, string, ndc);
        }
    }

    public void flush() {
        this.getLogWriter().flush();
    }

    public void close() {
        this.getLogWriter().close();
    }
}

