/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log.statelogger;

import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.codinux.log.statelogger.AppenderStateLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0013\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0016R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lnet/codinux/log/statelogger/JavaUtilLogStateLogger;", "Lnet/codinux/log/statelogger/AppenderStateLogger;", "loggerClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)V", "loggerName", "", "(Ljava/lang/String;)V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "error", "", "message", "e", "", "info", "warn", "JavaUtilLogAppenderBase"})
public class JavaUtilLogStateLogger
implements AppenderStateLogger {
    private final Logger log;

    public JavaUtilLogStateLogger(@NotNull String loggerName) {
        Intrinsics.checkNotNullParameter((Object)loggerName, (String)"loggerName");
        this.log = Logger.getLogger(loggerName);
    }

    public JavaUtilLogStateLogger(@NotNull Class<?> loggerClass) {
        Intrinsics.checkNotNullParameter(loggerClass, (String)"loggerClass");
        String string = loggerClass.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loggerClass.name");
        this(string);
    }

    protected Logger getLog() {
        return this.log;
    }

    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().info(message);
    }

    public void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().warning(message);
    }

    public void error(@NotNull String message, @Nullable Throwable e) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().log(Level.SEVERE, message, e);
    }
}

