/*
 * Decompiled with CFR 0.152.
 */
package net.codinux.log;

import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.Instant;
import net.codinux.log.LogWriter;
import net.codinux.log.config.LogAppenderFieldsConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lnet/codinux/log/JavaUtilLogAppenderBase;", "Ljava/util/logging/Handler;", "isAppenderEnabled", "", "logWriter", "Lnet/codinux/log/LogWriter;", "(ZLnet/codinux/log/LogWriter;)V", "config", "Lnet/codinux/log/config/LogAppenderFieldsConfig;", "getConfig", "()Lnet/codinux/log/config/LogAppenderFieldsConfig;", "()Z", "getLogWriter", "()Lnet/codinux/log/LogWriter;", "close", "", "flush", "publish", "record", "Ljava/util/logging/LogRecord;", "JavaUtilLogAppenderBase"})
public class JavaUtilLogAppenderBase
extends Handler {
    private final boolean isAppenderEnabled;
    @NotNull
    private final LogWriter logWriter;
    @NotNull
    private final LogAppenderFieldsConfig config;

    public JavaUtilLogAppenderBase(boolean isAppenderEnabled, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.isAppenderEnabled = isAppenderEnabled;
        this.logWriter = logWriter;
        this.config = this.getLogWriter().getConfig().getFields();
    }

    protected boolean isAppenderEnabled() {
        return this.isAppenderEnabled;
    }

    @NotNull
    protected LogWriter getLogWriter() {
        return this.logWriter;
    }

    @NotNull
    protected LogAppenderFieldsConfig getConfig() {
        return this.config;
    }

    @Override
    public void publish(@Nullable LogRecord record) {
        if (this.isAppenderEnabled() && record != null && this.isLoggable(record)) {
            String message = record.getMessage() == null ? "" : record.getMessage();
            String threadName = Thread.currentThread().getName();
            if (record.getParameters() != null) {
                String string = record.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.message");
                String string2 = string;
                Object[] objectArray = record.getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"record.parameters");
                Object[] objectArray2 = objectArray;
                objectArray2 = Arrays.copyOf(objectArray2, objectArray2.length);
                String string3 = String.format(string2, Arrays.copyOf(objectArray2, objectArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
                message = string3;
            }
            LogWriter logWriter = this.getLogWriter();
            java.time.Instant instant = record.getInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"record.instant");
            Instant instant2 = ConvertersKt.toKotlinInstant((java.time.Instant)instant);
            String string = record.getLevel().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.level.name");
            String string4 = message;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message");
            LogWriter.DefaultImpls.writeRecord$default((LogWriter)logWriter, (Instant)instant2, (String)string, (String)string4, (String)(this.getConfig().getLogsLoggerName() ? record.getLoggerName() : null), (String)(this.getConfig().getLogsThreadName() ? threadName : null), (Throwable)(this.getConfig().getLogsException() ? record.getThrown() : null), null, null, null, (int)448, null);
        }
    }

    @Override
    public void flush() {
        this.getLogWriter().flush();
    }

    @Override
    public void close() {
        this.getLogWriter().close();
    }
}

