/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.parser;

import java.text.Format;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.RowFilter;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.parser.HtmlHandler;

public class Parser
implements IParser {
    FormatWrapper format;
    Comparator comparator;
    boolean ignoreCase;
    Comparator<String> stringComparator;
    int modelIndex;
    static HtmlHandler htmlHandler = new HtmlHandler();
    private static Map<String, IOperand> operands;
    private static IOperand wildcardOperand;
    private static WildcardOperand instantOperand;
    private static Pattern expressionMatcher;
    private static StringBuilder escapeBuffer;

    public Parser(Format format, Comparator classComparator, Comparator<String> stringComparator, boolean ignoreCase, int modelIndex) {
        this.format = new FormatWrapper(format);
        this.comparator = classComparator;
        this.stringComparator = stringComparator;
        this.ignoreCase = ignoreCase;
        this.modelIndex = modelIndex;
    }

    @Override
    public RowFilter parseText(String expression) throws ParseException {
        Matcher matcher = expressionMatcher.matcher(expression);
        if (matcher.matches()) {
            IOperand op = operands.get(matcher.group(1));
            if (op == null) {
                op = this.getDefaultOperator(false);
            }
            return op.create(this, matcher.group(3).trim());
        }
        throw new ParseException("", 0);
    }

    @Override
    public IParser.InstantFilter parseInstantText(String expression) throws ParseException {
        Matcher matcher = expressionMatcher.matcher(expression = expression.trim());
        if (matcher.matches()) {
            IOperand op = operands.get(matcher.group(1));
            if (op == null) {
                op = this.getDefaultOperator(true);
            }
            IParser.InstantFilter ret = new IParser.InstantFilter();
            ret.filter = op.create(this, matcher.group(3));
            ret.expression = op == instantOperand ? this.getInstantAppliedExpression(expression) : expression;
            return ret;
        }
        throw new ParseException("", 0);
    }

    protected String getInstantAppliedExpression(String expression) {
        return instantOperand.getAppliedExpression(expression);
    }

    public IOperand getDefaultOperator(boolean instantMode) {
        return instantMode ? instantOperand : wildcardOperand;
    }

    @Override
    public String stripHtml(String expression) {
        return htmlHandler.stripHtml(expression);
    }

    @Override
    public String escape(String expression) {
        Matcher matcher = expressionMatcher.matcher(expression = expression.trim());
        if (matcher.matches()) {
            String operator = matcher.group(1);
            int lastAdded = 0;
            if (operator != null) {
                escapeBuffer.append('\\').append(operator);
                expression = matcher.group(2);
            }
            int total = expression.length();
            for (int i = 0; i < total; ++i) {
                char ch = expression.charAt(i);
                if (ch != '*' && ch != '?') continue;
                escapeBuffer.append(expression.substring(lastAdded, i));
                escapeBuffer.append('\\').append(ch);
                lastAdded = i + 1;
            }
            if (escapeBuffer.length() > 0) {
                escapeBuffer.append(expression.substring(lastAdded, total));
                expression = escapeBuffer.toString();
                escapeBuffer.delete(0, escapeBuffer.length());
            }
        }
        return expression;
    }

    static {
        escapeBuffer = new StringBuilder();
        expressionMatcher = Pattern.compile("^\\s*(>=|<=|<>|!~|~~|>|<|=|~|!)?(\\s*(.*))$", 32);
        operands = new HashMap<String, IOperand>();
        operands.put("~~", new REOperand(true));
        operands.put("!~", new WildcardOperand(false));
        operands.put("!", new EqualOperand(false));
        operands.put(">=", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison >= 0;
            }
        });
        operands.put(">", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison > 0;
            }
        });
        operands.put("<=", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison <= 0;
            }
        });
        operands.put("<", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison < 0;
            }
        });
        operands.put("<>", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison != 0;
            }
        });
        wildcardOperand = new WildcardOperand(true);
        operands.put("~", wildcardOperand);
        operands.put("=", new EqualOperand(true));
        instantOperand = new WildcardOperand(true);
        instantOperand.setInstantMode(true);
    }

    static class FormatWrapper {
        Format format;

        FormatWrapper(Format format) {
            this.format = format;
        }

        public String format(Object o) {
            if (this.format == null) {
                return o == null ? "" : htmlHandler.stripHtml(o.toString());
            }
            return this.format.format(o).trim();
        }

        public Object parseObject(String content) throws ParseException {
            return this.format == null ? null : this.format.parseObject(content);
        }
    }

    protected static class WildcardOperand
    extends REOperand {
        private boolean instantMode;
        private int instantApplied;

        public WildcardOperand(boolean equals) {
            super(equals);
        }

        public void setInstantMode(boolean instantMode) {
            this.instantMode = instantMode;
        }

        public String getAppliedExpression(String baseExpression) {
            switch (this.instantApplied) {
                case 0: {
                    return baseExpression;
                }
                case 1: {
                    return "*" + baseExpression;
                }
                case 2: {
                    return baseExpression + "*";
                }
                case 3: {
                    return "*" + baseExpression + "*";
                }
            }
            return baseExpression;
        }

        @Override
        protected Pattern getPattern(String right, boolean ignoreCase) throws ParseException {
            return super.getPattern(this.convertToRE(right), ignoreCase);
        }

        protected String convertToRE(String s) {
            StringBuilder sb = new StringBuilder();
            boolean escaped = false;
            this.instantApplied = 0;
            block3: for (char c : s.toCharArray()) {
                if (c == '*') {
                    if (escaped) {
                        sb.append("\\*");
                        escaped = false;
                        continue;
                    }
                    sb.append(".*");
                    continue;
                }
                if (c == '?') {
                    if (escaped) {
                        sb.append("\\?");
                        escaped = false;
                        continue;
                    }
                    sb.append(".");
                    continue;
                }
                if (c == '\\') {
                    if (escaped) {
                        sb.append("\\\\\\\\");
                    }
                    escaped = !escaped;
                    continue;
                }
                if (escaped) {
                    sb.append("\\\\");
                    escaped = false;
                }
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        sb.append('\\').append(c);
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            if (escaped) {
                sb.append("\\\\");
            }
            if (this.instantMode) {
                boolean okStart;
                boolean okEnd;
                int l = sb.length();
                if (l < 2) {
                    okEnd = false;
                    okStart = false;
                } else {
                    okStart = sb.substring(0, 2).equals(".*");
                    okEnd = sb.substring(l - 2).equals(".*");
                }
                if (!okStart) {
                    this.instantApplied = 1;
                    sb.insert(0, ".*");
                }
                if (!okEnd) {
                    this.instantApplied += 2;
                    sb.append(".*");
                }
            }
            return sb.toString();
        }
    }

    protected static class REOperand
    implements IOperand {
        boolean equals;

        public REOperand(boolean equals) {
            this.equals = equals;
        }

        @Override
        public RowFilter create(Parser self, String right) throws ParseException {
            final Pattern pattern = this.getPattern(right, self.ignoreCase);
            final int modelIndex = self.modelIndex;
            final FormatWrapper format = self.format;
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object o = entry.getValue(modelIndex);
                    String left = format.format(o);
                    return REOperand.this.equals == pattern.matcher(left).matches();
                }
            };
        }

        protected Pattern getPattern(String expression, boolean ignoreCase) throws ParseException {
            try {
                return Pattern.compile(expression, 0x20 | (ignoreCase ? 66 : 0));
            }
            catch (PatternSyntaxException pse) {
                throw new ParseException("", pse.getIndex());
            }
        }
    }

    protected static class EqualOperand
    implements IOperand {
        boolean expected;

        public EqualOperand(boolean expected) {
            this.expected = expected;
        }

        @Override
        public RowFilter create(Parser self, String right) throws ParseException {
            if (self.comparator == null) {
                return this.createStringOperator(right, self.modelIndex, self.format, self.stringComparator);
            }
            if (right.length() == 0) {
                return this.createNullOperator(self.modelIndex);
            }
            Object o = self.format.parseObject(right);
            if (o == null) {
                throw new ParseException("", 0);
            }
            return this.createOperator(o, self.modelIndex, self.comparator);
        }

        private RowFilter createOperator(final Object right, final int modelIndex, final Comparator comparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    if (left instanceof String) {
                        left = htmlHandler.stripHtml((String)left);
                    }
                    boolean value = left != null && 0 == comparator.compare(left, right);
                    return value == EqualOperand.this.expected;
                }
            };
        }

        private RowFilter createNullOperator(final int modelIndex) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    return EqualOperand.this.expected == (left == null);
                }
            };
        }

        private RowFilter createStringOperator(final String right, final int modelIndex, final FormatWrapper format, final Comparator stringComparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    String value = format.format(left);
                    EqualOperand.this.expected = stringComparator.compare(value, right) == 0;
                    return EqualOperand.this.expected;
                }
            };
        }
    }

    protected static abstract class ComparisonOperand
    implements IOperand {
        protected ComparisonOperand() {
        }

        abstract boolean matches(int var1);

        @Override
        public RowFilter create(Parser self, String right) throws ParseException {
            if (right != null) {
                if (self.comparator == null) {
                    return this.createStringOperator(right, self.modelIndex, self.format, self.stringComparator);
                }
                Object o = self.format.parseObject(right);
                if (o != null) {
                    return this.createOperator(o, self.modelIndex, self.comparator);
                }
            }
            throw new ParseException("", 0);
        }

        private RowFilter createOperator(final Object right, final int modelIndex, final Comparator comparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    if (left instanceof String) {
                        left = htmlHandler.stripHtml((String)left);
                    }
                    return left != null && ComparisonOperand.this.matches(comparator.compare(left, right));
                }
            };
        }

        private RowFilter createStringOperator(final String right, final int modelIndex, final FormatWrapper format, final Comparator stringComparator) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelIndex);
                    if (left == null) {
                        return false;
                    }
                    String s = format.format(left);
                    return s.length() > 0 && ComparisonOperand.this.matches(stringComparator.compare(s, right));
                }
            };
        }
    }

    protected static interface IOperand {
        public RowFilter create(Parser var1, String var2) throws ParseException;
    }
}

