/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.text.ParseException;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.swing.CellRendererPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.editor.ChoiceMatch;
import net.coderazzi.filters.gui.editor.FilterEditor;
import net.coderazzi.filters.gui.editor.IChoicesParser;
import net.coderazzi.filters.gui.editor.PopupComponent;

class EditorComponent
extends JTextField {
    private static final long serialVersionUID = -2196080442586435546L;
    private Controller controller;
    private boolean focus;
    boolean instantFiltering;
    boolean autoCompletion;
    boolean warning;
    FilterEditor filterEditor;
    PopupComponent popup;
    static final Pattern newLinePattern = Pattern.compile("[\n\r\t\f]");

    public EditorComponent(FilterEditor editor, PopupComponent popupComponent) {
        super(15);
        this.filterEditor = editor;
        this.popup = popupComponent;
        this.controller = new EditableTC();
    }

    @Override
    public void setUI(TextUI ui) {
        super.setUI(ui);
        this.setBorder(null);
    }

    @Override
    protected void paintComponent(Graphics g) {
        this.controller.paintComponent(g);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.controller != null) {
            this.setCaretPosition(0);
            this.moveCaretPosition(0);
            this.updateLook();
            this.setFocusable(enabled);
        }
    }

    public void updateLook() {
        this.controller.updateLook();
    }

    public RowFilter getFilter() {
        return this.controller.getFilter();
    }

    public Object getContent() {
        return this.controller.getContent();
    }

    public void setContent(Object content) {
        this.controller.setContent(content);
    }

    public void updateParser() {
        if (this.controller instanceof TextController) {
            ((TextController)this.controller).setParser(this.filterEditor.createParser());
        }
    }

    public IChoicesParser getChoicesParser() {
        return this.controller instanceof IChoicesParser ? (IChoicesParser)((Object)this.controller) : null;
    }

    public boolean isEditableContent() {
        return this.controller instanceof EditableTC;
    }

    public void setInstantFiltering(boolean enable) {
        this.instantFiltering = enable;
    }

    public boolean isInstantFiltering() {
        return this.instantFiltering;
    }

    public void setAutoCompletion(boolean enable) {
        this.autoCompletion = enable;
    }

    public boolean isAutoCompletion() {
        return this.autoCompletion;
    }

    public void setTextMode(boolean editable) {
        if (this.controller != null) {
            if (editable && this.controller instanceof EditableTC) {
                return;
            }
            if (!editable && this.controller instanceof NonEditableTC) {
                return;
            }
            this.controller.detach();
        }
        this.controller = editable ? new EditableTC() : new NonEditableTC();
        this.updateParser();
    }

    public void setRenderMode() {
        if (this.controller != null) {
            if (this.controller instanceof RenderedController) {
                return;
            }
            this.controller.detach();
        }
        this.controller = new RenderedController();
        this.filterEditor.filterUpdated(null);
    }

    public boolean isValidContent() {
        return this.controller.isValidContent();
    }

    public void consolidateFilter() {
        this.controller.consolidateFilter();
    }

    public void focusMoved(boolean gained) {
        this.focus = gained;
        this.controller.focusMoved(gained);
        if (gained) {
            this.setCaretPosition(0);
            this.moveCaretPosition(this.getText().length());
        }
    }

    public void setWarning(boolean warning) {
        if (this.warning != warning) {
            this.warning = warning;
            if (this.isEnabled()) {
                this.updateLook();
            }
        }
    }

    public boolean isFocused() {
        return this.focus;
    }

    Look prepareComponentLook(CustomChoice cc) {
        return this.popup.getFilterRenderer().prepareComponentLook(this, this.isFocused(), cc);
    }

    void superPaintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private class NonEditableTC
    extends TextController {
        NonEditableTC() {
            AbstractDocument ad = (AbstractDocument)EditorComponent.this.getDocument();
            ad.setDocumentFilter(new ControllerDocumentFilter());
        }

        @Override
        public void detach() {
            super.detach();
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(null);
        }

        @Override
        public String escapeChoice(String s) {
            return this.textParser.stripHtml(s);
        }

        @Override
        protected String parseEscape(String text) {
            return this.textParser.escape(text);
        }

        @Override
        protected void consolidateInstantFilter(String text, String content) {
            this.updateFilter(text, null, false);
        }

        class ControllerDocumentFilter
        extends DocumentFilter {
            ControllerDocumentFilter() {
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (!NonEditableTC.this.userUpdate) {
                    super.replace(fb, offset, length, text, attrs);
                    return;
                }
                String buffer = EditorComponent.this.getText();
                String begin = buffer.substring(0, offset) + text;
                String newContent = begin + buffer.substring(offset + length);
                ChoiceMatch match = NonEditableTC.this.getBestMatch(newContent);
                String proposal = null;
                if (match.exact) {
                    proposal = match.content.toString();
                } else {
                    ChoiceMatch match2 = NonEditableTC.this.getBestMatch(begin);
                    if (match2.exact) {
                        match = match2;
                        proposal = match.content.toString();
                    } else {
                        String prpBegin;
                        if (match.content == null) {
                            return;
                        }
                        proposal = match.content.toString();
                        if (proposal.length() < begin.length()) {
                            return;
                        }
                        Comparator<String> cst = EditorComponent.this.popup.getStringComparator();
                        if (0 != cst.compare(begin, prpBegin = proposal.substring(0, begin.length()))) {
                            return;
                        }
                    }
                }
                int caret = 1 + Math.min(EditorComponent.this.getCaret().getDot(), EditorComponent.this.getCaret().getMark());
                super.replace(fb, 0, buffer.length(), proposal, attrs);
                int len = proposal.length();
                EditorComponent.this.setCaretPosition(len);
                EditorComponent.this.moveCaretPosition(Math.min(len, caret));
                NonEditableTC.this.deactivateCustomDecoration();
                if (EditorComponent.this.instantFiltering) {
                    match.exact = true;
                    NonEditableTC.this.updateFilter(proposal, match, true);
                }
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                AWTEvent ev;
                int caret = EditorComponent.this.getCaret().getDot();
                int mark = EditorComponent.this.getCaret().getMark();
                String buffer = EditorComponent.this.getText();
                String newContent = buffer.substring(0, offset) + buffer.substring(offset + length);
                ChoiceMatch match = NonEditableTC.this.getBestMatch(newContent);
                if (match.content == null) {
                    return;
                }
                String proposal = match.content.toString();
                Comparator<String> cmp = EditorComponent.this.popup.getStringComparator();
                if (!(match.exact && 0 == cmp.compare(newContent, proposal) || ChoiceMatch.getMatchingLength(proposal, newContent, cmp) > ChoiceMatch.getMatchingLength(buffer, newContent, cmp))) {
                    proposal = buffer;
                }
                if ((ev = EventQueue.getCurrentEvent()) instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                    if (caret > mark) {
                        caret = mark;
                    } else if (buffer == proposal) {
                        --caret;
                    } else if (caret == mark) {
                        caret = offset;
                    }
                }
                if (0 == caret && buffer == proposal) {
                    match.content = CustomChoice.MATCH_ALL;
                    proposal = match.content.toString();
                }
                if (buffer != proposal) {
                    super.replace(fb, 0, buffer.length(), proposal, null);
                }
                int len = proposal.length();
                EditorComponent.this.setCaretPosition(len);
                EditorComponent.this.moveCaretPosition(Math.min(len, caret));
                NonEditableTC.this.deactivateCustomDecoration();
                if (NonEditableTC.this.userUpdate && EditorComponent.this.instantFiltering && proposal != buffer) {
                    match.exact = true;
                    NonEditableTC.this.updateFilter(proposal, match, true);
                }
            }
        }
    }

    private class EditableTC
    extends TextController {
        EditableTC() {
            AbstractDocument ad = (AbstractDocument)EditorComponent.this.getDocument();
            ad.setDocumentFilter(new ControllerDocumentFilter());
        }

        @Override
        public void detach() {
            super.detach();
            ((AbstractDocument)EditorComponent.this.getDocument()).setDocumentFilter(null);
        }

        @Override
        public String escapeChoice(String s) {
            return this.textParser.escape(this.textParser.stripHtml(s));
        }

        @Override
        protected String parseEscape(String text) {
            return text;
        }

        @Override
        protected void consolidateInstantFilter(String text, String content) {
            this.setEditorText(content);
        }

        class ControllerDocumentFilter
        extends DocumentFilter {
            ControllerDocumentFilter() {
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                String now;
                int moveCaretLeft = 0;
                boolean singleCharacter = text.length() == 1;
                text = newLinePattern.matcher(text).replaceAll(" ");
                if (EditorComponent.this.autoCompletion && EditableTC.this.userUpdate && singleCharacter && (now = EditorComponent.this.getText()).length() == offset + length) {
                    String begin = now.substring(0, offset) + text;
                    String completion = EditorComponent.this.popup.getCompletion(begin);
                    text = text + completion;
                    moveCaretLeft = completion.length();
                }
                super.replace(fb, offset, length, text, attrs);
                this.editorUpdated();
                if (moveCaretLeft > 0) {
                    int caret = EditorComponent.this.getDocument().getLength();
                    EditorComponent.this.setCaretPosition(caret);
                    EditorComponent.this.moveCaretPosition(caret - moveCaretLeft);
                }
            }

            @Override
            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                AWTEvent ev;
                if (offset > 0 && offset == EditorComponent.this.getCaretPosition() && (ev = EventQueue.getCurrentEvent()) instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                    ++length;
                    EditorComponent.this.setCaretPosition(--offset);
                }
                super.remove(fb, offset, length);
                this.editorUpdated();
            }

            private void editorUpdated() {
                if (EditableTC.this.userUpdate) {
                    EditableTC.this.deactivateCustomDecoration();
                    EditableTC.this.setError(false);
                    String text = EditorComponent.this.getText();
                    if (EditorComponent.this.instantFiltering || EditorComponent.this.popup.isVisible()) {
                        ChoiceMatch match = EditableTC.this.getBestMatch(text);
                        if (EditorComponent.this.instantFiltering) {
                            EditableTC.this.updateFilter(text, match, true);
                        }
                    }
                }
            }
        }
    }

    private abstract class TextController
    implements Controller,
    CaretListener,
    IChoicesParser {
        protected IParser textParser;
        protected boolean userUpdate = true;
        private Object content;
        private RowFilter filter;
        private boolean error;
        private boolean decorate;

        TextController() {
            EditorComponent.this.setEditable(true);
            EditorComponent.this.setText(CustomChoice.MATCH_ALL.toString());
            EditorComponent.this.addCaretListener(this);
        }

        public void setParser(IParser textParser) {
            this.textParser = textParser;
            if (EditorComponent.this.isEnabled()) {
                this.updateFilter();
            }
        }

        @Override
        public void paintComponent(Graphics g) {
            EditorComponent.this.superPaintComponent(g);
            if (this.decorate && this.content instanceof CustomChoice) {
                EditorComponent.this.filterEditor.getLook().getCustomChoiceDecorator().decorateComponent((CustomChoice)this.content, EditorComponent.this.filterEditor, EditorComponent.this.isFocused(), EditorComponent.this, g);
            }
        }

        @Override
        public void detach() {
            EditorComponent.this.removeCaretListener(this);
        }

        @Override
        public void setContent(Object content) {
            String text;
            ChoiceMatch match = new ChoiceMatch();
            if (content instanceof CustomChoice) {
                text = ((CustomChoice)content).toString();
                match.content = content;
            } else {
                Format fmt;
                text = content instanceof String ? (String)content : ((fmt = EditorComponent.this.filterEditor.getFormat()) == null ? content.toString() : fmt.format(content));
                match.content = text;
            }
            match.exact = true;
            this.setEditorText(text);
            this.updateFilter(text, match, false);
            this.activateCustomDecoration();
        }

        @Override
        public Object getContent() {
            String ret;
            if (!EditorComponent.this.instantFiltering && !(ret = EditorComponent.this.getText()).equals(this.content.toString())) {
                return ret;
            }
            return this.content;
        }

        @Override
        public boolean isValidContent() {
            return !this.error;
        }

        @Override
        public void consolidateFilter() {
            String content;
            String text = EditorComponent.this.getText();
            if (!text.equals(content = this.content.toString())) {
                if (EditorComponent.this.instantFiltering) {
                    this.consolidateInstantFilter(text, content);
                } else {
                    this.updateFilter();
                }
            }
            EditorComponent.this.getCaret().setDot(EditorComponent.this.getCaret().getDot());
            this.activateCustomDecoration();
        }

        @Override
        public RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public void updateLook() {
            CustomChoice cc = this.decorate && this.content instanceof CustomChoice ? (CustomChoice)this.content : null;
            Look look = EditorComponent.this.prepareComponentLook(cc);
            if (EditorComponent.this.isEnabled() && (this.error || EditorComponent.this.warning)) {
                Color foreground;
                Color color = foreground = this.error ? look.getErrorForeground() : look.getWarningForeground();
                if (foreground != EditorComponent.this.getForeground()) {
                    EditorComponent.this.setForeground(foreground);
                }
            }
            Color selection = look.getTextSelection();
            if (EditorComponent.this.getSelectionColor() != selection) {
                EditorComponent.this.setSelectionColor(selection);
            }
        }

        @Override
        public void focusMoved(boolean gained) {
            this.updateLook();
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.popup.setPopupFocused(false);
                this.deactivateCustomDecoration();
            }
        }

        protected void setError(boolean error) {
            if (this.error != error) {
                this.error = error;
                if (EditorComponent.this.isEnabled()) {
                    this.updateLook();
                }
            }
        }

        protected ChoiceMatch getBestMatch(String hint) {
            ChoiceMatch ret = EditorComponent.this.popup.selectBestMatch(hint);
            EditorComponent.this.popup.setPopupFocused(false);
            return ret;
        }

        private boolean activateCustomDecoration() {
            boolean ret = false;
            if (!this.decorate && this.content instanceof CustomChoice) {
                this.decorate = true;
                this.updateLook();
                EditorComponent.this.repaint();
                ret = true;
            }
            return ret;
        }

        protected void deactivateCustomDecoration() {
            if (this.decorate) {
                this.decorate = false;
                this.updateLook();
                EditorComponent.this.repaint();
            }
        }

        protected void updateFilter() {
            this.updateFilter(null, null, false);
        }

        protected void updateFilter(String text, ChoiceMatch match, boolean userUpdate) {
            RowFilter currentFilter = this.filter;
            boolean error = false;
            if (text == null) {
                match = null;
                text = EditorComponent.this.getText();
            }
            if (match == null) {
                match = this.getBestMatch(text);
            }
            try {
                if (match.exact) {
                    this.content = match.content;
                    if (match.content instanceof CustomChoice) {
                        CustomChoice cc = (CustomChoice)this.content;
                        this.filter = cc.getFilter(EditorComponent.this.filterEditor);
                    } else {
                        this.filter = this.textParser.parseText(this.parseEscape(text));
                    }
                } else if (EditorComponent.this.instantFiltering && userUpdate) {
                    this.filter = this.textParser.parseText(this.parseEscape(text));
                    if (EditorComponent.this.filterEditor.attemptFilterUpdate(this.filter)) {
                        this.content = text;
                        EditorComponent.this.setWarning(false);
                    } else {
                        IParser.InstantFilter iFilter = this.textParser.parseInstantText(this.parseEscape(text));
                        this.content = iFilter.expression;
                        this.filter = iFilter.filter;
                    }
                } else {
                    this.filter = this.textParser.parseText(this.parseEscape(text));
                    this.content = text;
                }
            }
            catch (ParseException pex) {
                this.filter = null;
                this.content = text;
                error = true;
            }
            this.setError(error);
            if (this.filter != currentFilter) {
                if (userUpdate) {
                    EditorComponent.this.setWarning(!EditorComponent.this.filterEditor.attemptFilterUpdate(this.filter));
                } else {
                    EditorComponent.this.filterEditor.filterUpdated(this.filter);
                }
            }
        }

        protected void setEditorText(String text) {
            this.userUpdate = false;
            EditorComponent.this.setText(text);
            this.userUpdate = true;
        }

        protected abstract void consolidateInstantFilter(String var1, String var2);

        protected abstract String parseEscape(String var1);
    }

    private class RenderedController
    extends MouseAdapter
    implements Controller {
        private Object content = CustomChoice.MATCH_ALL;
        private CellRendererPane painter = new CellRendererPane();
        RowFilter filter;
        Object cache = this.content;

        RenderedController() {
            EditorComponent.this.addMouseListener(this);
            EditorComponent.this.setEditable(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            Component c = EditorComponent.this.popup.getFilterRenderer().getCellRendererComponent(this.content, EditorComponent.this.getWidth(), EditorComponent.this.isFocused());
            this.painter.paintComponent(g, c, EditorComponent.this, 0, 0, EditorComponent.this.getWidth(), EditorComponent.this.getHeight());
        }

        @Override
        public void detach() {
            EditorComponent.this.removeMouseListener(this);
        }

        @Override
        public void setContent(Object content) {
            this.content = content;
            EditorComponent.this.repaint();
            this.consolidateFilter();
        }

        @Override
        public Object getContent() {
            return this.content;
        }

        @Override
        public boolean isValidContent() {
            return true;
        }

        @Override
        public RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public void consolidateFilter() {
            Object currentContent = this.getContent();
            if (currentContent != this.cache) {
                this.cache = currentContent;
                this.filter = this.cache instanceof CustomChoice ? ((CustomChoice)this.cache).getFilter(EditorComponent.this.filterEditor) : new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        Object val = entry.getValue(EditorComponent.this.filterEditor.getModelIndex());
                        return val == null ? RenderedController.this.cache == null : val.equals(RenderedController.this.cache);
                    }
                };
                EditorComponent.this.filterEditor.filterUpdated(this.filter);
            }
        }

        @Override
        public void updateLook() {
            EditorComponent.this.prepareComponentLook(null);
        }

        @Override
        public void focusMoved(boolean gained) {
            EditorComponent.this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (EditorComponent.this.isEnabled()) {
                EditorComponent.this.filterEditor.triggerPopup(EditorComponent.this.filterEditor);
            }
        }
    }

    private static interface Controller {
        public void paintComponent(Graphics var1);

        public void detach();

        public void setContent(Object var1);

        public Object getContent();

        public boolean isValidContent();

        public RowFilter getFilter();

        public void consolidateFilter();

        public void updateLook();

        public void focusMoved(boolean var1);
    }
}

