/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JButton;
import net.coderazzi.filters.gui.Look;

final class FilterArrowButton
extends JButton {
    private static final long serialVersionUID = -777416843479142582L;
    private static final int MIN_X = 6;
    private static final int MIN_Y = 6;
    private static final int[] FILL_X = new int[]{0, 3, 6};
    private static final int[] FILL_Y = new int[]{0, 5, 0};
    private boolean focus;
    private Look look;

    FilterArrowButton() {
    }

    public void setLook(Look look) {
        this.look = look;
        this.repaint();
    }

    public Look getLook() {
        return this.look;
    }

    public void setFocused(boolean focus) {
        this.focus = focus;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int height = this.getHeight();
        int width = this.getWidth();
        if (this.isEnabled()) {
            g.setColor(this.focus ? this.look.getSelectionBackground() : this.look.getBackground());
        } else {
            g.setColor(this.look.getDisabledBackground());
        }
        g.fillRect(0, 0, width, height);
        width = (width - 6) / 2;
        height = Math.min(height / 2, height - 6);
        g.translate(width, height);
        if (this.isEnabled()) {
            g.setColor(this.focus ? this.look.getSelectionForeground() : this.look.getForeground());
        } else {
            g.setColor(this.look.getDisabledForeground());
        }
        g.fillPolygon(FILL_X, FILL_Y, FILL_X.length);
    }

    @Override
    protected void paintBorder(Graphics g) {
        super.paintBorder(g);
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(12, 12);
    }
}

