/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.text.Format;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.editor.ChoiceMatch;
import net.coderazzi.filters.gui.editor.IChoicesParser;

public class ChoicesListModel
extends AbstractListModel
implements Comparator<Choice> {
    private static final long serialVersionUID = -8795357002432721893L;
    private Format format;
    private Comparator contentComparator;
    private Comparator<String> strComparator;
    private boolean renderedContent;
    private TreeSet<Choice> content;
    private TreeSet<Choice> alphaSortedContent;
    private Object[] flatContent;
    private int size;

    public ChoicesListModel(Format format, Comparator choicesComparator, Comparator stringComparator) {
        this.format = format;
        this.strComparator = stringComparator;
        this.contentComparator = choicesComparator;
        this.content = new TreeSet<Choice>(this);
        this.clearContent();
    }

    public boolean setRenderedContent(Comparator choicesComparator, Comparator stringComparator) {
        if (this.updateComparators(choicesComparator, stringComparator) || !this.renderedContent) {
            this.renderedContent = true;
            this.strComparator = stringComparator;
            this.clearContent();
            return true;
        }
        return false;
    }

    public boolean setStringContent(Format format, Comparator choicesComparator, Comparator<String> stringComparator) {
        boolean change;
        if (stringComparator.equals(choicesComparator)) {
            choicesComparator = null;
        }
        boolean bl = change = this.updateComparators(choicesComparator, stringComparator) || this.renderedContent;
        if (!change && format != this.format) {
            boolean bl2 = change = this.format == null || format == null || !this.format.equals(format);
        }
        if (change) {
            this.format = format;
            this.strComparator = stringComparator;
            this.renderedContent = false;
            this.clearContent();
        }
        return change;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public Object getElementAt(int index) {
        return this.flatContent()[index];
    }

    public void clearContent() {
        int currentSize = this.size;
        this.content.clear();
        this.content.add(new Choice(CustomChoice.MATCH_ALL, null));
        this.size = 1;
        this.fireIntervalRemoved(this, 1, currentSize);
    }

    public boolean addContent(Collection addedContent, IChoicesParser parser) {
        boolean changed = false;
        for (Object o : addedContent) {
            String s = null;
            if (o == null) {
                o = CustomChoice.MATCH_EMPTY;
            } else if (!this.renderedContent && !(o instanceof CustomChoice)) {
                String string = s = this.format == null ? o.toString() : this.format.format(o);
                if (s.length() == 0) {
                    o = CustomChoice.MATCH_EMPTY;
                } else {
                    s = parser.escapeChoice(s);
                }
            }
            changed = this.content.add(new Choice(o, s)) || changed;
        }
        if (changed) {
            this.flatContent = null;
            this.alphaSortedContent = null;
            this.size = this.content.size();
            this.fireContentsChanged(this, 0, this.size);
        }
        return changed;
    }

    public ChoiceMatch getBestMatch(Object hint) {
        Choice match;
        String str = null;
        if (!this.renderedContent && hint instanceof String) {
            str = (String)hint;
            hint = null;
        }
        Choice choice = new Choice(hint, str);
        ChoiceMatch ret = new ChoiceMatch();
        Choice choice2 = match = hint == null ? null : this.content.floor(choice);
        if (match != null && match.equals(choice)) {
            this.flatContent();
            ret.content = match.get(this.renderedContent);
            ret.index = match.idx;
            ret.exact = true;
        } else if (!this.renderedContent) {
            TreeSet<Choice> alphaContent = this.getAlphabeticallySortedContent();
            Choice top = alphaContent.ceiling(choice);
            Choice low = alphaContent.floor(choice);
            int len = choice.str.length();
            int clen = top == null ? -1 : ChoiceMatch.getMatchingLength(top.str, choice.str, this.strComparator);
            int flen = low == null ? -1 : ChoiceMatch.getMatchingLength(low.str, choice.str, this.strComparator);
            match = clen > flen ? top : low;
            ret.index = match.idx;
            ret.content = match.get(this.renderedContent);
            ret.len = Math.max(clen, flen);
            ret.exact = match.str.length() == len && (len == 0 || ret.len > 0);
        }
        return ret;
    }

    public String getCompletion(String base, List unsortedList) {
        int minLen = base.length();
        int maxLen = Integer.MAX_VALUE;
        String ret = null;
        Iterator<Choice> it = this.getAlphabeticallySortedContent().tailSet(new Choice(base, base), true).iterator();
        Iterator its = unsortedList.iterator();
        while (maxLen > minLen && (it.hasNext() || its.hasNext())) {
            String s = it.hasNext() ? it.next().str : its.next().toString();
            int match = ChoiceMatch.getMatchingLength(base, s, this.strComparator);
            if (match != minLen) continue;
            if (ret == null) {
                ret = s;
                maxLen = s.length();
                continue;
            }
            maxLen = Math.min(maxLen, ChoiceMatch.getMatchingLength(ret, s, this.strComparator));
        }
        return ret == null ? "" : ret.substring(minLen, maxLen);
    }

    private TreeSet<Choice> getAlphabeticallySortedContent() {
        if (this.alphaSortedContent == null) {
            this.flatContent();
            this.alphaSortedContent = new TreeSet<Choice>(new ChoiceTextComparator(this.strComparator));
            this.alphaSortedContent.addAll(this.content);
        }
        return this.alphaSortedContent;
    }

    private Object[] flatContent() {
        if (this.flatContent == null) {
            int i = this.size;
            this.flatContent = new Object[this.size];
            Iterator<Choice> it = this.content.descendingIterator();
            while (i-- > 0) {
                this.flatContent[i] = it.next().index(i).get(this.renderedContent);
            }
        }
        return this.flatContent;
    }

    private boolean updateComparators(Comparator choicesComparator, Comparator stringComparator) {
        boolean same = this.strComparator.equals(stringComparator);
        if (same) {
            same = choicesComparator == null ? this.contentComparator == null : choicesComparator.equals(this.contentComparator);
        }
        this.contentComparator = choicesComparator;
        this.strComparator = stringComparator;
        return !same;
    }

    public Comparator<String> getStringComparator() {
        return this.strComparator;
    }

    @Override
    public int compare(Choice w1, Choice w2) {
        int sdiff;
        Object o1 = w1.o;
        Object o2 = w2.o;
        if (o1 instanceof CustomChoice) {
            if (o2 instanceof CustomChoice) {
                CustomChoice c1 = (CustomChoice)o1;
                CustomChoice c2 = (CustomChoice)o2;
                int ret = c1.getPrecedence() - c2.getPrecedence();
                if (ret == 0) {
                    ret = this.strComparator.compare(w1.str, w2.str);
                }
                return ret;
            }
            return -1;
        }
        if (o2 instanceof CustomChoice) {
            return 1;
        }
        int diff = 0;
        if (this.contentComparator != null) {
            diff = this.contentComparator.compare(o1, o2);
            if (this.renderedContent || diff == 0) {
                return diff;
            }
        }
        return (sdiff = this.strComparator.compare(w1.str, w2.str)) == 0 || diff == 0 ? sdiff : diff;
    }

    private static class ChoiceTextComparator
    implements Comparator<Choice> {
        private Comparator stringComparator;

        public ChoiceTextComparator(Comparator stringComparator) {
            this.stringComparator = stringComparator;
        }

        @Override
        public int compare(Choice w1, Choice w2) {
            return this.stringComparator.compare(w1.str, w2.str);
        }
    }

    public static class Choice {
        public Object o;
        public String str;
        public int idx;

        public Choice(Object content, String repr) {
            this.o = content;
            this.str = content instanceof CustomChoice ? ((CustomChoice)content).getRepresentation() : repr;
        }

        public Choice index(int position) {
            this.idx = position;
            return this;
        }

        public Object get(boolean rendered) {
            return rendered || this.o instanceof CustomChoice ? this.o : this.str;
        }

        public int hashCode() {
            return this.o.hashCode();
        }

        public boolean equals(Object choice) {
            return choice instanceof Choice && ((Choice)choice).o.equals(this.o);
        }
    }
}

