/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.coderazzi.filters.AndFilter;
import net.coderazzi.filters.Filter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;
import net.coderazzi.filters.gui.AdaptiveChoicesHandler;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.ChoicesHandler;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.IParserModel;
import net.coderazzi.filters.gui.NonAdaptiveChoicesHandler;
import net.coderazzi.filters.gui.editor.FilterEditor;

public class FiltersHandler
extends AndFilter
implements PropertyChangeListener {
    int sendNotifications = 0;
    private boolean pendingNotifications;
    private AutoChoices autoChoices;
    private AutoSelector autoSelector = new AutoSelector();
    private Map<Integer, FilterEditor> editors = new HashMap<Integer, FilterEditor>();
    private JTable table;
    private ChoicesHandler choicesHandler;
    private IParserModel parserModel;
    private Filter applyingFilter;
    private boolean filterOnUpdates = FilterSettings.filterOnUpdates;
    private boolean onWarning;

    FiltersHandler(AutoChoices mode, IParserModel parserModel) {
        this.autoChoices = mode;
        this.addFilterObserver(new IFilterObserver(){

            @Override
            public void filterUpdated(IFilter obs) {
                FiltersHandler.this.notifyUpdatedFilter();
            }
        });
        this.setAdaptiveChoices(FilterSettings.adaptiveChoices);
        this.setParserModel(parserModel);
    }

    public void setTable(JTable table) {
        this.choicesHandler.setInterrupted(true);
        JTable oldTable = this.table;
        this.table = table;
        this.autoSelector.replacedTable(oldTable, table);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setParserModel(IParserModel parserModel) {
        if (parserModel != null && parserModel != this.parserModel) {
            if (this.parserModel != null) {
                this.parserModel.removePropertyChangeListener(this);
            }
            this.parserModel = parserModel;
            this.parserModel.addPropertyChangeListener(this);
            this.enableNotifications(false);
            for (FilterEditor editor : this.editors.values()) {
                editor.resetFilter();
            }
            this.enableNotifications(true);
        }
        this.parserModel = parserModel;
    }

    public IParserModel getParserModel() {
        return this.parserModel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Class target;
        boolean formatChange = false;
        if ("ignoreCase".equals(evt.getPropertyName())) {
            target = null;
        } else {
            if ("format".equals(evt.getPropertyName())) {
                formatChange = true;
            } else if (!"comparator".equals(evt.getPropertyName())) {
                return;
            }
            Object cl = evt.getNewValue();
            if (cl instanceof Class) {
                target = (Class)cl;
            } else {
                return;
            }
        }
        this.enableNotifications(false);
        for (FilterEditor editor : this.editors.values()) {
            if (target == null) {
                editor.setIgnoreCase(this.parserModel.isIgnoreCase());
                continue;
            }
            if (editor.getModelClass() != target) continue;
            if (formatChange) {
                editor.setFormat(this.parserModel.getFormat(target));
                continue;
            }
            editor.setComparator(this.parserModel.getComparator(target));
        }
        this.enableNotifications(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enableNotifications(false);
        super.setEnabled(enabled);
        this.enableNotifications(true);
    }

    public void setAutoChoices(AutoChoices mode) {
        if (mode != this.autoChoices) {
            this.enableNotifications(false);
            this.autoChoices = mode;
            for (FilterEditor editor : this.editors.values()) {
                editor.setAutoChoices(mode);
            }
            this.enableNotifications(true);
        }
    }

    public AutoChoices getAutoChoices() {
        return this.autoChoices;
    }

    public void setFilterOnUpdates(boolean enable) {
        this.filterOnUpdates = enable;
        if (this.autoSelector.sorter != null) {
            this.autoSelector.sorter.setSortsOnUpdates(enable);
        }
    }

    public boolean isFilterOnUpdates() {
        return this.filterOnUpdates;
    }

    public void setAdaptiveChoices(boolean enableAdaptiveChoices) {
        boolean reenable = false;
        if (this.choicesHandler != null) {
            if (enableAdaptiveChoices == this.isAdaptiveChoices()) {
                return;
            }
            this.enableNotifications(false);
            if (this.choicesHandler != null) {
                this.choicesHandler.setInterrupted(true);
            }
            reenable = true;
        }
        this.choicesHandler = enableAdaptiveChoices ? new AdaptiveChoicesHandler(this) : new NonAdaptiveChoicesHandler(this);
        if (reenable) {
            this.enableNotifications(true);
        }
    }

    public boolean isAdaptiveChoices() {
        return this.choicesHandler instanceof AdaptiveChoicesHandler;
    }

    public void setAutoSelection(boolean enable) {
        this.autoSelector.setAutoSelection(enable);
    }

    public boolean isAutoSelection() {
        return this.autoSelector.autoSelection;
    }

    @Override
    public void addFilter(IFilter ... filtersToAdd) {
        this.choicesHandler.filterOperation(true);
        super.addFilter(filtersToAdd);
        this.choicesHandler.filterOperation(false);
    }

    @Override
    public void removeFilter(IFilter ... filtersToRemove) {
        this.choicesHandler.filterOperation(true);
        super.removeFilter(filtersToRemove);
        this.choicesHandler.filterOperation(false);
    }

    public void addFilterEditor(FilterEditor editor) {
        super.addFilter(editor.getFilter());
        this.editors.put(editor.getModelIndex(), editor);
        editor.setAutoChoices(this.autoChoices);
    }

    public void removeFilterEditor(FilterEditor editor) {
        super.removeFilter(editor.getFilter());
        this.editors.remove(editor.getModelIndex());
    }

    public void updateEditorChoices(FilterEditor editor) {
        if (this.editors.containsValue(editor) && this.isEnabled()) {
            this.choicesHandler.editorUpdated(editor);
        }
    }

    @Override
    public void filterUpdated(IFilter filter) {
        boolean wasEnabled = this.isEnabled();
        boolean filterWasDisabled = this.isDisabled(filter);
        if (filter != this.applyingFilter) {
            this.choicesHandler.filterUpdated(filter, false);
        }
        super.filterUpdated(filter);
        if (filterWasDisabled && filter.isEnabled()) {
            this.choicesHandler.filterEnabled(filter);
        } else if (wasEnabled && !this.isEnabled()) {
            this.choicesHandler.allFiltersDisabled();
        }
    }

    public boolean applyEditorFilter(Filter filter) {
        boolean ret = this.choicesHandler.filterUpdated(filter, true);
        if (ret) {
            this.applyingFilter = filter;
            filter.reportFilterUpdatedToObservers();
            this.applyingFilter = null;
        }
        return ret;
    }

    public boolean consolidateFilterChanges(int modelIndex) {
        this.choicesHandler.consolidateFilterChanges(modelIndex);
        return this.onWarning;
    }

    public void updateTableFilter() {
        boolean bl = this.pendingNotifications = this.autoSelector.sorter == null;
        if (!this.pendingNotifications) {
            RowFilter rf;
            RowFilter rowFilter = rf = this.isEnabled() ? this.choicesHandler.getRowFilter() : null;
            if (rf != null || this.autoSelector.sorter.getRowFilter() != null) {
                this.autoSelector.sorter.setRowFilter(rf);
            }
            this.checkWarningState();
        }
    }

    public Collection<FilterEditor> getEditors() {
        return this.editors.values();
    }

    public FilterEditor getEditor(int column) {
        return this.editors.get(column);
    }

    public void enableNotifications(boolean enable) {
        this.sendNotifications += enable ? 1 : -1;
        if (enable) {
            if (this.sendNotifications == 0 && (this.choicesHandler.setInterrupted(false) || this.pendingNotifications)) {
                this.updateTableFilter();
            }
        } else if (this.choicesHandler.setInterrupted(true)) {
            // empty if block
        }
    }

    void notifyUpdatedFilter() {
        if (this.sendNotifications < 0) {
            this.pendingNotifications = true;
        } else {
            this.updateTableFilter();
        }
    }

    public void tableUpdated() {
        this.checkWarningState();
    }

    private void checkWarningState() {
        boolean warning;
        boolean bl = warning = this.table.getRowCount() == 0 && this.table.getModel().getRowCount() > 0;
        if (warning != this.onWarning) {
            this.onWarning = warning;
            for (FilterEditor editor : this.getEditors()) {
                editor.setWarning(warning);
            }
        }
    }

    class AutoSelector
    implements RowSorterListener,
    Runnable,
    PropertyChangeListener {
        DefaultRowSorter sorter;
        boolean autoSelection = FilterSettings.autoSelection;

        AutoSelector() {
        }

        public void replacedTable(JTable oldTable, JTable newTable) {
            String[] EVENTS;
            for (String e : EVENTS = new String[]{"rowSorter", "model"}) {
                if (oldTable != null) {
                    oldTable.removePropertyChangeListener(e, this);
                }
                if (newTable == null) continue;
                newTable.addPropertyChangeListener(e, this);
            }
            this.setSorter(newTable);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setSorter((JTable)evt.getSource());
        }

        private void setSorter(JTable table) {
            DefaultRowSorter tableRowSorter;
            if (this.sorter != null) {
                this.sorter.removeRowSorterListener(this);
                this.sorter.setRowFilter(null);
                this.sorter = null;
            }
            try {
                tableRowSorter = table == null ? null : (DefaultRowSorter)table.getRowSorter();
            }
            catch (ClassCastException ccex) {
                throw new RuntimeException("Invalid RowSorter on JTable: filter header requires a DefaultRowSorter class");
            }
            if (table != null && (tableRowSorter == null || tableRowSorter.getModel() != table.getModel())) {
                this.sorter = new TableRowSorter<TableModel>(table.getModel());
                table.setRowSorter(this.sorter);
            } else {
                this.sorter = tableRowSorter;
                if (tableRowSorter != null) {
                    FiltersHandler.this.notifyUpdatedFilter();
                    if (this.autoSelection) {
                        tableRowSorter.addRowSorterListener(this);
                    }
                    FiltersHandler.this.setFilterOnUpdates(FiltersHandler.this.isFilterOnUpdates());
                }
            }
        }

        public void setAutoSelection(boolean enable) {
            if (this.autoSelection != enable && this.sorter != null) {
                if (enable) {
                    this.sorter.addRowSorterListener(this);
                } else {
                    this.sorter.removeRowSorterListener(this);
                }
            }
            this.autoSelection = enable;
        }

        @Override
        public void run() {
            if (this.sorter != null && this.sorter.getViewRowCount() == 1) {
                FiltersHandler.this.getTable().getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            if (e.getType() == RowSorterEvent.Type.SORTED && ((RowSorter)e.getSource()).getViewRowCount() == 1) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

