/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.IFilterEditor;
import net.coderazzi.filters.gui.Look;

public interface CustomChoiceDecorator {
    public Color getBackground(CustomChoice var1, IFilterEditor var2, boolean var3);

    public Color getForeground(CustomChoice var1, IFilterEditor var2, boolean var3);

    public Font getFont(CustomChoice var1, IFilterEditor var2, boolean var3);

    public void decorateComponent(CustomChoice var1, IFilterEditor var2, boolean var3, JComponent var4, Graphics var5);

    public static class DefaultDecorator
    implements CustomChoiceDecorator {
        private Font baseFont;
        private Font italicFont;

        @Override
        public void decorateComponent(CustomChoice choice, IFilterEditor editor, boolean isSelected, JComponent c, Graphics g) {
            choice.decorateComponent(editor, isSelected, c, g);
        }

        @Override
        public Font getFont(CustomChoice choice, IFilterEditor editor, boolean isSelected) {
            Font ret = choice.getFont(editor, isSelected);
            if (ret == null) {
                ret = editor.getLook().getFont();
                if (ret != this.baseFont) {
                    this.baseFont = ret;
                    this.italicFont = this.baseFont.deriveFont(2);
                }
                ret = this.italicFont;
            }
            return ret;
        }

        @Override
        public Color getBackground(CustomChoice choice, IFilterEditor editor, boolean isSelected) {
            Look look = editor.getLook();
            return isSelected ? look.getSelectionBackground() : look.getBackground();
        }

        @Override
        public Color getForeground(CustomChoice choice, IFilterEditor editor, boolean isSelected) {
            Look look = editor.getLook();
            return isSelected ? look.getSelectionForeground() : look.getForeground();
        }
    }
}

