/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.gui.ChoiceRenderer;
import net.coderazzi.filters.gui.IFilterEditor;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.editor.ChoiceMatch;
import net.coderazzi.filters.gui.editor.ChoicesListModel;
import net.coderazzi.filters.gui.editor.FilterListCellRenderer;
import net.coderazzi.filters.gui.editor.HistoryListModel;

abstract class PopupComponent
implements PopupMenuListener {
    private JPopupMenu popup;
    private FilterListCellRenderer listRenderer;
    private JScrollPane choicesScrollPane;
    private JScrollPane historyScrollPane;
    private JSeparator separator;
    private ChoicesListModel choicesModel = new ChoicesListModel();
    private HistoryListModel historyModel = new HistoryListModel();
    private Object cancelReason;
    private int maxVisibleRows;
    JList focusedList;
    JList choicesList;
    JList historyList;

    public PopupComponent(IFilterEditor editor) {
        this.createGui(editor);
    }

    protected abstract void choiceSelected(Object var1);

    public Object getSelection() {
        return this.focusedList.getSelectedValue();
    }

    public boolean isValidChoice(Object object) {
        return this.choicesModel.isValidChoice(object);
    }

    public Collection<?> getChoices() {
        return this.choicesModel.getChoices();
    }

    public void addChoices(Collection<?> choices, IParser escapeParser) {
        if (this.choicesModel.addContent(choices, escapeParser)) {
            this.hide();
        }
    }

    public void addHistory(Object st) {
        if (this.historyModel.add(st)) {
            this.hide();
        }
    }

    public void clearChoices() {
        this.choicesModel.clearContent();
        this.hide();
    }

    public void clearHistory() {
        this.historyModel.clear();
        this.hide();
    }

    public boolean isVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    public boolean display(Component editor) {
        if (this.isVisible()) {
            return false;
        }
        this.prepareGui();
        this.setPopupFocused(false);
        int width = editor.getParent().getWidth() - 1;
        this.configurePaneSize(this.choicesScrollPane, width);
        this.configurePaneSize(this.historyScrollPane, width);
        if (editor.isValid()) {
            this.popup.show(editor, -editor.getLocation().x - 1, editor.getHeight());
        }
        this.focusedList = this.historyList;
        return true;
    }

    public boolean hide() {
        if (this.isVisible()) {
            this.popup.setVisible(false);
            return true;
        }
        return false;
    }

    public FilterListCellRenderer getFilterRenderer() {
        return this.listRenderer;
    }

    public void setRenderedContent(ChoiceRenderer renderer, Comparator classComparator) {
        this.hide();
        this.listRenderer.setUserRenderer(renderer);
        if (this.choicesModel.setRenderedContent(classComparator)) {
            this.historyModel.setStringContent(null);
        }
    }

    public void setStringContent(Format format, Comparator<String> stringComparator) {
        this.hide();
        this.listRenderer.setUserRenderer(null);
        if (this.choicesModel.setStringContent(format, stringComparator)) {
            this.historyModel.setStringContent(stringComparator);
        }
    }

    public Comparator<String> getStringComparator() {
        return this.historyModel.getStringComparator();
    }

    public ChoiceMatch selectBestMatch(Object hint, boolean exact) {
        ChoiceMatch hMatch = this.historyModel.getClosestMatch(hint, exact);
        if (this.choicesModel.getSize() > 0) {
            ChoiceMatch match = this.choicesModel.getClosestMatch(hint, exact || hMatch.exact);
            if (this.isVisible() && match.index >= 0) {
                this.choicesList.ensureIndexIsVisible(match.index);
            }
            if (match.exact || !hMatch.exact && match.len >= hMatch.len) {
                if (match.index >= 0 && this.isVisible()) {
                    this.focusChoices();
                    this.select(match.index);
                }
                return match;
            }
        }
        if (hMatch.index != -1 && this.isVisible()) {
            this.focusHistory();
            this.select(hMatch.index);
        }
        return hMatch;
    }

    public String getCompletion(String s) {
        return this.choicesModel.getCompletion(s, this.historyModel.getList());
    }

    public void setPopupFocused(boolean set) {
        if (set != this.listRenderer.isFocusOnList()) {
            this.listRenderer.setFocusOnList(set);
            this.focusedList.repaint();
        }
    }

    public boolean isPopupFocused() {
        return this.isVisible() && this.listRenderer.isFocusOnList();
    }

    public void setMaxHistory(int size) {
        this.historyModel.setMaxHistory(Math.max(0, Math.min(size, this.maxVisibleRows)));
        this.hide();
    }

    public int getMaxHistory() {
        return this.historyModel.getMaxHistory();
    }

    public boolean selectFirst(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToHistory() && (forceJump || this.choicesList.getSelectedIndex() == 0);
        if (ret) {
            this.focusHistory();
        }
        return this.select(0) || ret;
    }

    public boolean selectLast(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToChoices() && (forceJump || this.historyList.getSelectedIndex() == this.historyModel.getSize() - 1);
        if (ret) {
            this.focusChoices();
        }
        return this.select(this.focusedList.getModel().getSize() - 1) || ret;
    }

    public boolean selectUp(boolean jumpRequired) {
        if (jumpRequired || !this.select(this.focusedList.getSelectedIndex() - 1)) {
            if (!this.canSwitchToHistory()) {
                return false;
            }
            this.focusHistory();
            this.select(this.historyModel.getSize() - 1);
        }
        return true;
    }

    public void selectDown(boolean jumpRequired) {
        if ((jumpRequired || !this.select(this.focusedList.getSelectedIndex() + 1)) && this.canSwitchToChoices()) {
            this.focusChoices();
            this.select(this.choicesList.getFirstVisibleIndex());
        }
    }

    public void selectDownPage() {
        if (this.isFocusInHistory()) {
            if (this.canSwitchToChoices()) {
                this.focusChoices();
            }
            this.select(this.focusedList.getLastVisibleIndex());
        } else {
            int lst = this.choicesList.getLastVisibleIndex();
            if (lst == this.choicesList.getSelectedIndex()) {
                lst = Math.min(lst + lst - this.choicesList.getFirstVisibleIndex(), this.choicesModel.getSize() - 1);
            }
            this.select(lst);
        }
    }

    public void selectUpPage() {
        int r = 0;
        if (!this.isFocusInHistory()) {
            int selected = this.choicesList.getSelectedIndex();
            if (this.canSwitchToHistory() && selected == 0) {
                this.focusHistory();
            } else {
                r = this.choicesList.getFirstVisibleIndex();
                if (r == selected) {
                    r = Math.max(0, r + r - this.choicesList.getLastVisibleIndex());
                }
            }
        }
        this.select(r);
    }

    public void setLook(Look look) {
        Font oldFont = this.choicesList.getFont();
        this.choicesList.setBackground(look.getBackground());
        this.choicesList.setForeground(look.getForeground());
        this.choicesList.setSelectionBackground(look.getSelectionBackground());
        this.choicesList.setSelectionForeground(look.getSelectionForeground());
        this.choicesList.setFont(look.getFont());
        this.historyList.setBackground(look.getBackground());
        this.historyList.setForeground(look.getForeground());
        this.historyList.setSelectionBackground(look.getSelectionBackground());
        this.historyList.setSelectionForeground(look.getSelectionForeground());
        this.historyList.setFont(look.getFont());
        this.popup.setBorder(BorderFactory.createLineBorder(look.getGridColor(), 1));
        this.separator.setForeground(look.getGridColor());
        this.maxVisibleRows = look.getMaxVisiblePopupRows();
        this.setMaxHistory(this.getMaxHistory());
        if (oldFont != look.getFont()) {
            this.ensureListRowsHeight();
        }
    }

    private boolean select(int n) {
        int current = this.focusedList.getSelectedIndex();
        this.setPopupFocused(true);
        if (n >= 0) {
            this.focusedList.setSelectedIndex(n);
            this.focusedList.ensureIndexIsVisible(n);
        }
        return current != this.focusedList.getSelectedIndex();
    }

    private boolean canSwitchToHistory() {
        return this.focusedList == this.choicesList && this.historyScrollPane.isVisible();
    }

    private boolean canSwitchToChoices() {
        return this.focusedList == this.historyList && this.choicesScrollPane.isVisible();
    }

    private void focusHistory() {
        this.choicesList.clearSelection();
        this.focusedList = this.historyList;
    }

    private void focusChoices() {
        this.historyList.clearSelection();
        this.focusedList = this.choicesList;
    }

    private boolean isFocusInHistory() {
        return this.focusedList == this.historyList;
    }

    private void configurePaneSize(JComponent pane, int width) {
        Dimension size = pane.getPreferredSize();
        size.width = width;
        pane.setPreferredSize(size);
    }

    private void ensureListRowsHeight() {
        String prototype;
        prototype = this.listRenderer != null && this.listRenderer.getUserRenderer() == null ? ("X".equals(prototype = (String)this.choicesList.getPrototypeCellValue()) ? "Z" : "X") : null;
        this.choicesList.setPrototypeCellValue(prototype);
        this.historyList.setPrototypeCellValue(prototype);
    }

    private void createGui(IFilterEditor editor) {
        MouseHandler mouseHandler = new MouseHandler();
        this.choicesList = new JList(this.choicesModel);
        this.choicesList.addMouseMotionListener(mouseHandler);
        this.choicesList.addMouseListener(mouseHandler);
        this.choicesScrollPane = this.createScrollPane(this.choicesList);
        this.historyList = new JList(this.historyModel);
        this.historyList.addMouseMotionListener(mouseHandler);
        this.historyList.addMouseListener(mouseHandler);
        this.choicesList.setBorder(null);
        this.choicesList.setFocusable(false);
        this.choicesList.setSelectionMode(0);
        this.historyList.setBorder(null);
        this.historyList.setFocusable(false);
        this.historyList.setSelectionMode(0);
        this.ensureListRowsHeight();
        this.separator = new JSeparator();
        this.popup = new JPopupMenu();
        this.popup.setLayout(new BorderLayout());
        this.popup.setBorderPainted(true);
        this.popup.setOpaque(false);
        this.popup.addPopupMenuListener(this);
        this.historyScrollPane = this.createScrollPane(this.historyList);
        this.popup.add((Component)this.historyScrollPane, "North");
        this.popup.add((Component)this.separator, "Center");
        this.popup.add((Component)this.choicesScrollPane, "South");
        this.popup.setDoubleBuffered(true);
        this.popup.setFocusable(false);
        this.listRenderer = new FilterListCellRenderer(editor, this.choicesList);
        this.choicesList.setCellRenderer(this.listRenderer);
        this.historyList.setCellRenderer(this.listRenderer);
    }

    private void prepareGui() {
        int historySize = this.historyModel.clearRestrictions();
        int choicesSize = this.choicesModel.getSize();
        int maxChoices = Math.min(choicesSize, this.maxVisibleRows - historySize);
        if (historySize > 0 && choicesSize <= maxChoices) {
            for (int i = 0; i < choicesSize; ++i) {
                if (!this.historyModel.restrict(this.choicesModel.getElementAt(i))) continue;
                --historySize;
            }
            maxChoices = choicesSize;
        }
        boolean showHistory = historySize > 0;
        boolean showChoices = maxChoices > 0;
        this.choicesScrollPane.setVisible(showChoices);
        this.historyScrollPane.setVisible(showHistory);
        if (showHistory) {
            this.historyList.setVisibleRowCount(historySize);
            this.historyScrollPane.setPreferredSize(null);
        }
        if (showChoices) {
            this.choicesList.setVisibleRowCount(maxChoices);
            this.choicesScrollPane.setPreferredSize(null);
        }
        this.separator.setVisible(showHistory && showChoices);
    }

    private JScrollPane createScrollPane(JList list) {
        JScrollPane ret = new JScrollPane(list, 20, 31);
        ret.setHorizontalScrollBar(null);
        ret.setFocusable(false);
        ret.getVerticalScrollBar().setFocusable(false);
        ret.setBorder(null);
        return ret;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.cancelReason = null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        AWTEvent ev = EventQueue.getCurrentEvent();
        if (ev instanceof MouseEvent) {
            this.cancelReason = ev.getSource();
        }
    }

    public boolean isMenuCanceledForMouseEvent(Object source) {
        boolean ret = !this.popup.isVisible() && this.cancelReason == source;
        this.cancelReason = null;
        return ret;
    }

    final class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            this.listSelection(PopupComponent.this.focusedList.getSelectedValue());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            JList focus = (JList)e.getSource();
            JList other = focus == PopupComponent.this.choicesList ? PopupComponent.this.historyList : PopupComponent.this.choicesList;
            focus.setSelectedIndex(focus.locationToIndex(e.getPoint()));
            if (other.getModel().getSize() > 0) {
                other.setSelectedIndex(0);
                other.clearSelection();
            }
            PopupComponent.this.focusedList = focus;
        }

        private void listSelection(Object object) {
            PopupComponent.this.choiceSelected(object);
            PopupComponent.this.hide();
        }
    }
}

