/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.editor.ChoiceMatch;

class HistoryListModel
extends AbstractListModel {
    private static final long serialVersionUID = -374115548677017807L;
    private List<Object> history = new ArrayList<Object>();
    private List<Object> shownHistory = this.history;
    private Object lastAdded;
    private Comparator stringComparator;
    private int maxHistory;

    HistoryListModel() {
    }

    public void setStringContent(Comparator<String> stringComparator) {
        if (this.stringComparator != stringComparator) {
            this.stringComparator = stringComparator;
            this.clear();
        }
    }

    public Comparator<String> getStringComparator() {
        return this.stringComparator;
    }

    public int clearRestrictions() {
        this.shownHistory = this.history;
        return this.shownHistory.size();
    }

    public boolean restrict(Object exclude) {
        int index = this.shownHistory.indexOf(exclude);
        if (index != -1) {
            if (this.shownHistory == this.history) {
                this.shownHistory = new ArrayList<Object>(this.history);
            }
            this.shownHistory.remove(index);
            this.fireIntervalAdded(this, index, index);
            return true;
        }
        return false;
    }

    @Override
    public Object getElementAt(int index) {
        return this.shownHistory.get(index);
    }

    public boolean add(Object st) {
        boolean ret = false;
        boolean removed = this.history.remove(st);
        if (this.maxHistory > 0 && this.lastAdded != null && this.lastAdded.toString().length() > 0 && !this.lastAdded.equals(st)) {
            this.history.add(0, this.lastAdded);
            int size = this.history.size();
            if (size > this.maxHistory) {
                this.history.remove(--size);
                removed = true;
            } else {
                ret = true;
                if (!removed) {
                    this.fireIntervalAdded(this, 0, 0);
                }
            }
        }
        if (removed) {
            this.fireContentsChanged(this, 0, this.history.size());
            ret = true;
        }
        this.lastAdded = st;
        this.shownHistory = this.history;
        return ret;
    }

    public boolean isEmpty() {
        return this.shownHistory.isEmpty();
    }

    public void clear() {
        int size = this.history.size();
        if (size > 0) {
            this.history.clear();
            this.shownHistory = this.history;
            this.fireIntervalRemoved(this, 0, size);
        }
        this.lastAdded = null;
    }

    @Override
    public int getSize() {
        return this.shownHistory.size();
    }

    public void setMaxHistory(int size) {
        this.maxHistory = size;
        int current = this.history.size();
        if (current > size) {
            for (int i = current - 1; i >= size; --i) {
                this.history.remove(i);
            }
            this.shownHistory = this.history;
            this.fireContentsChanged(this, this.maxHistory, current);
        }
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public List getList() {
        return this.history;
    }

    public ChoiceMatch getClosestMatch(Object hint, boolean exact) {
        ChoiceMatch ret = this.stringComparator != null && hint instanceof String ? ChoiceMatch.findOnUnsortedContent(this.shownHistory, this.shownHistory.size(), this.stringComparator, (String)hint, exact) : ChoiceMatch.findExactOnContent(this.shownHistory, hint);
        return ret;
    }
}

