/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.text.Collator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.editor.ChoiceMatch;

public class ChoicesListModel
extends AbstractListModel {
    private static final long serialVersionUID = 3523952153693100563L;
    private List content;
    private Format format;
    private int customChoices;
    boolean useFormatter;
    Comparator comparator;
    private Comparator wrapperComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CustomChoice) {
                if (o2 instanceof CustomChoice) {
                    CustomChoice c1 = (CustomChoice)o1;
                    CustomChoice c2 = (CustomChoice)o2;
                    int ret = c1.getPrecedence() - c2.getPrecedence();
                    if (ret == 0) {
                        ret = ChoicesListModel.this.useFormatter ? ChoicesListModel.this.comparator.compare(c1.toString(), c2.toString()) : o1.hashCode() - o2.hashCode();
                    }
                    return ret;
                }
                return -1;
            }
            if (o2 instanceof CustomChoice) {
                return 1;
            }
            return ChoicesListModel.this.comparator.compare(o1, o2);
        }
    };

    public ChoicesListModel() {
        this.content = new ArrayList();
        this.setStringContent(null, Collator.getInstance());
        this.clearContent();
    }

    @Override
    public int getSize() {
        return this.content.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.content.get(i);
    }

    public void clearContent() {
        int size = this.getSize();
        this.content.clear();
        this.content.add(CustomChoice.MATCH_ALL);
        this.customChoices = 1;
        this.fireIntervalRemoved(this, 1, size);
    }

    public boolean isValidChoice(Object o) {
        return this.content.contains(o);
    }

    public Collection<?> getChoices() {
        return this.content;
    }

    public ChoiceMatch getClosestMatch(Object hint, boolean exact) {
        return this.useFormatter && hint instanceof String ? this.findOnSortedContent((String)hint, exact) : ChoiceMatch.findExactOnContent(this.content, hint);
    }

    public String getCompletion(String base, List addedList) {
        Object use;
        int cs = this.content.size();
        int pos = Collections.binarySearch(this.content.subList(this.customChoices, cs), base, this.comparator);
        if (pos >= 0) {
            return "";
        }
        String ret = base;
        int len = base.length();
        if ((pos = this.customChoices - pos - 1) < cs && ChoiceMatch.getMatchingLength(base, (String)(use = this.content.get(pos).toString()), this.comparator) >= len) {
            int m;
            ret = use;
            int maxLen = ret.length();
            while (++pos < cs && (m = ChoiceMatch.getMatchingLength(ret, (String)(use = this.content.get(pos).toString()), this.comparator)) >= len) {
                if (m == len) {
                    return "";
                }
                if (m >= maxLen) continue;
                maxLen = m;
            }
            ret = ret.substring(0, maxLen);
        }
        for (List l : use = new List[]{this.content.subList(0, this.customChoices), addedList}) {
            for (Object o : l) {
                String s = o.toString();
                int m = ChoiceMatch.getMatchingLength(ret, s, this.comparator);
                if (m == len) {
                    if (ret != base) {
                        return "";
                    }
                    ret = s;
                    continue;
                }
                if (m <= len) continue;
                ret = ret.substring(0, m);
            }
        }
        return ret.substring(len);
    }

    public boolean setStringContent(Format format, Comparator stringComparator) {
        boolean ret;
        boolean bl = ret = !this.useFormatter || format != this.format || this.comparator != stringComparator;
        if (ret) {
            this.useFormatter = true;
            this.format = format;
            this.comparator = stringComparator;
            this.clearContent();
        }
        return ret;
    }

    public boolean setRenderedContent(Comparator classComparator) {
        boolean ret;
        boolean bl = ret = this.useFormatter || this.comparator != classComparator;
        if (ret) {
            this.useFormatter = false;
            this.format = null;
            this.comparator = classComparator;
            this.clearContent();
        }
        return ret;
    }

    public boolean addContent(Collection addedContent, IParser escapeParser) {
        boolean changed = false;
        for (Object o : addedContent) {
            if (!(o instanceof CustomChoice)) {
                if (o == null) {
                    o = CustomChoice.MATCH_EMPTY;
                } else if (this.useFormatter) {
                    String s;
                    String string = s = this.format == null ? o.toString() : this.format.format(o);
                    o = s.length() == 0 ? CustomChoice.MATCH_EMPTY : (escapeParser == null ? s.trim() : escapeParser.escape(s));
                }
            }
            changed = this.addContent(o) || changed;
        }
        if (changed) {
            this.addContent(CustomChoice.MATCH_ALL);
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return changed;
    }

    private boolean addContent(Object o) {
        int pos = Collections.binarySearch(this.content, o, this.wrapperComparator);
        if (pos < 0) {
            this.content.add(-1 - pos, o);
            if (o instanceof CustomChoice) {
                ++this.customChoices;
            }
            return true;
        }
        return false;
    }

    private ChoiceMatch findOnSortedContent(String strStart, boolean fullMatch) {
        ChoiceMatch ret;
        if (this.content.isEmpty()) {
            ret = new ChoiceMatch();
        } else {
            ret = ChoiceMatch.findOnUnsortedContent(this.content, this.customChoices, this.comparator, strStart, fullMatch);
            if (!ret.exact) {
                int pos = Collections.binarySearch(this.content.subList(this.customChoices, this.content.size()), strStart, this.comparator);
                if (pos >= 0) {
                    ret.exact = true;
                    ret.index = this.customChoices + pos;
                    ret.content = this.content.get(ret.index);
                } else if (!fullMatch) {
                    String suggestion;
                    int len;
                    int suggested = this.customChoices - pos - 1;
                    if (suggested < this.content.size() && ((len = ChoiceMatch.getMatchingLength(strStart, suggestion = this.content.get(suggested).toString(), this.comparator)) > ret.len || ret.len == 0)) {
                        ret.index = suggested;
                        ret.len = len;
                    }
                    if (--suggested >= this.customChoices && ((len = ChoiceMatch.getMatchingLength(strStart, suggestion = this.content.get(suggested).toString(), this.comparator)) > ret.len || ret.len == 0)) {
                        ret.index = suggested;
                        ret.len = len;
                    }
                    ret.content = this.content.get(ret.index);
                    if (ret.index >= this.customChoices) {
                        ret.exact = ret.content.toString().length() == strStart.length();
                    }
                }
            }
        }
        return ret;
    }
}

