/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.CustomChoiceDecorator;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.FiltersHandler;
import net.coderazzi.filters.gui.IFilterEditor;
import net.coderazzi.filters.gui.IFilterHeaderObserver;
import net.coderazzi.filters.gui.IParserModel;
import net.coderazzi.filters.gui.Look;
import net.coderazzi.filters.gui.PositionHelper;
import net.coderazzi.filters.gui.editor.FilterEditor;

public class TableFilterHeader
extends JPanel {
    private static final long serialVersionUID = 5217701111228491294L;
    private static final int MIN_VISIBLE_CHOICES = 4;
    private boolean backgroundSet;
    private boolean foregroundSet;
    private boolean disabledBgColorSet;
    private boolean disabledColorSet;
    private boolean selectionBackgroundSet;
    private boolean selectionForegroundSet;
    private boolean selectionColorSet;
    private boolean gridColorSet;
    private boolean errorColorSet;
    private boolean warningColorSet;
    private boolean fontSet;
    private PositionHelper positionHelper = new PositionHelper(this);
    Look look = new Look();
    boolean instantFilteringEnabled = FilterSettings.instantFiltering;
    boolean autoCompletionEnabled = FilterSettings.autoCompletion;
    int maxHistory = FilterSettings.maxPopupHistory;
    int filterRowHeightDelta = FilterSettings.filterRowHeightDelta;
    FilterColumnsControllerPanel columnsController;
    FiltersHandler filtersHandler = new FiltersHandler();
    Set<IFilterHeaderObserver> observers = new HashSet<IFilterHeaderObserver>();
    private ComponentAdapter resizer = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (TableFilterHeader.this.columnsController != null) {
                TableFilterHeader.this.columnsController.revalidate();
            }
        }
    };

    public TableFilterHeader() {
        this(null, null);
    }

    public TableFilterHeader(JTable table) {
        this(table, null);
    }

    public TableFilterHeader(JTable table, IParserModel parserModel) {
        super(new BorderLayout());
        this.add((Component)new JPanel(), "Center");
        if (parserModel == null) {
            parserModel = FilterSettings.newParserModel();
        }
        this.filtersHandler.setParserModel(parserModel);
        this.fontSet = false;
        this.foregroundSet = false;
        this.backgroundSet = false;
        this.setPosition(FilterSettings.headerPosition);
        this.setTable(table);
    }

    public IFilterEditor getFilterEditor(int modelColumn) {
        return this.columnsController == null ? null : this.columnsController.getFilterEditor(this.getTable().convertColumnIndexToView(modelColumn));
    }

    public void setTable(JTable table) {
        this.filtersHandler.enableNotifications(false);
        JTable oldTable = this.getTable();
        this.positionHelper.changeTable(oldTable, table);
        if (oldTable != null) {
            oldTable.removeComponentListener(this.resizer);
        }
        this.filtersHandler.setTable(table);
        if (table == null) {
            this.removeController();
            this.revalidate();
        } else {
            this.updateLook();
            this.recreateController();
            table.addComponentListener(this.resizer);
        }
        this.filtersHandler.enableNotifications(true);
    }

    public JTable getTable() {
        return this.filtersHandler == null ? null : this.filtersHandler.getTable();
    }

    public void setParserModel(IParserModel parserModel) {
        this.filtersHandler.setParserModel(parserModel);
    }

    public IParserModel getParserModel() {
        return this.filtersHandler.getParserModel();
    }

    public void setAutoChoices(AutoChoices set) {
        this.filtersHandler.setAutoChoices(set);
    }

    public AutoChoices getAutoChoices() {
        return this.filtersHandler.getAutoChoices();
    }

    public void setAdaptiveChoices(boolean enable) {
        this.filtersHandler.setAdaptiveChoices(enable);
    }

    public boolean isAdaptiveChoices() {
        return this.filtersHandler.isAdaptiveChoices();
    }

    public void setInstantFiltering(boolean enable) {
        if (this.instantFilteringEnabled != enable) {
            this.instantFilteringEnabled = enable;
            if (this.columnsController != null) {
                for (FilterEditor fe : this.columnsController) {
                    fe.setInstantFiltering(enable);
                }
            }
        }
    }

    public boolean isInstantFiltering() {
        return this.instantFilteringEnabled;
    }

    public void setAutoCompletion(boolean enable) {
        if (this.autoCompletionEnabled != enable) {
            this.autoCompletionEnabled = enable;
            if (this.columnsController != null) {
                for (FilterEditor fe : this.columnsController) {
                    fe.setAutoCompletion(enable);
                }
            }
        }
    }

    public boolean isAutoCompletion() {
        return this.autoCompletionEnabled;
    }

    public void setFilterOnUpdates(boolean enable) {
        this.filtersHandler.setFilterOnUpdates(enable);
    }

    public boolean isFilterOnUpdates() {
        return this.filtersHandler.isFilterOnUpdates();
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.isVisible() != flag) {
            this.positionHelper.headerVisibilityChanged(flag);
        }
        super.setVisible(flag);
        this.positionHelper.headerVisibilityChanged(flag);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.filtersHandler != null) {
            this.filtersHandler.setEnabled(enabled);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.filtersHandler == null || this.filtersHandler.isEnabled();
    }

    public void setPosition(Position location) {
        this.positionHelper.setPosition(location);
    }

    public Position getPosition() {
        return this.positionHelper.getPosition();
    }

    public void setMaxVisibleRows(int maxVisibleRows) {
        int tmp = Math.max(4, maxVisibleRows);
        if (tmp != this.look.maxVisiblePopupRows) {
            this.look.maxVisiblePopupRows = tmp;
            this.lookUpdated();
        }
    }

    public int getMaxVisibleRows() {
        return this.look.maxVisiblePopupRows;
    }

    public void setMaxHistory(int maxHistory) {
        this.maxHistory = maxHistory;
        if (this.columnsController != null) {
            for (FilterEditor fe : this.columnsController) {
                fe.setMaxHistory(maxHistory);
            }
        }
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public void addFilter(IFilter ... filter) {
        this.filtersHandler.addFilter(filter);
    }

    public void removeFilter(IFilter ... filter) {
        this.filtersHandler.removeFilter(filter);
    }

    public void addHeaderObserver(IFilterHeaderObserver observer) {
        this.observers.add(observer);
    }

    public void removeHeaderObserver(IFilterHeaderObserver observer) {
        this.observers.remove(observer);
    }

    public void resetFilter() {
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            for (FilterEditor fe : this.columnsController) {
                fe.resetFilter();
            }
            this.filtersHandler.enableNotifications(true);
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.look != null) {
            this.backgroundSet = true;
            this.look.background = bg;
            this.lookUpdated();
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.look != null) {
            this.foregroundSet = true;
            this.look.foreground = fg;
            this.lookUpdated();
        }
    }

    public void setDisabledForeground(Color dfg) {
        this.disabledColorSet = true;
        this.look.disabledForeground = dfg;
        this.lookUpdated();
    }

    public Color getDisabledForeground() {
        return this.look.disabledForeground;
    }

    public void setDisabledBackground(Color dbg) {
        this.disabledBgColorSet = true;
        this.look.disabledBackground = dbg;
        this.lookUpdated();
    }

    public Color getDisabledBackground() {
        return this.look.disabledBackground;
    }

    public void setSelectionForeground(Color fg) {
        this.selectionForegroundSet = true;
        this.look.selectionForeground = fg;
        this.lookUpdated();
    }

    public Color getSelectionForeground() {
        return this.look.selectionForeground;
    }

    public void setSelectionBackground(Color bg) {
        this.selectionBackgroundSet = true;
        this.look.selectionBackground = bg;
        this.lookUpdated();
    }

    public Color getSelectionBackground() {
        return this.look.selectionBackground;
    }

    public void setTextSelectionColor(Color c) {
        this.selectionColorSet = true;
        this.look.textSelection = c;
        this.lookUpdated();
    }

    public Color getTextSelectionColor() {
        return this.look.textSelection;
    }

    public void setErrorForeground(Color fg) {
        this.errorColorSet = true;
        this.look.errorForeground = fg;
        this.lookUpdated();
    }

    public Color getErrorForeground() {
        return this.look.errorForeground;
    }

    public void setWarningForeground(Color fg) {
        this.warningColorSet = true;
        this.look.warningForeground = fg;
        this.lookUpdated();
    }

    public Color getWarningForeground() {
        return this.look.warningForeground;
    }

    public void setGridColor(Color c) {
        this.gridColorSet = true;
        this.look.gridColor = c;
        this.lookUpdated();
    }

    public Color getGridColor() {
        return this.look.gridColor;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.look != null) {
            this.fontSet = true;
            this.look.font = font;
            this.lookUpdated();
            this.revalidate();
        }
    }

    public void setRowHeightDelta(int filterRowHeightDelta) {
        this.filterRowHeightDelta = filterRowHeightDelta;
        if (this.columnsController != null) {
            this.columnsController.updateHeight();
        }
    }

    public int getRowHeightDelta() {
        return this.filterRowHeightDelta;
    }

    public void setCustomChoiceDecorator(CustomChoiceDecorator decorator) {
        this.look.customChoiceDecorator = decorator;
        this.lookUpdated();
    }

    public CustomChoiceDecorator getCustomChoiceDecorator() {
        return this.look.customChoiceDecorator;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.positionHelper.filterHeaderContainmentUpdate();
    }

    @Override
    public void updateUI() {
        Look look = this.look;
        this.look = null;
        super.updateUI();
        this.look = look;
        if (this.columnsController != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableFilterHeader.this.updateLook();
                }
            });
        }
    }

    void updateLook() {
        this.updateBackground();
        this.updateForeground();
        this.updateSelectionBackground();
        this.updateSelectionForeground();
        this.updateSelectionColor();
        this.updateDisabledForeground();
        this.updateDisabledBackground();
        this.updateErrorForeground();
        this.updateWarningForeground();
        this.updateGridColor();
        this.updateFont();
        this.lookUpdated();
    }

    private void lookUpdated() {
        if (this.columnsController != null) {
            this.columnsController.setLook(this.look);
        }
    }

    private void updateFont() {
        Font f;
        if (this.fontSet) {
            f = this.getFont();
        } else {
            f = FilterSettings.font;
            if (f == null) {
                f = this.getTable().getTableHeader().getFont();
                f = f.deriveFont((float)f.getSize() * 0.9f);
            }
        }
        this.look.font = f;
        super.setFont(f);
    }

    private void updateBackground() {
        Color c;
        if (this.backgroundSet) {
            c = this.getBackground();
        } else {
            c = FilterSettings.backgroundColor;
            if (c == null) {
                JTable table = this.getTable();
                Color background = table.getBackground();
                Color header = table.getTableHeader().getBackground();
                c = new Color((header.getRed() + background.getRed()) / 2, (header.getGreen() + background.getGreen()) / 2, (header.getBlue() + background.getBlue()) / 2);
            }
        }
        this.look.background = c;
        super.setBackground(c);
    }

    private void updateForeground() {
        Color c;
        if (this.foregroundSet) {
            c = this.getForeground();
        } else {
            c = FilterSettings.foregroundColor;
            if (c == null) {
                c = this.getTable().getForeground();
            }
        }
        this.look.foreground = c;
        super.setForeground(c);
    }

    private void updateSelectionBackground() {
        if (!this.selectionBackgroundSet) {
            this.look.selectionBackground = FilterSettings.selectionBackgroundColor;
            if (this.look.selectionBackground == null && this.getTable() != null) {
                this.look.selectionBackground = this.getTable().getSelectionBackground();
            }
        }
    }

    private void updateSelectionForeground() {
        if (!this.selectionForegroundSet) {
            this.look.selectionForeground = FilterSettings.selectionForegroundColor;
            if (this.look.selectionForeground == null && this.getTable() != null) {
                this.look.selectionForeground = this.getTable().getSelectionForeground();
            }
        }
    }

    private void updateSelectionColor() {
        if (!this.selectionColorSet) {
            this.look.textSelection = FilterSettings.selectionColor;
            if (this.look.textSelection == null) {
                Color a = this.getBackground();
                Color b = this.getSelectionBackground();
                if (a != null && b != null) {
                    this.look.textSelection = new Color((a.getRed() + b.getRed()) / 2, (a.getGreen() + b.getGreen()) / 2, (a.getBlue() + b.getBlue()) / 2);
                }
            }
        }
    }

    private void updateDisabledForeground() {
        if (!this.disabledColorSet) {
            this.look.disabledForeground = FilterSettings.disabledColor;
            if (this.look.disabledForeground == null && this.getTable() != null) {
                this.look.disabledForeground = this.getTable().getGridColor();
                if (this.look.disabledForeground.equals(this.getBackground())) {
                    this.look.disabledForeground = Color.lightGray;
                }
            }
        }
    }

    private void updateDisabledBackground() {
        if (!this.disabledBgColorSet) {
            this.look.disabledBackground = FilterSettings.disabledBackgroundColor;
            if (this.look.disabledBackground == null) {
                this.look.disabledBackground = this.look.getBackground();
            }
        }
    }

    private void updateGridColor() {
        if (!this.gridColorSet) {
            this.look.gridColor = FilterSettings.gridColor;
            if (this.look.gridColor == null && this.getTable() != null) {
                this.look.gridColor = this.getTable().getGridColor();
            }
        }
    }

    private void updateErrorForeground() {
        if (!this.errorColorSet) {
            this.look.errorForeground = FilterSettings.errorColor;
            if (this.look.errorForeground == null) {
                this.look.errorForeground = Color.red;
            }
        }
    }

    private void updateWarningForeground() {
        if (!this.warningColorSet) {
            this.look.warningForeground = FilterSettings.warningColor;
            if (this.look.warningForeground == null) {
                this.look.warningForeground = new Color(196, 0, 0);
            }
        }
    }

    private boolean removeController() {
        if (this.columnsController != null) {
            this.columnsController.detach();
            this.remove(this.columnsController);
            this.columnsController = null;
            return true;
        }
        return false;
    }

    void recreateController() {
        this.filtersHandler.enableNotifications(false);
        this.removeController();
        this.columnsController = new FilterColumnsControllerPanel(this.getFont(), this.getForeground(), this.getBackground());
        this.add((Component)this.columnsController, "West");
        this.revalidate();
        this.filtersHandler.enableNotifications(true);
    }

    private class FilterColumnsControllerPanel
    extends JPanel
    implements TableColumnModelListener,
    Runnable,
    Iterable<FilterEditor> {
        private static final long serialVersionUID = -5183169239497633085L;
        private List<FilterColumnPanel> columns;
        private Dimension preferredSize;
        private TableColumnModel tableColumnModel;
        private int autoRun;
        private Boolean handlerEnabled;

        public FilterColumnsControllerPanel(Font font, Color foreground, Color background) {
            super(null);
            super.setFont(font);
            super.setForeground(foreground);
            super.setBackground(background);
            this.tableColumnModel = TableFilterHeader.this.getTable().getColumnModel();
            boolean enabled = TableFilterHeader.this.filtersHandler.isEnabled();
            int count = this.tableColumnModel.getColumnCount();
            this.columns = new ArrayList<FilterColumnPanel>(count);
            for (int i = 0; i < count; ++i) {
                this.createColumn(i, enabled);
            }
            this.preferredSize = new Dimension(0, count == 0 ? 0 : this.columns.get((int)0).h + TableFilterHeader.this.filterRowHeightDelta);
            this.placeComponents();
            this.tableColumnModel.addColumnModelListener(this);
        }

        @Override
        public Iterator<FilterEditor> iterator() {
            final Iterator<FilterColumnPanel> it = this.columns.iterator();
            return new Iterator<FilterEditor>(){

                @Override
                public void remove() {
                }

                @Override
                public FilterEditor next() {
                    return ((FilterColumnPanel)it.next()).editor;
                }

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }
            };
        }

        private void createColumn(int columnView, boolean enableIt) {
            int columnModel = TableFilterHeader.this.getTable().convertColumnIndexToModel(columnView);
            FilterEditor editor = this.createEditor(columnModel, enableIt);
            FilterColumnPanel column = new FilterColumnPanel(this.tableColumnModel.getColumn(columnView), editor);
            column.updateHeight();
            this.columns.add(column);
            this.add(column);
        }

        private FilterEditor createEditor(int modelColumn, boolean enableIt) {
            FilterEditor ret = new FilterEditor(TableFilterHeader.this.filtersHandler, modelColumn, TableFilterHeader.this.getTable().getModel().getColumnClass(modelColumn), TableFilterHeader.this.look);
            ret.setMaxHistory(TableFilterHeader.this.maxHistory);
            ret.setInstantFiltering(TableFilterHeader.this.instantFilteringEnabled);
            ret.setAutoCompletion(TableFilterHeader.this.autoCompletionEnabled);
            ret.getFilter().setEnabled(enableIt);
            TableFilterHeader.this.filtersHandler.addFilterEditor(ret);
            return ret;
        }

        public void detach() {
            for (FilterColumnPanel column : this.columns) {
                column.detach();
            }
            this.tableColumnModel.removeColumnModelListener(this);
        }

        public FilterEditor getFilterEditor(int viewColumn) {
            return this.columns.size() > viewColumn ? this.columns.get((int)viewColumn).editor : null;
        }

        public void updateHeight() {
            int h = 0;
            for (FilterColumnPanel c : this.columns) {
                h = Math.max(h, c.h);
            }
            this.preferredSize.height = h + TableFilterHeader.this.filterRowHeightDelta;
            this.placeComponents();
            this.repaint();
        }

        public void setLook(Look look) {
            boolean fontChange = this.getFont() != look.font;
            this.setBackground(look.background);
            this.setForeground(look.foreground);
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.setLook(look);
                }
            }
            if (fontChange) {
                this.setFont(look.font);
                this.updateHeight();
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.placeComponents();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
                this.columns.add(e.getToIndex(), fcp);
                this.placeComponents();
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            if (this.handlerEnabled == null) {
                this.handlerEnabled = TableFilterHeader.this.filtersHandler.isEnabled();
            }
            this.createColumn(e.getToIndex(), this.handlerEnabled);
            this.update();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            if (this.handlerEnabled == null) {
                this.handlerEnabled = TableFilterHeader.this.filtersHandler.isEnabled();
            }
            FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
            fcp.detach();
            this.remove(fcp);
            this.update();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void update() {
            ++this.autoRun;
            if (SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            if (--this.autoRun == 0 && TableFilterHeader.this.getTable() != null) {
                this.handlerEnabled = null;
                this.updateHeight();
            }
            TableFilterHeader.this.filtersHandler.enableNotifications(true);
        }

        void placeComponents() {
            int x = 0;
            for (FilterColumnPanel fcp : this.columns) {
                fcp.setBounds(x, 0, fcp.w, this.preferredSize.height);
                x += fcp.w;
            }
            this.revalidate();
        }

        @Override
        public Dimension getPreferredSize() {
            JTable table = TableFilterHeader.this.getTable();
            if (table != null) {
                this.preferredSize.width = table.getWidth();
            }
            return this.preferredSize;
        }

        private class FilterColumnPanel
        extends JPanel
        implements PropertyChangeListener,
        IFilterObserver {
            private static final long serialVersionUID = 6858728575542289815L;
            FilterEditor editor;
            int w;
            int h;
            TableColumn tc;

            public FilterColumnPanel(TableColumn tc, FilterEditor editor) {
                super(new BorderLayout());
                this.tc = tc;
                this.w = tc.getWidth();
                this.add((Component)editor, "Center");
                this.h = this.getPreferredSize().height;
                editor.getFilter().addFilterObserver(this);
                for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                    observer.tableFilterEditorCreated(TableFilterHeader.this, editor, tc);
                }
                this.editor = editor;
                tc.addPropertyChangeListener(this);
            }

            public void detach() {
                if (this.editor != null) {
                    TableFilterHeader.this.filtersHandler.removeFilterEditor(this.editor);
                    this.remove(this.editor);
                    this.editor.getFilter().removeFilterObserver(this);
                    for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                        observer.tableFilterEditorExcluded(TableFilterHeader.this, this.editor, this.tc);
                    }
                }
                this.tc.removePropertyChangeListener(this);
            }

            public void setLook(Look look) {
                this.editor.setLook(look);
                Font oldFont = this.getFont();
                if (oldFont != look.font) {
                    this.setFont(look.font);
                    this.updateHeight();
                }
            }

            public void updateHeight() {
                this.h = this.getPreferredSize().height;
                this.revalidate();
            }

            @Override
            public void filterUpdated(IFilter obs) {
                if (this.editor != null) {
                    for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                        observer.tableFilterUpdated(TableFilterHeader.this, this.editor, this.tc);
                    }
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newW = this.tc.getWidth();
                if (this.w != newW) {
                    this.w = newW;
                    FilterColumnsControllerPanel.this.placeComponents();
                }
            }
        }
    }

    public static enum Position {
        TOP,
        INLINE,
        NONE;

    }
}

