/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.text.Format;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.RowFilter;
import javax.swing.UIManager;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.IFilterEditor;

public abstract class CustomChoice {
    public static final int DEFAULT_PRECEDENCE = 0;
    public static final int MATCH_ALL_PRECEDENCE = -255;
    public static final CustomChoice MATCH_ALL = new CustomChoice("", null, -255){
        RowFilter rf = new RowFilter(){

            public boolean include(RowFilter.Entry entry) {
                return true;
            }
        };

        @Override
        public RowFilter getFilter(IFilterEditor editor) {
            return this.rf;
        }
    };
    public static final CustomChoice MATCH_EMPTY = new CustomChoice(FilterSettings.matchEmptyFilterString, FilterSettings.matchEmptyFilterIcon){

        @Override
        public RowFilter getFilter(final IFilterEditor editor) {
            final int modelIndex = editor.getModelIndex();
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object o = entry.getValue(modelIndex);
                    if (o == null) {
                        return true;
                    }
                    if (editor.getRenderer() != null) {
                        return false;
                    }
                    Format fmt = editor.getFormat();
                    String s = fmt == null ? o.toString() : fmt.format(o);
                    return s == null || s.trim().length() == 0;
                }
            };
        }
    };
    private Icon icon;
    private String str;
    private int precedence;

    public CustomChoice(String representation, Icon icon, int precedence) {
        this.icon = icon;
        this.str = representation;
        this.precedence = precedence;
    }

    public CustomChoice(String representation) {
        this(representation, null, 0);
    }

    public CustomChoice(String representation, Icon icon) {
        this(representation, icon, 0);
    }

    public Color getBackground(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Color getForeground(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Font getFont(IFilterEditor editor, boolean isSelected) {
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void decorateComponent(IFilterEditor editor, boolean isSelected, JComponent c, Graphics g) {
        if (this.icon != null) {
            Icon use = c.isEnabled() ? this.icon : UIManager.getLookAndFeel().getDisabledIcon(c, this.icon);
            FontMetrics metrics = g.getFontMetrics(editor.getLook().getCustomChoiceDecorator().getFont(this, editor, isSelected));
            int x = Math.max(4 + metrics.stringWidth(this.toString()), (c.getWidth() - use.getIconWidth()) / 2);
            int y = (c.getHeight() - use.getIconHeight()) / 2;
            use.paintIcon(c, g, x, y);
        }
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public abstract RowFilter getFilter(IFilterEditor var1);

    public final String toString() {
        return this.str;
    }
}

