/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.editor.PopupComponent;

class HistoryListModel
extends AbstractListModel {
    private static final long serialVersionUID = -374115548677017807L;
    private List<Object> history = new ArrayList<Object>();
    private List<Object> historyLC;
    private int maxHistory = FilterSettings.maxVisiblePopupRows;
    private boolean stringContent = true;
    private boolean ignoreCase;

    HistoryListModel() {
    }

    public void setIgnoreCase(boolean set) {
        this.ignoreCase = set;
    }

    public boolean setStringContent(boolean set) {
        if (this.stringContent != set) {
            this.stringContent = set;
            this.clear();
            return true;
        }
        return false;
    }

    @Override
    public Object getElementAt(int index) {
        return this.history.get(index);
    }

    public boolean add(Object st) {
        boolean ret = false;
        if (this.maxHistory > 0) {
            this.history.remove(st);
            this.history.add(0, st);
            int size = this.history.size();
            if (size > this.maxHistory) {
                this.history.remove(--size);
                this.fireContentsChanged(this, 0, this.maxHistory);
            } else {
                ret = true;
                this.fireIntervalAdded(this, 0, 0);
            }
            this.historyLC = null;
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    public void clear() {
        int size = this.history.size();
        if (size > 0) {
            this.history.clear();
            this.fireIntervalRemoved(this, 0, size);
            this.historyLC = null;
        }
    }

    @Override
    public int getSize() {
        return this.history.size();
    }

    public boolean setMaxHistory(int size) {
        this.maxHistory = size;
        int current = this.history.size();
        if (current > size) {
            for (int i = current - 1; i >= size; --i) {
                this.history.remove(i);
            }
            this.fireContentsChanged(this, this.maxHistory, current);
            this.historyLC = null;
            return true;
        }
        return false;
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    public PopupComponent.Match getClosestMatch(Object hint, boolean exact) {
        if (this.stringContent && hint instanceof String) {
            List<Object> list = this.history;
            if (this.ignoreCase) {
                if (this.historyLC == null) {
                    this.historyLC = new ArrayList<Object>(this.history.size() + 1);
                    for (Object o : this.history) {
                        if (o instanceof String) {
                            o = ((String)o).toLowerCase();
                        }
                        this.historyLC.add(o);
                    }
                }
                list = this.historyLC;
                hint = ((String)hint).toLowerCase();
            }
            return this.findOnUnsortedContent(list, (String)hint, exact);
        }
        return new PopupComponent.Match(this.history.indexOf(hint));
    }

    private PopupComponent.Match findOnUnsortedContent(List list, String strStart, boolean fullMatch) {
        PopupComponent.Match ret = new PopupComponent.Match();
        if (list.isEmpty()) {
            ret.index = -1;
        } else {
            ret.len = strStart.length();
            ret.index = list.indexOf(strStart);
            if (ret.index != -1) {
                ret.exact = true;
            } else {
                ret.index = 0;
                ret.exact = ret.len == 0;
                int originalLen = ret.len;
                while (ret.len > 0) {
                    for (Object o : list) {
                        String os;
                        if (o instanceof String && (os = (String)o).startsWith(strStart)) {
                            ret.exact = os.length() == originalLen;
                            return ret;
                        }
                        ++ret.index;
                    }
                    if (fullMatch) {
                        ret.index = -1;
                        break;
                    }
                    ret.index = 0;
                    strStart = strStart.substring(0, --ret.len);
                }
            }
        }
        return ret;
    }
}

