/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.coderazzi.filters.BaseFilter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.gui.editor.EditorComponent;
import net.coderazzi.filters.gui.editor.PopupComponent;

public class FilterEditor
extends JComponent {
    private static final long serialVersionUID = 6908400421021655278L;
    private AutoOptionsHandler autoOptionsHandler;
    private PropertyChangeListener textParserListener;
    private EditorBorder border = new EditorBorder();
    FilterArrowButton downButton = new FilterArrowButton();
    Filter filter = new Filter();
    EditorComponent editor;
    PopupComponent popup;

    public FilterEditor() {
        this.setLayout(new BorderLayout());
        this.setBorder(this.border);
        this.textParserListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterEditor.this.popup.setIgnoreCase(((IFilterTextParser)evt.getSource()).isIgnoreCase());
                FilterEditor.this.filter.update();
            }
        };
        this.popup = new PopupComponent(){

            @Override
            protected void optionSelected(Object selection) {
                FilterEditor.this.popupSelection(selection);
            }
        };
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.triggerPopup(FilterEditor.this.downButton);
            }
        });
        this.downButton.setCanPopup(false);
        this.add((Component)this.downButton, "East");
        this.setupEditorComponent(null);
        this.setFont(this.editor.getComponent().getFont());
        this.setBackground(this.editor.getComponent().getBackground());
        this.setForeground(this.editor.getForeground());
        this.setDisabledForeground(Color.lightGray);
    }

    public void setMaxVisibleRows(int maxVisibleRows) {
        this.popup.setMaxVisibleRows(maxVisibleRows);
    }

    public int getMaxVisibleRows() {
        return this.popup.getMaxVisibleRows();
    }

    public void setMaxHistory(int size) {
        this.popup.setMaxHistory(size);
    }

    public int getMaxHistory() {
        return this.popup.getMaxHistory();
    }

    public IFilter getFilter() {
        return this.filter;
    }

    public Object getContent() {
        return this.editor.getContent();
    }

    public void setContent(Object content) {
        if (content == null) {
            this.setEditorContent("");
        } else if (this.isEditable()) {
            this.setEditorContent(this.popup.format(content));
        } else if (this.popup.isValidOption(content)) {
            this.setEditorContent(this.popup.format(content));
        }
    }

    private void setEditorContent(Object content) {
        this.editor.setContent(content);
        this.filter.checkChanges();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.filter != null) {
            this.downButton.setEnabled(enabled);
            this.editor.setEnabled(enabled);
            this.filter.update();
        }
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.editor != null) {
            this.editor.getComponent().setBackground(bg);
            this.downButton.setBackground(bg);
            this.popup.setBackground(bg);
            this.repaint();
        }
    }

    public void setErrorForeground(Color fg) {
        this.editor.setErrorForeground(fg);
    }

    public Color getErrorForeground() {
        return this.editor.getErrorForeground();
    }

    public void setDisabledForeground(Color fg) {
        this.editor.setDisabledForeground(fg);
        this.downButton.setDisabledColor(fg);
        this.popup.setDisabledColor(fg);
        this.border.setColor(fg);
    }

    public Color getDisabledForeground() {
        return this.editor.getDisabledForeground();
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.editor != null) {
            this.editor.setForeground(fg);
            this.downButton.setForeground(fg);
            this.popup.setForeground(fg);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.editor != null) {
            this.editor.getComponent().setFont(font);
            this.popup.setFont(font);
        }
    }

    public void detach() {
        this.unsetAutoOptions();
    }

    public void resetFilter() {
        this.setEditorContent("");
        if (this.autoOptionsHandler != null) {
            TableModel model = this.autoOptionsHandler.tableModel;
            this.setAutoOptions(model);
        } else if (this.getListCellRenderer() == null) {
            this.clearOptions();
            this.setEditable(true);
        }
    }

    public void setTextParser(IFilterTextParser parser) {
        this.releaseTextParser();
        parser.addPropertyChangeListener(this.textParserListener);
        this.popup.setIgnoreCase(parser.isIgnoreCase());
        this.editor.setTextParser(parser);
        this.filter.checkChanges();
    }

    private void releaseTextParser() {
        IFilterTextParser parser = this.editor.getTextParser();
        if (parser != null) {
            parser.removePropertyChangeListener(this.textParserListener);
        }
    }

    public IFilterTextParser getTextParser() {
        return this.editor.getTextParser();
    }

    public void setFilterPosition(int filterPosition) {
        this.editor.setPosition(filterPosition);
        this.filter.checkChanges();
    }

    public int getFilterPosition() {
        return this.editor.getPosition();
    }

    public void setFormat(Format format) {
        this.popup.setFormat(format);
    }

    public void setOptions(Collection<?> options) {
        this.popup.clear();
        this.addOptions(options);
    }

    public void addOptions(Collection<?> options) {
        this.popup.addOptions(options);
        this.downButton.setCanPopup(this.popup.hasContent());
    }

    public void clearOptions() {
        this.popup.clear();
        this.downButton.setCanPopup(this.popup.hasContent());
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.popup.setListCellRenderer(renderer);
        this.setupEditorComponent(renderer);
        this.editor.getComponent().setBackground(this.getBackground());
        this.editor.setForeground(this.getForeground());
        this.editor.getComponent().setFont(this.getFont());
    }

    public ListCellRenderer getListCellRenderer() {
        return this.popup.getListCellRenderer();
    }

    public void setEditable(boolean enable) {
        if (!this.popup.hasOptions()) {
            enable = true;
        }
        if (enable != this.isEditable()) {
            this.editor.setEditable(enable);
        }
    }

    public boolean isEditable() {
        return this.editor.isEditable();
    }

    public void setAutoOptions(TableModel tableModel) {
        this.unsetAutoOptions();
        if (tableModel != null) {
            this.autoOptionsHandler = new AutoOptionsHandler(tableModel);
        }
    }

    public boolean isAutoOptions() {
        return this.autoOptionsHandler != null;
    }

    public void unsetAutoOptions() {
        if (this.autoOptionsHandler != null) {
            this.autoOptionsHandler.detach();
            this.autoOptionsHandler = null;
        }
    }

    private void setupEditorComponent(ListCellRenderer renderer) {
        EditorComponent newComponent = null;
        if (renderer == null) {
            if (!(this.editor instanceof EditorComponent.Text)) {
                newComponent = new EditorComponent.Text(this.popup);
            }
        } else if (!(this.editor instanceof EditorComponent.Rendered)) {
            newComponent = this.popup.createRenderedEditorComponent();
            newComponent.getComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (FilterEditor.this.isEnabled()) {
                        FilterEditor.this.triggerPopup(FilterEditor.this.editor.getComponent());
                    }
                }
            });
            newComponent.getComponent().setPreferredSize(this.editor.getComponent().getPreferredSize());
        }
        if (newComponent != null) {
            if (this.editor != null) {
                this.remove(this.editor.getComponent());
                newComponent.setTextParser(this.editor.getTextParser());
                newComponent.setPosition(this.editor.getPosition());
                newComponent.getComponent().setBackground(this.editor.getComponent().getBackground());
                newComponent.setForeground(this.editor.getForeground());
                newComponent.setErrorForeground(this.editor.getErrorForeground());
                newComponent.getComponent().setFont(this.editor.getComponent().getFont());
                newComponent.setErrorForeground(this.editor.getErrorForeground());
                newComponent.setDisabledForeground(this.editor.getDisabledForeground());
            }
            this.editor = newComponent;
            this.setupComponent(this.editor.getComponent());
            this.add((Component)this.editor.getComponent(), "Center");
            this.invalidate();
        }
        this.setEnabled(this.isEnabled());
    }

    private void setupComponent(JComponent component) {
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                FilterEditor.this.editor.focusGained(false);
                FilterEditor.this.popup.hide();
                FilterEditor.this.filter.checkChanges();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (FilterEditor.this.isEnabled() && FilterEditor.this.editor.focusGained(true)) {
                    FilterEditor.this.showOptions();
                    FilterEditor.this.popup.setPopupFocused(true);
                }
            }
        });
        component.setBorder(null);
        component.setFocusable(true);
        component.setEnabled(this.isEnabled());
        this.setupEnterKey(component);
        this.setupEscKey(component);
        this.setupHomeKey(component);
        this.setupHomeCtrlKey(component);
        this.setupEndKey(component);
        this.setupEndCtrlKey(component);
        this.setupUpKey(component);
        this.setupUpCtrlKey(component);
        this.setupUpPageKey(component);
        this.setupDownPageKey(component);
        this.setupDownKey(component);
        this.setupDownCtrlKey(component);
    }

    void popupSelection(Object selection) {
        if (selection != null) {
            this.setEditorContent(selection);
        }
    }

    void showOptions() {
        if (!this.popup.isVisible()) {
            this.popup.display(this.editor.getComponent());
            this.popup.selectBestMatch(this.editor.getContent(), false);
        }
    }

    void triggerPopup(Object source) {
        if (!this.popup.isMenuCanceledForMouseEvent(source)) {
            this.editor.getComponent().requestFocus();
            this.showOptions();
            this.popup.setPopupFocused(true);
        }
    }

    private void setupEnterKey(JComponent component) {
        String actionName = "FCB_ENTER";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 6926912268574067920L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused()) {
                    FilterEditor.this.popupSelection(FilterEditor.this.popup.getSelection());
                } else {
                    FilterEditor.this.filter.checkChanges();
                }
                FilterEditor.this.popup.hide();
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), actionName);
    }

    private void setupEscKey(JComponent component) {
        String actionName = "FCB_ESC";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -4351240441578952476L;

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterEditor.this.popup.hide();
                if (e.getSource() instanceof JTextField) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getCaretPosition());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(27, 0), actionName);
    }

    private void setupEndKey(JComponent component) {
        String actionName = "FCB_END";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -2777729244353281164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(false) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 0), actionName);
    }

    private void setupEndCtrlKey(JComponent component) {
        String actionName = "FCB_END_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 1945871436968682881L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectLast(true) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(textField.getText().length());
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(35, 2), actionName);
    }

    private void setupHomeCtrlKey(JComponent component) {
        String actionName = "FCB_HOME_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 3916227645612863334L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(true) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 2), actionName);
    }

    private void setupHomeKey(JComponent component) {
        String actionName = "FCB_HOME";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -1583258893221830664L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!(FilterEditor.this.popup.isPopupFocused() && FilterEditor.this.popup.selectFirst(false) || !(e.getSource() instanceof JTextField))) {
                    JTextField textField = (JTextField)e.getSource();
                    textField.setCaretPosition(0);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(36, 0), actionName);
    }

    private void setupDownPageKey(JComponent component) {
        String actionName = "FCB_PAGE_DOWN";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -1187830005921916553L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectDownPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                } else {
                    FilterEditor.this.showOptions();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(34, 0), actionName);
    }

    private void setupUpPageKey(JComponent component) {
        String actionName = "FCB_PAGE_UP";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 6590487133211390977L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    boolean focusPopup = FilterEditor.this.popup.isPopupFocused();
                    FilterEditor.this.popup.selectUpPage();
                    FilterEditor.this.popup.setPopupFocused(focusPopup);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(33, 0), actionName);
    }

    private void setupUpCtrlKey(JComponent component) {
        String actionName = "FCB_UP_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 746565926592574009L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isPopupFocused() && !FilterEditor.this.popup.selectUp(true)) {
                    FilterEditor.this.popup.setPopupFocused(false);
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 2), actionName);
    }

    private void setupUpKey(JComponent component) {
        String actionName = "FCB_UP";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = 4555560696351340571L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectUp(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showOptions();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(38, 0), actionName);
    }

    private void setupDownCtrlKey(JComponent component) {
        String actionName = "FCB_DOWN_CTRL";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -8075976293862885060L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(true);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showOptions();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 2), actionName);
    }

    private void setupDownKey(JComponent component) {
        String actionName = "FCB_DOWN";
        AbstractAction action = new AbstractAction(actionName){
            private static final long serialVersionUID = -4133513199725709434L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FilterEditor.this.popup.isVisible()) {
                    if (FilterEditor.this.popup.isPopupFocused()) {
                        FilterEditor.this.popup.selectDown(false);
                    } else {
                        FilterEditor.this.popup.setPopupFocused(true);
                    }
                } else {
                    FilterEditor.this.showOptions();
                }
            }
        };
        component.getActionMap().put(actionName, action);
        component.getInputMap(0).put(KeyStroke.getKeyStroke(40, 0), actionName);
    }

    final class AutoOptionsHandler
    implements TableModelListener {
        TableModel tableModel;

        public AutoOptionsHandler(TableModel tableModel) {
            this.tableModel = tableModel;
            this.extractFilterContentsFromModel();
            tableModel.addTableModelListener(this);
        }

        public void detach() {
            this.tableModel.removeTableModelListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int c;
            int r = e.getFirstRow();
            if (r == -1) {
                this.extractFilterContentsFromModel();
            } else if (e.getType() != -1 && ((c = e.getColumn()) == -1 || c == FilterEditor.this.getFilterPosition())) {
                this.extendFilterContentsFromModel(r, e.getLastRow());
            }
        }

        private void extractFilterContentsFromModel() {
            FilterEditor.this.clearOptions();
            this.extendFilterContentsFromModel(0, this.tableModel.getRowCount() - 1);
        }

        private void extendFilterContentsFromModel(int firstRow, int lastRow) {
            ArrayList<Object> all = new ArrayList<Object>();
            int column = FilterEditor.this.getFilterPosition();
            lastRow = Math.min(this.tableModel.getRowCount() - 1, lastRow);
            while (lastRow >= firstRow) {
                all.add(this.tableModel.getValueAt(firstRow++, column));
            }
            FilterEditor.this.addOptions(all);
        }
    }

    final class EditorBorder
    implements Border {
        private Color borderColor;

        EditorBorder() {
        }

        public void setColor(Color color) {
            this.borderColor = color;
            FilterEditor.this.repaint();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.borderColor);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 0, width - 1, height - 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 1, 1, 1);
        }
    }

    final class Filter
    extends BaseFilter {
        RowFilter delegateFilter;

        Filter() {
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            return this.delegateFilter == null ? true : this.delegateFilter.include(entry);
        }

        public void checkChanges() {
            if (FilterEditor.this.isEnabled()) {
                this.checkChanges(false);
                Object content = FilterEditor.this.editor.getContent();
                if (!"".equals(content)) {
                    FilterEditor.this.popup.addHistory(content);
                    FilterEditor.this.downButton.setCanPopup(FilterEditor.this.popup.hasContent());
                }
            }
        }

        public void update() {
            if (FilterEditor.this.isEnabled()) {
                this.checkChanges(true);
            } else {
                this.delegateFilter = null;
                this.reportFilterUpdatedToObservers();
            }
        }

        private void checkChanges(boolean forceUpdate) {
            if (FilterEditor.this.editor.checkFilterUpdate(forceUpdate)) {
                this.delegateFilter = FilterEditor.this.editor.getFilter();
                this.reportFilterUpdatedToObservers();
            }
        }
    }

    static final class FilterArrowButton
    extends JButton {
        private static final long serialVersionUID = -777416843479142582L;
        private static final int[] FILL_X = new int[]{0, 3, 6};
        private static final int[] FILL_Y = new int[]{0, 5, 0};
        private static final int MIN_X = 6;
        private static final int MIN_Y = 6;
        private boolean canPopup = true;
        private boolean enabled = true;
        private Color disabledColor;

        FilterArrowButton() {
        }

        public void setCanPopup(boolean full) {
            this.canPopup = full;
            super.setEnabled(full && this.enabled);
        }

        public void setDisabledColor(Color color) {
            this.disabledColor = color;
            if (!this.isEnabled()) {
                this.repaint();
            }
        }

        @Override
        public void setEnabled(boolean b) {
            this.enabled = b;
            super.setEnabled(this.canPopup && this.enabled);
        }

        @Override
        public void paint(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int height = this.getHeight();
            int width = this.getWidth();
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
            width = (width - 6) / 2;
            height = Math.min(height / 2, height - 6);
            g.translate(width, height);
            if (this.enabled && this.canPopup) {
                g.setColor(this.getForeground());
            } else {
                g.setColor(this.disabledColor);
            }
            g.fillPolygon(FILL_X, FILL_Y, FILL_X.length);
        }

        @Override
        protected void paintBorder(Graphics g) {
            super.paintBorder(g);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(12, 12);
        }
    }
}

