/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.TableFilter;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.IFilterHeaderObserver;
import net.coderazzi.filters.gui.PositionHelper;
import net.coderazzi.filters.gui.editor.FilterEditor;

public class TableFilterHeader
extends JPanel {
    private static final long serialVersionUID = 5217701111228491294L;
    private Color errorColor;
    private Color disabledForeground = Color.lightGray;
    private boolean backgroundSet = false;
    private boolean foregroundSet = false;
    private boolean disabledSet;
    private boolean fontSet = false;
    private boolean enabled = true;
    private boolean autoOptions = FilterSettings.autoOptions;
    private PositionHelper positionHelper = new PositionHelper(this);
    int maxVisibleRows = FilterSettings.maxVisiblePopupRows;
    FilterColumnsControllerPanel columnsController;
    IFilterTextParser filterTextParser;
    JTable table;
    TableFilter filtersHandler = new TableFilter();
    Set<IFilterHeaderObserver> observers = new HashSet<IFilterHeaderObserver>();
    private ComponentAdapter resizer = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent e) {
            if (TableFilterHeader.this.columnsController != null) {
                TableFilterHeader.this.columnsController.revalidate();
            }
        }
    };

    public TableFilterHeader() {
        this((JTable)null);
    }

    public TableFilterHeader(JTable table) {
        this(table, FilterSettings.headerPosition);
    }

    public TableFilterHeader(JTable table, Position location) {
        super(new BorderLayout());
        this.setPosition(location);
        this.setTable(table);
    }

    public void setTable(JTable table) {
        this.positionHelper.changeTable(this.table, table);
        if (this.table != null) {
            this.table.removeComponentListener(this.resizer);
        }
        this.filtersHandler.setTable(table);
        this.table = table;
        if (table == null) {
            this.removeController();
        } else {
            if (!this.backgroundSet) {
                this.setBackground(this.suggestBackground());
                this.backgroundSet = false;
            }
            if (!this.foregroundSet) {
                Color foreground = FilterSettings.headerForeground;
                if (foreground == null) {
                    foreground = table.getTableHeader().getForeground();
                }
                this.setForeground(foreground);
                this.foregroundSet = false;
            }
            if (!this.disabledSet) {
                Color color = table.getGridColor();
                if (color.equals(this.getBackground())) {
                    color = Color.lightGray;
                }
                this.setDisabledForeground(color);
                this.disabledSet = false;
            }
            if (!this.fontSet) {
                Font header = table.getTableHeader().getFont();
                this.setFont(header.deriveFont((float)header.getSize() * 0.9f));
                this.fontSet = false;
            }
            this.recreateController();
            this.table.addComponentListener(this.resizer);
            this.getTextParser().setTableModel(table.getModel());
        }
    }

    private Color suggestBackground() {
        Color background = FilterSettings.headerBackground;
        if (background == null) {
            Color header = this.table.getTableHeader().getBackground();
            Color cells = this.table.getBackground();
            background = new Color((header.getRed() + cells.getRed()) / 2, (header.getGreen() + cells.getGreen()) / 2, (header.getBlue() + cells.getBlue()) / 2);
        }
        return background;
    }

    public JTable getTable() {
        return this.table;
    }

    public TableFilter getTableFilter() {
        return this.filtersHandler;
    }

    public void setTableFilter(TableFilter filter) {
        for (IFilter obs : this.filtersHandler.getFilterObservables()) {
            filter.addFilter(obs);
        }
        filter.setTable(this.filtersHandler.getTable());
        this.filtersHandler.detach();
        this.filtersHandler = filter;
    }

    public void setPosition(Position location) {
        this.positionHelper.setPosition(location);
    }

    public Position getPosition() {
        return this.positionHelper.getPosition();
    }

    public void resetFilter() {
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.resetFilters();
            this.filtersHandler.enableNotifications(true);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.positionHelper.filterHeaderContainmentUpdate();
    }

    private boolean removeController() {
        if (this.columnsController != null) {
            this.columnsController.detach();
            this.remove(this.columnsController);
            this.columnsController = null;
            return true;
        }
        return false;
    }

    void recreateController() {
        this.filtersHandler.enableNotifications(false);
        this.removeController();
        this.columnsController = new FilterColumnsControllerPanel(this.getFont(), this.getForeground(), this.getBackground());
        this.columnsController.setEnabled(this.isEnabled());
        this.add((Component)this.columnsController, "Center");
        this.revalidate();
        this.filtersHandler.enableNotifications(true);
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.backgroundSet = true;
        if (this.columnsController != null) {
            this.columnsController.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.foregroundSet = true;
        if (this.columnsController != null) {
            this.columnsController.setForeground(fg);
        }
    }

    public void setDisabledForeground(Color dfg) {
        this.disabledForeground = dfg;
        this.disabledSet = true;
        if (this.columnsController != null) {
            this.columnsController.setDisabledForeground(dfg);
        }
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public void setErrorForeground(Color fg) {
        this.errorColor = fg;
        if (this.columnsController != null) {
            this.columnsController.setErrorForeground(fg);
        }
    }

    public Color getErrorForeground() {
        return this.errorColor;
    }

    public void setMaxVisibleRows(int maxVisibleRows) {
        this.maxVisibleRows = maxVisibleRows;
        if (this.columnsController != null) {
            this.columnsController.setMaxVisibleRows(maxVisibleRows);
        }
    }

    public int getMaxVisibleRows() {
        return this.maxVisibleRows;
    }

    FilterEditor createEditor(int modelColumn) {
        FilterEditor ret = FilterSettings.newFilterEditor();
        ret.setFormat(this.getTextParser().getFormat(this.table.getModel().getColumnClass(modelColumn)));
        ret.setTextParser(this.getTextParser());
        ret.setFilterPosition(modelColumn);
        if (!this.populateBasicEditorOptions(ret, true) && this.autoOptions) {
            ret.setAutoOptions(this.table.getModel());
        }
        return ret;
    }

    protected void customizeEditor(FilterEditor editor) {
        editor.setForeground(this.getForeground());
        editor.setBackground(this.getBackground());
        editor.setDisabledForeground(this.getDisabledForeground());
        editor.setMaxVisibleRows(this.maxVisibleRows);
        Color color = this.getDisabledForeground();
        if (color != null) {
            editor.setDisabledForeground(color);
        }
        if ((color = this.getErrorForeground()) != null) {
            editor.setErrorForeground(color);
        }
        editor.setFont(this.getFont());
    }

    boolean populateBasicEditorOptions(FilterEditor editor, boolean fixMaxHistory) {
        ArrayList<Boolean> options;
        Class<?> c = this.table.getModel().getColumnClass(editor.getFilterPosition());
        if (c.equals(Boolean.class)) {
            options = new ArrayList<Boolean>(3);
            options.add(true);
            options.add(false);
        } else if (c.isEnum()) {
            ?[] enums = c.getEnumConstants();
            options = new ArrayList(enums.length + 1);
            for (Object each : enums) {
                options.add((Boolean)each);
            }
        } else {
            return false;
        }
        editor.setOptions(options);
        editor.setEditable(false);
        if (fixMaxHistory && options.size() <= 8) {
            editor.setMaxHistory(0);
        }
        return true;
    }

    public FilterEditor getFilterEditor(int modelColumn) {
        return this.columnsController == null ? null : this.columnsController.getFilterEditor(this.table.convertColumnIndexToView(modelColumn));
    }

    public void setTableCellRenderer(final int modelColumn, final TableCellRenderer renderer) {
        this.getFilterEditor(modelColumn).setListCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -5990815893475331934L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component ret = renderer.getTableCellRendererComponent(TableFilterHeader.this.table, value, isSelected, cellHasFocus, 1, modelColumn);
                if (!isSelected) {
                    ret.setBackground(list.getBackground());
                    ret.setForeground(list.getForeground());
                }
                return ret;
            }
        });
    }

    public void setTextParser(IFilterTextParser parser) {
        this.filterTextParser = parser;
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.updateTextParser();
            this.filtersHandler.enableNotifications(true);
        }
    }

    public IFilterTextParser getTextParser() {
        if (this.filterTextParser == null) {
            this.filterTextParser = FilterSettings.newTextParser();
            if (this.table != null) {
                this.filterTextParser.setTableModel(this.table.getModel());
            }
        }
        return this.filterTextParser;
    }

    @Override
    public void setVisible(boolean flag) {
        if (this.isVisible() != flag) {
            this.positionHelper.headerVisibilityChanged(flag);
        }
        super.setVisible(flag);
        this.positionHelper.headerVisibilityChanged(flag);
    }

    public void setAutoOptions(boolean set) {
        if (this.autoOptions != set) {
            this.autoOptions = set;
            if (this.columnsController != null) {
                this.filtersHandler.enableNotifications(false);
                this.columnsController.setAutoOptions(set);
                this.filtersHandler.enableNotifications(true);
            }
        }
    }

    public boolean isAutoOptions() {
        return this.autoOptions;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.columnsController != null) {
            this.filtersHandler.enableNotifications(false);
            this.columnsController.setEnabled(enabled);
            this.filtersHandler.enableNotifications(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontSet = true;
        if (this.columnsController != null) {
            this.columnsController.setFont(font);
            this.revalidate();
        }
    }

    public void addHeaderObserver(IFilterHeaderObserver observer) {
        this.observers.add(observer);
    }

    public void removeHeaderObserver(IFilterHeaderObserver observer) {
        this.observers.remove(observer);
    }

    private class FilterColumnsControllerPanel
    extends JPanel
    implements TableColumnModelListener,
    Runnable {
        private static final long serialVersionUID = -5183169239497633085L;
        private List<FilterColumnPanel> columns;
        private Dimension preferredSize;
        private TableColumnModel tableColumnModel;
        private int autoRun;

        public FilterColumnsControllerPanel(Font font, Color foreground, Color background) {
            super(null);
            super.setFont(font);
            super.setForeground(foreground);
            super.setBackground(background);
            this.tableColumnModel = TableFilterHeader.this.table.getColumnModel();
            int count = this.tableColumnModel.getColumnCount();
            this.columns = new ArrayList<FilterColumnPanel>(count);
            for (int i = 0; i < count; ++i) {
                this.createColumn(i);
            }
            this.preferredSize = new Dimension(0, count == 0 ? 0 : this.columns.get((int)0).h);
            this.placeComponents();
            this.tableColumnModel.addColumnModelListener(this);
        }

        private void createColumn(int columnView) {
            int columnModel = TableFilterHeader.this.table.convertColumnIndexToModel(columnView);
            FilterEditor editor = TableFilterHeader.this.createEditor(columnModel);
            TableFilterHeader.this.filtersHandler.addFilter(editor.getFilter());
            FilterColumnPanel column = new FilterColumnPanel(this.tableColumnModel.getColumn(columnView), editor);
            TableFilterHeader.this.customizeEditor(column.editor);
            column.updateHeight();
            this.columns.add(column);
            this.add(column);
        }

        public void detach() {
            for (FilterColumnPanel column : this.columns) {
                column.detach();
            }
            this.tableColumnModel.removeColumnModelListener(this);
        }

        public FilterEditor getFilterEditor(int viewColumn) {
            return this.columns.size() > viewColumn ? this.columns.get((int)viewColumn).editor : null;
        }

        private void updateHeight() {
            int h = 0;
            for (FilterColumnPanel c : this.columns) {
                h = Math.max(h, c.h);
            }
            this.preferredSize.height = h;
            this.placeComponents();
            this.repaint();
        }

        public void updateTextParser() {
            for (FilterColumnPanel column : this.columns) {
                column.editor.setTextParser(TableFilterHeader.this.filterTextParser);
            }
        }

        public void resetFilters() {
            for (FilterColumnPanel column : this.columns) {
                column.editor.resetFilter();
                TableFilterHeader.this.populateBasicEditorOptions(column.editor, false);
            }
        }

        public void setMaxVisibleRows(int maxVisibleRows) {
            for (FilterColumnPanel column : this.columns) {
                column.editor.setMaxVisibleRows(maxVisibleRows);
            }
        }

        public void setAutoOptions(boolean set) {
            for (FilterColumnPanel column : this.columns) {
                Class<?> c = TableFilterHeader.this.table.getModel().getColumnClass(column.editor.getFilterPosition());
                if (c.equals(Boolean.class) || c.isEnum()) continue;
                column.editor.setAutoOptions(set ? TableFilterHeader.this.table.getModel() : null);
            }
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.columns != null && !this.columns.isEmpty()) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.setFont(font);
                }
                this.updateHeight();
            }
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.editor.setBackground(bg);
                }
            }
        }

        public void setDisabledForeground(Color bg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.editor.setDisabledForeground(bg);
                }
            }
        }

        @Override
        public void setForeground(Color fg) {
            super.setForeground(fg);
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.editor.setForeground(fg);
                }
            }
        }

        public void setErrorForeground(Color fg) {
            if (this.columns != null) {
                for (FilterColumnPanel panel : this.columns) {
                    panel.editor.setErrorForeground(fg);
                }
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (FilterColumnPanel filter : this.columns) {
                filter.setEnabled(enabled);
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            this.placeComponents();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            if (e.getFromIndex() != e.getToIndex()) {
                FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
                this.columns.add(e.getToIndex(), fcp);
                this.placeComponents();
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            this.createColumn(e.getToIndex());
            this.updateHeight();
            this.update();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            TableFilterHeader.this.filtersHandler.enableNotifications(false);
            FilterColumnPanel fcp = this.columns.remove(e.getFromIndex());
            fcp.detach();
            this.updateHeight();
            this.remove(fcp);
            this.update();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        private void update() {
            ++this.autoRun;
            if (SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this);
            } else {
                this.run();
            }
        }

        @Override
        public void run() {
            if (--this.autoRun == 0 && TableFilterHeader.this.table != null) {
                TableFilterHeader.this.getTextParser().setTableModel(TableFilterHeader.this.table.getModel());
            }
            TableFilterHeader.this.filtersHandler.enableNotifications(true);
        }

        void placeComponents() {
            int x = 0;
            for (FilterColumnPanel fcp : this.columns) {
                fcp.setBounds(x, 0, fcp.w, this.preferredSize.height);
                x += fcp.w;
            }
            this.revalidate();
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }

        private class FilterColumnPanel
        extends JPanel
        implements PropertyChangeListener,
        IFilterObserver {
            private static final long serialVersionUID = 6858728575542289815L;
            FilterEditor editor;
            int w;
            int h;
            TableColumn tc;

            public FilterColumnPanel(TableColumn tc, FilterEditor editor) {
                super(new BorderLayout());
                this.tc = tc;
                this.w = tc.getWidth();
                this.setFilterEditor(editor);
                tc.addPropertyChangeListener(this);
            }

            public void detach() {
                if (this.editor != null) {
                    TableFilterHeader.this.filtersHandler.removeFilter(this.editor.getFilter());
                    this.removeEditor(this.editor);
                }
                this.tc.removePropertyChangeListener(this);
            }

            public void setFilterEditor(FilterEditor editor) {
                if (this.editor != null) {
                    this.removeEditor(this.editor);
                }
                this.editor = editor;
                this.add((Component)this.editor, "Center");
                this.h = this.getPreferredSize().height;
                editor.getFilter().addFilterObserver(this);
                for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                    observer.tableFilterEditorCreated(TableFilterHeader.this, editor);
                }
                this.repaint();
            }

            private void removeEditor(FilterEditor editorToRemove) {
                this.remove(this.editor);
                editorToRemove.detach();
                editorToRemove.getFilter().removeFilterObserver(this);
                for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                    observer.tableFilterEditorExcluded(TableFilterHeader.this, editorToRemove);
                }
            }

            @Override
            public void setFont(Font font) {
                super.setFont(font);
                if (this.editor != null) {
                    this.editor.setFont(font);
                    this.updateHeight();
                }
            }

            public void updateHeight() {
                this.h = this.getPreferredSize().height;
                this.revalidate();
            }

            @Override
            public void filterUpdated(IFilter obs) {
                for (IFilterHeaderObserver observer : TableFilterHeader.this.observers) {
                    observer.tableFilterUpdated(TableFilterHeader.this, this.editor);
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                this.editor.setEnabled(enabled);
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                int newW = this.tc.getWidth();
                if (this.w != newW) {
                    this.w = newW;
                    FilterColumnsControllerPanel.this.placeComponents();
                }
            }
        }
    }

    public static enum Position {
        TOP,
        INLINE,
        NONE;

    }
}

