/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.Color;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.gui.TableFilterHeader;
import net.coderazzi.filters.gui.editor.FilterEditor;
import net.coderazzi.filters.parser.FilterTextParser;
import net.coderazzi.filters.parser.Types;

public class FilterSettings {
    public static boolean autoSelection = Boolean.parseBoolean(FilterSettings.getString("AutoSelection", "true"));
    public static boolean autoOptions = Boolean.parseBoolean(FilterSettings.getString("AutoOptions", "false"));
    public static boolean ignoreCase = Boolean.parseBoolean(FilterSettings.getString("IgnoreCase", "false"));
    public static TableFilterHeader.Position headerPosition = TableFilterHeader.Position.valueOf(FilterSettings.getString("Header.Position", "INLINE"));
    public static String dateFormat = FilterSettings.getString("DateFormat", null);
    public static String defaultOperator = FilterSettings.getString("DefaultOperator", "~");
    public static int maxVisiblePopupRows = FilterSettings.getInteger("Popup.maxVisibleRows", 8);
    public static int maxPopupHistory = FilterSettings.getInteger("Popup.maxHistory", 2);
    public static Color headerBackground = null;
    public static Color headerForeground = null;
    public static Types types = new Types();
    public static Class<? extends IFilterTextParser> filterTextParserClass = FilterTextParser.class;
    public static Class<? extends FilterEditor> filterEditorClass;

    public static FilterEditor newFilterEditor() {
        try {
            return filterEditorClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating filter editor of type " + filterEditorClass, ex);
        }
    }

    public static IFilterTextParser newTextParser() {
        try {
            IFilterTextParser ret = filterTextParserClass.newInstance();
            ret.setIgnoreCase(ignoreCase);
            ret.setDefaultOperator(defaultOperator);
            types.configure(ret);
            return ret;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating filter text parser of type " + filterTextParserClass, ex);
        }
    }

    private static String getString(String name, String defaultValue) {
        try {
            return System.getProperty(name, defaultValue);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    private static int getInteger(String name, int defaultValue) {
        try {
            return Integer.valueOf(System.getProperty(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    static {
        String cl = FilterSettings.getString("TextParser.class", null);
        if (cl != null) {
            try {
                filterTextParserClass = Class.forName(cl);
            }
            catch (ClassNotFoundException cne) {
                throw new RuntimeException("Error finding filter text parser of class " + cl, cne);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Filter text parser of class " + cl + " is not a valid IFilterTextParser class");
            }
        }
        filterEditorClass = FilterEditor.class;
        cl = FilterSettings.getString("FilterEditor.class", null);
        if (cl != null) {
            try {
                filterEditorClass = Class.forName(cl);
            }
            catch (ClassNotFoundException cne) {
                throw new RuntimeException("Error finding filter editor of class " + cl, cne);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Filter editor of class " + cl + " is not a valid FilterEditor class");
            }
        }
    }
}

