/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters;

import java.util.HashSet;
import java.util.Set;
import net.coderazzi.filters.BaseFilter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;

public abstract class ComposedFilter
extends BaseFilter
implements IFilterObserver {
    protected Set<IFilter> filters = new HashSet<IFilter>();

    protected ComposedFilter(IFilter ... observables) {
        this.addFilter(observables);
    }

    @Override
    public void detach() {
        super.detach();
        this.filters.clear();
    }

    public void addFilter(IFilter ... filtersToAdd) {
        for (IFilter observable : filtersToAdd) {
            if (!this.filters.add(observable)) continue;
            observable.addFilterObserver(this);
        }
    }

    public void removeFilter(IFilter filter) {
        if (this.filters.remove(filter)) {
            this.reportFilterUpdatedToObservers();
        }
    }

    public Set<IFilter> getFilterObservables() {
        return new HashSet<IFilter>(this.filters);
    }

    @Override
    public void filterUpdated(IFilter producer) {
        this.reportFilterUpdatedToObservers();
    }
}

