/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.RowFilter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;

public abstract class BaseFilter
extends RowFilter
implements IFilter {
    protected Set<IFilterObserver> filterObservers = new HashSet<IFilterObserver>();

    public void detach() {
        this.filterObservers.clear();
    }

    @Override
    public void addFilterObserver(IFilterObserver observer) {
        this.filterObservers.add(observer);
        this.reportFilterUpdatedToObservers();
    }

    @Override
    public void removeFilterObserver(IFilterObserver observer) {
        this.filterObservers.remove(observer);
    }

    public Set<IFilterObserver> getFilterObservers() {
        return new HashSet<IFilterObserver>(this.filterObservers);
    }

    protected void reportFilterUpdatedToObservers() {
        for (IFilterObserver obs : new ArrayList<IFilterObserver>(this.filterObservers)) {
            obs.filterUpdated(this);
        }
    }
}

