/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.parser;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.gui.FilterSettings;

public class Types {
    Map<Class<?>, Format> formatters = new HashMap();
    Map<Class<?>, Comparator<?>> comparators = new HashMap();

    public Types() {
        this.setFormat(String.class, new StringTypeFormat());
        this.setFormat(Boolean.class, new BooleanTypeFormat());
        this.setFormat(Integer.class, new IntegerTypeFormat());
        this.setFormat(Long.class, new LongTypeFormat());
        this.setFormat(Short.class, new ShortTypeFormat());
        this.setFormat(Float.class, new FloatTypeFormat());
        this.setFormat(Double.class, new DoubleTypeFormat());
        this.setFormat(Byte.class, new ByteTypeFormat());
        this.setFormat(Character.class, new CharacterTypeFormat());
        this.setFormat(Date.class, this.getDefaultDateFormat());
    }

    public Format getFormat(Class<?> c) {
        return this.formatters.get(c);
    }

    public void setFormat(Class<?> c, Format format) {
        this.formatters.put(c, format);
    }

    public Comparator<?> getComparator(Class<?> c) {
        return this.comparators.get(c);
    }

    public void setComparator(Class<?> c, Comparator<?> format) {
        this.comparators.put(c, format);
    }

    public void configure(IFilterTextParser textParser) {
        for (Map.Entry<Class<?>, Format> entry : this.formatters.entrySet()) {
            textParser.setFormat(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Class<?>, Object> entry : this.comparators.entrySet()) {
            textParser.setComparator(entry.getKey(), (Comparator)entry.getValue());
        }
    }

    private DateFormat getDefaultDateFormat() {
        String definition = FilterSettings.dateFormat;
        if (definition != null) {
            try {
                return new SimpleDateFormat(definition);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return DateFormat.getDateInstance(3);
    }

    public static class CharacterTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -7238741018044298862L;

        @Override
        public Object parseObject(String text) throws ParseException {
            if (text.length() != 1) {
                throw new ParseException(text, 0);
            }
            return new Character(text.charAt(0));
        }
    }

    public static class ByteTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -8872549512274058519L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Byte.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class DoubleTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -6081024614795175063L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class FloatTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 945229095107692481L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Float.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class ShortTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -2237230150685513628L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Short.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class LongTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 1165105738539025608L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Long.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class IntegerTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 314115124294512565L;

        @Override
        public Object parseObject(String text) throws ParseException {
            try {
                return Integer.valueOf(text);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(text, 0);
            }
        }
    }

    public static class BooleanTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = -6014041038273288651L;

        @Override
        public Object parseObject(String text) {
            return Boolean.valueOf(text);
        }
    }

    public static class StringTypeFormat
    extends TypeFormat {
        private static final long serialVersionUID = 1641138429288273113L;

        @Override
        public Object parseObject(String source) {
            return source;
        }
    }

    static class TypeFormat
    extends Format {
        private static final long serialVersionUID = -6161901343218446716L;

        TypeFormat() {
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(obj);
        }

        @Override
        public Object parseObject(String source) throws ParseException {
            return null;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return null;
        }
    }
}

