/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Format;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.coderazzi.filters.gui.FilterSettings;
import net.coderazzi.filters.gui.editor.EditorComponent;
import net.coderazzi.filters.gui.editor.FilterListCellRenderer;
import net.coderazzi.filters.gui.editor.HistoryListModel;
import net.coderazzi.filters.gui.editor.OptionsListModel;

abstract class PopupComponent
implements PopupMenuListener {
    private static final int MIN_VISIBLE_OPTIONS = 4;
    private JPopupMenu popup;
    private FilterListCellRenderer listRenderer;
    private JScrollPane optionsScrollPane;
    private JScrollPane historyScrollPane;
    private JSeparator separator;
    private OptionsListModel optionsModel;
    private HistoryListModel historyModel;
    private Object cancelReason;
    private int maxVisibleRows = FilterSettings.maxVisiblePopupRows;
    private int maxHistory = FilterSettings.maxPopupHistory;
    JList focusedList;
    JList optionsList;
    JList historyList;

    public PopupComponent() {
        this.optionsModel = new OptionsListModel();
        this.historyModel = new HistoryListModel();
        this.setMaxHistory(this.maxHistory);
        this.createGui();
    }

    protected abstract void optionSelected(Object var1);

    public EditorComponent createRenderedEditorComponent() {
        return new EditorComponent.Rendered(this.listRenderer);
    }

    public Object getSelection() {
        return this.focusedList.getSelectedValue();
    }

    public boolean isVisible() {
        return this.popup.isVisible();
    }

    public boolean display(Component editor) {
        if (this.isVisible() || !this.hasContent()) {
            return false;
        }
        this.setPopupFocused(false);
        int width = editor.getParent().getWidth() - 1;
        this.configurePaneSize(this.optionsScrollPane, width);
        this.configurePaneSize(this.historyScrollPane, width);
        this.popup.show(editor, -editor.getLocation().x - 1, editor.getHeight());
        this.focusedList = this.historyList;
        return true;
    }

    public boolean hide() {
        if (this.isVisible()) {
            this.popup.setVisible(false);
            return true;
        }
        return false;
    }

    public String selectBestMatch(Object hint, boolean perfectMatch) {
        Match historyMatch = this.historyModel.getClosestMatch(hint, perfectMatch);
        if (this.optionsModel.getSize() > 0) {
            Match match = this.optionsModel.getClosestMatch(hint, perfectMatch || historyMatch.exact);
            if (this.isVisible() && match.index >= 0) {
                this.optionsList.ensureIndexIsVisible(match.index);
            }
            if (match.exact || !historyMatch.exact && match.len >= historyMatch.len) {
                if (match.index >= 0) {
                    Object ret;
                    if (this.isVisible()) {
                        this.focusOptions();
                        this.select(match.index);
                    }
                    if ((ret = this.optionsModel.getElementAt(match.index)) instanceof String) {
                        return (String)ret;
                    }
                }
                return null;
            }
        }
        if (historyMatch.index != -1) {
            if (this.isVisible()) {
                this.focusHistory();
                this.select(historyMatch.index);
            }
            return (String)this.historyModel.getElementAt(historyMatch.index);
        }
        return null;
    }

    public void setListCellRenderer(ListCellRenderer renderer) {
        this.listRenderer.setUserRenderer(renderer);
        this.optionsModel.setStringContent(renderer == null);
        if (this.historyModel.setStringContent(renderer == null)) {
            this.reconfigureGui();
        }
    }

    public ListCellRenderer getListCellRenderer() {
        return this.listRenderer.getUserRenderer();
    }

    public void setPopupFocused(boolean set) {
        if (set != this.listRenderer.isFocusOnList()) {
            this.listRenderer.setFocusOnList(set);
            this.focusedList.repaint();
        }
    }

    public boolean isPopupFocused() {
        return this.isVisible() && this.listRenderer.isFocusOnList();
    }

    public void setBackground(Color color) {
        this.optionsList.setBackground(color);
        this.historyList.setBackground(color);
    }

    public void setForeground(Color color) {
        this.optionsList.setForeground(color);
        this.historyList.setForeground(color);
    }

    public void setDisabledColor(Color color) {
        this.popup.setBorder(BorderFactory.createLineBorder(color, 1));
        this.separator.setForeground(color);
    }

    public void setFont(Font font) {
        this.optionsList.setFont(font);
        this.historyList.setFont(font);
        this.ensureListRowsHeight();
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.historyModel.setIgnoreCase(ignoreCase);
        this.optionsModel.setIgnoreCase(ignoreCase);
    }

    public void setFormat(Format format) {
        this.optionsModel.setFormat(format);
    }

    public String format(Object object) {
        return this.optionsModel.format(object);
    }

    public boolean isValidOption(Object object) {
        return this.optionsModel.isValidOption(object);
    }

    public boolean hasContent() {
        return !this.optionsModel.isEmpty() || !this.historyModel.isEmpty();
    }

    public boolean hasOptions() {
        return !this.optionsModel.isEmpty();
    }

    public void setMaxVisibleRows(int maxVisibleRows) {
        this.maxVisibleRows = Math.max(4, maxVisibleRows);
        this.fixMaxHistory();
        this.reconfigureGui();
    }

    public int getMaxVisibleRows() {
        return this.maxVisibleRows;
    }

    public void setMaxHistory(int size) {
        this.maxHistory = size;
        if (this.fixMaxHistory()) {
            this.reconfigureGui();
        }
    }

    public int getMaxHistory() {
        return this.maxHistory;
    }

    private boolean fixMaxHistory() {
        int now = this.historyModel.getMaxHistory();
        int optionsSize = this.optionsModel.getSize();
        int finalSize = optionsSize == 0 ? this.maxVisibleRows : Math.min(this.maxHistory, this.maxVisibleRows - Math.min(optionsSize, 4));
        return finalSize == now ? false : this.historyModel.setMaxHistory(finalSize);
    }

    public void clear() {
        this.optionsModel.clearContent();
        this.historyModel.clear();
        this.fixMaxHistory();
        this.reconfigureGui();
    }

    public void addHistory(Object st) {
        if (this.historyModel.add(st)) {
            this.reconfigureGui();
        }
    }

    public void addOptions(Collection<?> options) {
        this.optionsModel.addContent(options);
        this.fixMaxHistory();
        this.reconfigureGui();
    }

    public boolean selectFirst(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToHistory() && (forceJump || this.optionsList.getSelectedIndex() == 0);
        if (ret) {
            this.focusHistory();
        }
        return this.select(0) || ret;
    }

    public boolean selectLast(boolean forceJump) {
        boolean ret;
        boolean bl = ret = this.canSwitchToOptions() && (forceJump || this.historyList.getSelectedIndex() == this.historyModel.getSize() - 1);
        if (ret) {
            this.focusOptions();
        }
        return this.select(this.focusedList.getModel().getSize() - 1) || ret;
    }

    public boolean selectUp(boolean jumpRequired) {
        if (jumpRequired || !this.select(this.focusedList.getSelectedIndex() - 1)) {
            if (!this.canSwitchToHistory()) {
                return false;
            }
            this.focusHistory();
            this.select(this.historyModel.getSize() - 1);
        }
        return true;
    }

    public void selectDown(boolean jumpRequired) {
        if ((jumpRequired || !this.select(this.focusedList.getSelectedIndex() + 1)) && this.canSwitchToOptions()) {
            this.focusOptions();
            this.select(this.optionsList.getFirstVisibleIndex());
        }
    }

    public void selectDownPage() {
        if (this.isFocusInHistory()) {
            if (this.canSwitchToOptions()) {
                this.focusOptions();
            }
            this.select(this.focusedList.getLastVisibleIndex());
        } else {
            int last = this.optionsList.getLastVisibleIndex();
            if (last == this.optionsList.getSelectedIndex()) {
                last = Math.min(last + last - this.optionsList.getFirstVisibleIndex(), this.optionsModel.getSize() - 1);
            }
            this.select(last);
        }
    }

    public void selectUpPage() {
        int select = 0;
        if (!this.isFocusInHistory()) {
            int selected = this.optionsList.getSelectedIndex();
            if (this.canSwitchToHistory() && selected == 0) {
                this.focusHistory();
            } else {
                select = this.optionsList.getFirstVisibleIndex();
                if (select == selected) {
                    select = Math.max(0, select + select - this.optionsList.getLastVisibleIndex());
                }
            }
        }
        this.select(select);
    }

    private boolean select(int n) {
        int current = this.focusedList.getSelectedIndex();
        this.setPopupFocused(true);
        if (n >= 0) {
            this.focusedList.setSelectedIndex(n);
            this.focusedList.ensureIndexIsVisible(n);
        }
        return current != this.focusedList.getSelectedIndex();
    }

    private boolean canSwitchToHistory() {
        return this.focusedList == this.optionsList && !this.historyModel.isEmpty();
    }

    private boolean canSwitchToOptions() {
        return this.focusedList == this.historyList && this.optionsScrollPane.isVisible();
    }

    private void focusHistory() {
        this.optionsList.clearSelection();
        this.focusedList = this.historyList;
    }

    private void focusOptions() {
        this.historyList.clearSelection();
        this.focusedList = this.optionsList;
    }

    private boolean isFocusInHistory() {
        return this.focusedList == this.historyList;
    }

    private void configurePaneSize(JScrollPane pane, int width) {
        Dimension size = pane.getPreferredSize();
        size.width = width;
        pane.setPreferredSize(size);
    }

    private void ensureListRowsHeight() {
        String prototype;
        prototype = this.listRenderer != null && this.listRenderer.getUserRenderer() == null ? ("X".equals(prototype = (String)this.optionsList.getPrototypeCellValue()) ? "Z" : "X") : null;
        this.optionsList.setPrototypeCellValue(prototype);
        this.historyList.setPrototypeCellValue(prototype);
    }

    private void createGui() {
        MouseHandler mouseHandler = new MouseHandler();
        this.optionsList = new JList(this.optionsModel);
        this.optionsList.addMouseMotionListener(mouseHandler);
        this.optionsList.addMouseListener(mouseHandler);
        this.optionsScrollPane = this.createScrollPane(this.optionsList);
        this.historyList = new JList(this.historyModel);
        this.historyList.addMouseMotionListener(mouseHandler);
        this.historyList.addMouseListener(mouseHandler);
        this.optionsList.setBorder(null);
        this.optionsList.setFocusable(false);
        this.optionsList.setSelectionMode(0);
        this.historyList.setBorder(null);
        this.historyList.setFocusable(false);
        this.historyList.setSelectionMode(0);
        this.ensureListRowsHeight();
        this.separator = new JSeparator();
        this.popup = new JPopupMenu();
        this.popup.setLayout(new BorderLayout());
        this.popup.setBorderPainted(true);
        this.popup.setOpaque(false);
        this.popup.addPopupMenuListener(this);
        this.historyScrollPane = this.createScrollPane(this.historyList);
        this.popup.add((Component)this.historyScrollPane, "North");
        this.popup.add((Component)this.separator, "Center");
        this.popup.add((Component)this.optionsScrollPane, "South");
        this.popup.setDoubleBuffered(true);
        this.popup.setFocusable(false);
        this.listRenderer = new FilterListCellRenderer(this.optionsList);
        this.optionsList.setCellRenderer(this.listRenderer);
        this.historyList.setCellRenderer(this.listRenderer);
        this.reconfigureGui();
    }

    private void reconfigureGui() {
        int historySize = this.historyModel.getSize();
        boolean showOptions = this.optionsModel.getSize() > 0;
        boolean showHistory = historySize > 0 || !showOptions;
        this.optionsScrollPane.setVisible(showOptions);
        this.historyScrollPane.setVisible(showHistory);
        if (showHistory) {
            this.historyList.setVisibleRowCount(Math.max(1, historySize));
            this.historyScrollPane.setPreferredSize(null);
        }
        if (showOptions) {
            this.optionsList.setVisibleRowCount(Math.min(this.optionsModel.getSize(), this.maxVisibleRows - historySize));
            this.optionsScrollPane.setPreferredSize(null);
        }
        this.separator.setVisible(showHistory && showOptions);
    }

    private JScrollPane createScrollPane(JList list) {
        JScrollPane ret = new JScrollPane(list, 20, 31);
        ret.setHorizontalScrollBar(null);
        ret.setFocusable(false);
        ret.getVerticalScrollBar().setFocusable(false);
        ret.setBorder(null);
        return ret;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.cancelReason = null;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        AWTEvent ev = EventQueue.getCurrentEvent();
        if (ev instanceof MouseEvent) {
            this.cancelReason = ev.getSource();
        }
    }

    public boolean isMenuCanceledForMouseEvent(Object source) {
        boolean ret = !this.popup.isVisible() && this.cancelReason == source;
        this.cancelReason = null;
        return ret;
    }

    static class Match {
        int index;
        int len;
        boolean exact;

        public Match() {
        }

        public Match(int index) {
            this.index = index;
            this.exact = index != -1;
        }
    }

    final class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            this.listSelection(PopupComponent.this.focusedList.getSelectedValue());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            PopupComponent.this.setPopupFocused(true);
            JList focus = (JList)e.getSource();
            JList other = focus == PopupComponent.this.optionsList ? PopupComponent.this.historyList : PopupComponent.this.optionsList;
            focus.setSelectedIndex(focus.locationToIndex(e.getPoint()));
            if (other.getModel().getSize() > 0) {
                other.setSelectedIndex(0);
                other.clearSelection();
            }
            PopupComponent.this.focusedList = focus;
        }

        private void listSelection(Object object) {
            PopupComponent.this.optionSelected(object);
            PopupComponent.this.hide();
        }
    }
}

