/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class FilterListCellRenderer
extends JComponent
implements ListCellRenderer {
    private static final long serialVersionUID = 6736940091246039334L;
    private static final int X_MARGIN_ARROW = 1;
    private static final int WIDTH_ARROW = 5;
    private static final int HEIGHT_ARROW = 6;
    private static final int[] X = new int[]{0, 5, 0};
    private static final int[] Y = new int[]{0, 3, 6};
    private ListCellRenderer userRenderer;
    private ListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private CellRendererPane painter = new CellRendererPane();
    private JList referenceList;
    private Component inner;
    private Color arrowColor;
    private boolean selected;
    private boolean focusOnList;
    private int xDeltaBase;
    private int width;

    public FilterListCellRenderer(JList mainList) {
        this.setUserRenderer(null);
        this.setDoubleBuffered(true);
        this.referenceList = mainList;
    }

    public void setFocusOnList(boolean set) {
        this.focusOnList = set;
    }

    public boolean isFocusOnList() {
        return this.focusOnList;
    }

    public void setUserRenderer(ListCellRenderer renderer) {
        this.userRenderer = renderer == null ? this.defaultRenderer : renderer;
    }

    public ListCellRenderer getUserRenderer() {
        return this.userRenderer == this.defaultRenderer ? null : this.userRenderer;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setupRenderer(list, value, index, this.focusOnList && isSelected, cellHasFocus);
        this.width = this.referenceList.isShowing() ? this.referenceList.getWidth() : list.getWidth();
        this.selected = isSelected;
        this.xDeltaBase = 7;
        return this;
    }

    public Component getCellRendererComponent(Object value, int finalWidth) {
        this.setupRenderer(this.referenceList, value, -1, false, false);
        this.width = finalWidth;
        this.selected = false;
        this.xDeltaBase = 0;
        return this;
    }

    private void setupRenderer(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        try {
            this.inner = this.userRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        catch (Exception ex) {
            this.inner = null;
        }
        if (this.inner == null) {
            this.inner = this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        this.inner.setFont(list.getFont());
        this.inner.setEnabled(this.isEnabled());
        this.arrowColor = list.getSelectionBackground();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int height = this.getHeight();
        int xDelta = this.xDeltaBase;
        int yDelta = 0;
        if (this.selected) {
            Object old = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            yDelta = height / 2 + 1 - 3;
            --xDelta;
            g.translate(1, yDelta);
            g.setColor(this.arrowColor);
            g.fillPolygon(X, Y, X.length);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, old);
        }
        g.translate(xDelta, -yDelta);
        this.painter.paintComponent(g, this.inner, this, 0, 0, this.width - this.xDeltaBase, height);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.inner.getPreferredSize();
    }

    @Override
    public boolean isShowing() {
        return true;
    }
}

