/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.parser;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.Format;
import java.text.ParseException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.parser.DateComparator;

public class FilterTextParser
implements IFilterTextParser {
    Map<Class<?>, Format> formatters = new HashMap();
    Map<Class<?>, Comparator<?>> comparators = new HashMap();
    boolean ignoreCase;
    private IOperand defaultOperand;
    private String defaultOperandString = "~";
    private TableModel model;
    private Pattern expressionMatcher;
    private Map<String, IOperand> operands;
    private PropertyChangeSupport propertiesHandler = new PropertyChangeSupport(this);
    static Comparator<Comparable> comparatorOfComparables = new Comparator<Comparable>(){

        @Override
        public int compare(Comparable o1, Comparable o2) {
            return o1.compareTo(o2);
        }
    };

    public FilterTextParser() {
        this.expressionMatcher = Pattern.compile("^(>=|<=|<>|!=|!~|~~|==|>|<|=|~|!)?\\s*(.*)$");
        this.operands = new HashMap<String, IOperand>();
        this.operands.put("~~", new REOperand(true));
        this.operands.put("~", new SimpleREOperand(true));
        this.operands.put("!~", new SimpleREOperand(false));
        this.operands.put("!", new EqualOperand(false));
        this.operands.put("!=", new EqualOperand(false));
        this.operands.put("=", new EqualOperand(true));
        this.operands.put("==", new EqualOperand(true));
        this.operands.put(">=", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison >= 0;
            }
        });
        this.operands.put(">", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison > 0;
            }
        });
        this.operands.put("<=", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison <= 0;
            }
        });
        this.operands.put("<", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison < 0;
            }
        });
        this.operands.put("<>", new ComparisonOperand(){

            @Override
            boolean matches(int comparison) {
                return comparison != 0;
            }
        });
        this.defaultOperand = this.operands.get(this.defaultOperandString);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertiesHandler.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertiesHandler.removePropertyChangeListener(listener);
    }

    @Override
    public void setTableModel(TableModel model) {
        TableModel oldModel = model;
        this.model = model;
        this.propertiesHandler.firePropertyChange("tableModel", oldModel, model);
    }

    @Override
    public String getDefaultOperator() {
        return this.defaultOperandString;
    }

    @Override
    public void setDefaultOperator(String s) {
        String old = this.defaultOperandString;
        IOperand op = this.operands.get(s);
        if (op != null) {
            this.defaultOperand = op;
            this.propertiesHandler.firePropertyChange("defaultOperand", old, s);
        }
    }

    @Override
    public Format getFormat(Class<?> c) {
        return this.formatters.get(c);
    }

    @Override
    public void setFormat(Class<?> c, Format format) {
        Comparator<?> comparator;
        Format old = this.formatters.put(c, format);
        this.propertiesHandler.firePropertyChange("format", old, format);
        if (Date.class.isAssignableFrom(c) && format != null && ((comparator = this.getComparator(c)) == null || comparator instanceof DateComparator)) {
            this.setComparator(c, DateComparator.getDateComparator(format));
        }
    }

    @Override
    public void setComparator(Class<?> c, Comparator<?> cmp) {
        Comparator<?> old = this.comparators.put(c, cmp);
        this.propertiesHandler.firePropertyChange("comparator", old, cmp);
    }

    @Override
    public Comparator<?> getComparator(Class<?> c) {
        return this.comparators.get(c);
    }

    @Override
    public void setIgnoreCase(boolean ignore) {
        if (ignore != this.ignoreCase) {
            boolean old = this.ignoreCase;
            this.ignoreCase = ignore;
            this.propertiesHandler.firePropertyChange("ignoreCase", old, ignore);
        }
    }

    @Override
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Override
    public RowFilter parseText(String expression, int modelPosition) throws ParseException {
        Class<?> c = this.model.getColumnClass(modelPosition);
        Matcher matcher = this.expressionMatcher.matcher(expression);
        if (matcher.matches()) {
            IOperand op = this.operands.get(matcher.group(1));
            if (op == null) {
                op = this.defaultOperand;
            }
            try {
                return op.create(matcher.group(2).trim(), c, modelPosition);
            }
            catch (ParseException pex) {
                throw new ParseException("", pex.getErrorOffset() + matcher.start(2));
            }
        }
        return null;
    }

    abstract class StringRowFilter
    extends RowFilter {
        int modelPosition;
        Format formatter;

        StringRowFilter(int modelPosition, Format formatter) {
            this.modelPosition = modelPosition;
            this.formatter = formatter;
        }

        public boolean include(RowFilter.Entry entry) {
            Object o = entry.getValue(this.modelPosition);
            String left = o == null ? "" : (this.formatter == null ? o.toString() : this.formatter.format(o));
            return this.include(left);
        }

        abstract boolean include(String var1);
    }

    class SimpleREOperand
    extends REOperand {
        public SimpleREOperand(boolean equals) {
            super(equals);
        }

        @Override
        protected Pattern getPattern(String right) throws ParseException {
            return super.getPattern(this.convertWilcardExpressionToRegularExpression(right));
        }

        private String convertWilcardExpressionToRegularExpression(String s) {
            StringBuilder sb = new StringBuilder();
            boolean escaped = false;
            block6: for (char c : s.toCharArray()) {
                switch (c) {
                    case '\\': {
                        if (escaped) {
                            sb.append("\\");
                        }
                        escaped = !escaped;
                        continue block6;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case ']': 
                    case '^': 
                    case '{': 
                    case '|': 
                    case '}': {
                        sb.append('\\').append(c);
                        escaped = false;
                        continue block6;
                    }
                    case '*': {
                        if (escaped) {
                            sb.append("\\*");
                            escaped = false;
                            continue block6;
                        }
                        sb.append(".*");
                        continue block6;
                    }
                    case '?': {
                        if (escaped) {
                            sb.append("\\?");
                            escaped = false;
                            continue block6;
                        }
                        sb.append(".");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                        escaped = false;
                    }
                }
            }
            return sb.toString();
        }
    }

    class REOperand
    implements IOperand {
        boolean equals;

        public REOperand(boolean equals) {
            this.equals = equals;
        }

        @Override
        public RowFilter create(String right, Class<?> c, int modelPosition) throws ParseException {
            final Pattern pattern = this.getPattern(right);
            Format format = String.class.equals(c) ? null : FilterTextParser.this.formatters.get(c);
            return new StringRowFilter(modelPosition, format){

                @Override
                boolean include(String left) {
                    return REOperand.this.equals == pattern.matcher(left).matches();
                }
            };
        }

        protected Pattern getPattern(String right) throws ParseException {
            try {
                return Pattern.compile(right, FilterTextParser.this.ignoreCase ? 2 : 0);
            }
            catch (PatternSyntaxException pse) {
                throw new ParseException("", pse.getIndex());
            }
        }
    }

    class EqualOperand
    extends ComparisonOperand
    implements Comparator {
        boolean equals;

        public EqualOperand(boolean equals) {
            this.equals = equals;
            this.defaultComparator = this;
        }

        @Override
        public boolean matches(int comparison) {
            return this.equals == (comparison == 0);
        }

        public int compare(Object o1, Object o2) {
            return o1.equals(o2) ? 0 : 1;
        }
    }

    abstract class ComparisonOperand
    implements IOperand {
        protected Comparator defaultComparator;

        ComparisonOperand() {
        }

        abstract boolean matches(int var1);

        @Override
        public RowFilter create(String right, Class<?> c, int modelPosition) throws ParseException {
            Object o;
            if (String.class.equals(c)) {
                return this.createStringOperator(right, null, modelPosition);
            }
            Format format = FilterTextParser.this.formatters.get(c);
            if (format == null) {
                return this.createStringOperator(right, null, modelPosition);
            }
            Comparator<?> comparator = FilterTextParser.this.comparators.get(c);
            if (comparator == null) {
                if (Comparable.class.isAssignableFrom(c)) {
                    comparator = comparatorOfComparables;
                } else {
                    if (this.defaultComparator == null) {
                        return this.createStringOperator(right, format, modelPosition);
                    }
                    comparator = this.defaultComparator;
                }
            }
            if ((o = format.parseObject(right)) == null) {
                throw new ParseException("", 0);
            }
            return this.createOperator(o, comparator, modelPosition);
        }

        protected RowFilter createOperator(final Object right, final Comparator comparator, final int modelPosition) {
            return new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object left = entry.getValue(modelPosition);
                    return left != null && ComparisonOperand.this.matches(comparator.compare(left, right));
                }
            };
        }

        protected RowFilter createStringOperator(final String right, Format formatter, int modelPosition) {
            return new StringRowFilter(modelPosition, formatter){

                @Override
                public boolean include(String left) {
                    return ComparisonOperand.this.matches(FilterTextParser.this.ignoreCase ? left.compareToIgnoreCase(right) : left.compareTo(right));
                }
            };
        }
    }

    static interface IOperand {
        public RowFilter create(String var1, Class<?> var2, int var3) throws ParseException;
    }
}

