/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.editor.PopupComponent;

class OptionsListModel
extends AbstractListModel {
    private static final long serialVersionUID = 3523952153693100563L;
    private List content;
    private List stringContent;
    private Format formatter = defaultFormatter;
    private boolean ignoreCase;
    private static Format defaultFormatter = new Format(){
        private static final long serialVersionUID = 3313449946741441248L;

        @Override
        public Object parseObject(String source) throws ParseException {
            return source.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(obj.toString());
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return source;
        }
    };

    public OptionsListModel() {
        this.content = new ArrayList();
        this.stringContent = this.content;
    }

    public void setIgnoreCase(boolean set) {
        this.ignoreCase = set;
    }

    @Override
    public int getSize() {
        return this.stringContent == null ? this.content.size() : this.stringContent.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.stringContent == null ? this.content.get(index) : this.stringContent.get(index);
    }

    public void setStringContent(boolean set) {
        if (!set) {
            if (this.stringContent != null) {
                this.stringContent = null;
                this.fireContentsChanged(this, 0, this.getSize());
            }
        } else if (this.stringContent == null) {
            List oldContent = this.content;
            this.content = new ArrayList();
            this.stringContent = this.content;
            this.addContent(oldContent);
        }
    }

    public void setFormat(Format format) {
        Format format2 = this.formatter = format == null ? defaultFormatter : format;
        if (this.stringContent != null) {
            List oldContent = this.content;
            List oldStringContent = this.stringContent;
            this.content = new ArrayList();
            this.stringContent = oldContent == oldStringContent ? this.content : new ArrayList();
            this.addContent(oldContent);
        }
    }

    public boolean isValidOption(Object o) {
        return this.content.contains(o) || this.stringContent != null && this.stringContent != this.content && o instanceof String && this.stringContent.contains(o);
    }

    public String format(Object o) {
        return o instanceof String ? (String)o : this.formatter.format(o);
    }

    public PopupComponent.Match getClosestMatch(Object hint, boolean exact) {
        if (this.stringContent == null) {
            return new PopupComponent.Match(this.content.indexOf(hint));
        }
        return hint instanceof String ? this.findOnSortedContent((String)hint, exact) : null;
    }

    public void clearContent() {
        int size = this.getSize();
        if (size > 0) {
            this.content.clear();
            if (this.stringContent != null) {
                this.stringContent = this.content;
            }
            this.fireIntervalRemoved(this, 0, size);
        }
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public void addContent(Collection addedContent) {
        if (!addedContent.isEmpty()) {
            if (this.isEmpty()) {
                this.content.add("");
            }
            if (this.stringContent != null) {
                if (this.stringContent == this.content) {
                    for (Object o : addedContent) {
                        if (o instanceof String) continue;
                        this.stringContent = new ArrayList(this.content);
                        break;
                    }
                }
                for (Object o : addedContent) {
                    this.addStringContent(this.formatter.format(o));
                }
            }
            if (this.stringContent != this.content) {
                for (Object o : addedContent) {
                    if (this.content.contains(o)) continue;
                    this.content.add(o);
                }
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private void addStringContent(String s) {
        int position = 0;
        for (Object o : this.stringContent) {
            int compare = ((String)o).compareTo(s);
            if (compare == 0) {
                return;
            }
            if (compare > 0) {
                this.stringContent.add(position, s);
                return;
            }
            ++position;
        }
        this.stringContent.add(s);
    }

    private PopupComponent.Match findOnSortedContent(String strStart, boolean fullMatch) {
        PopupComponent.Match ret = new PopupComponent.Match();
        if (this.stringContent.isEmpty()) {
            ret.index = -1;
        } else {
            ret.len = strStart.length();
            ret.exact = ret.len == 0;
            int originalLen = ret.len;
            while (ret.len > 0) {
                for (Object o : this.stringContent) {
                    String os = (String)o;
                    int osLength = os.length();
                    if (osLength >= ret.len) {
                        int cmp;
                        String cmpStr = os.substring(0, ret.len);
                        int n = cmp = this.ignoreCase ? cmpStr.compareToIgnoreCase(strStart) : cmpStr.compareTo(strStart);
                        if (cmp == 0) {
                            ret.exact = osLength == originalLen;
                            return ret;
                        }
                        if (cmp > 0) break;
                    }
                    ++ret.index;
                }
                if (fullMatch) {
                    ret.index = -1;
                    break;
                }
                ret.index = 0;
                strStart = strStart.substring(0, --ret.len);
            }
        }
        return ret;
    }
}

