/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.coderazzi.filters.IFilterTextParser;
import net.coderazzi.filters.gui.editor.FilterListCellRenderer;
import net.coderazzi.filters.gui.editor.PopupComponent;

interface EditorComponent {
    public static final String EMPTY_FILTER = "";

    public JComponent getComponent();

    public boolean checkFilterUpdate(boolean var1);

    public RowFilter getFilter();

    public boolean focusGained(boolean var1);

    public void setEnabled(boolean var1);

    public void setTextParser(IFilterTextParser var1);

    public IFilterTextParser getTextParser();

    public void setContent(Object var1);

    public Object getContent();

    public void setPosition(int var1);

    public int getPosition();

    public void setEditable(boolean var1);

    public boolean isEditable();

    public void setErrorForeground(Color var1);

    public Color getErrorForeground();

    public void setDisabledForeground(Color var1);

    public Color getDisabledForeground();

    public void setForeground(Color var1);

    public Color getForeground();

    public static final class Rendered
    extends JComponent
    implements EditorComponent {
        private static final long serialVersionUID = -7162028817569553287L;
        private Object content = "";
        private FilterListCellRenderer renderer;
        private CellRendererPane painter = new CellRendererPane();
        private IFilterTextParser parser;
        private RowFilter filter;
        private Color errorColor;
        private Color disabledColor;
        Object cachedContent;
        int filterPosition;

        public Rendered(FilterListCellRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public boolean checkFilterUpdate(boolean forceUpdate) {
            Object currentContent = this.getContent();
            if (!forceUpdate && currentContent == this.cachedContent) {
                return false;
            }
            this.cachedContent = currentContent;
            RowFilter old = this.filter;
            this.filter = EditorComponent.EMPTY_FILTER.equals(this.cachedContent) ? null : new RowFilter(){

                public boolean include(RowFilter.Entry entry) {
                    Object val = entry.getValue(Rendered.this.filterPosition);
                    return val == null ? Rendered.this.cachedContent == null : val.equals(Rendered.this.cachedContent);
                }
            };
            return old != this.filter;
        }

        @Override
        public RowFilter getFilter() {
            return this.filter;
        }

        @Override
        public boolean focusGained(boolean gained) {
            return true;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.renderer.setEnabled(enabled);
        }

        @Override
        public void setTextParser(IFilterTextParser parser) {
            this.parser = parser;
            this.cachedContent = null;
        }

        @Override
        public IFilterTextParser getTextParser() {
            return this.parser;
        }

        @Override
        public void setContent(Object content) {
            this.content = content == null ? EditorComponent.EMPTY_FILTER : content;
            this.repaint();
        }

        @Override
        public Object getContent() {
            return this.content;
        }

        @Override
        public void setPosition(int position) {
            this.filterPosition = position;
        }

        @Override
        public int getPosition() {
            return this.filterPosition;
        }

        @Override
        public void setEditable(boolean set) {
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void setErrorForeground(Color fg) {
            this.errorColor = fg;
        }

        @Override
        public Color getErrorForeground() {
            return this.errorColor;
        }

        @Override
        public void setDisabledForeground(Color fg) {
            this.disabledColor = fg;
        }

        @Override
        public Color getDisabledForeground() {
            return this.disabledColor;
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Component c = this.renderer.getCellRendererComponent(this.content, this.getWidth());
            this.painter.paintComponent(g, c, this, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    public static final class Text
    extends DocumentFilter
    implements DocumentListener,
    EditorComponent {
        private JTextField textField = new JTextField(15);
        private IFilterTextParser parser;
        private RowFilter cachedFilter;
        private String cachedContent;
        private int filterPosition;
        private boolean editable;
        private boolean enabled;
        private boolean controlledSet;
        private Color errorColor = Color.red;
        private Color foreground;
        private Color disabledColor;
        PopupComponent popup;

        public Text(PopupComponent popupComponent) {
            this.popup = popupComponent;
            this.setEditable(true);
            this.textField.addCaretListener(new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent e) {
                    Text.this.popup.setPopupFocused(false);
                }
            });
        }

        @Override
        public JComponent getComponent() {
            return this.textField;
        }

        @Override
        public boolean checkFilterUpdate(boolean forceUpdate) {
            String content = this.textField.getText().trim();
            if (!forceUpdate && content.equals(this.cachedContent)) {
                return false;
            }
            RowFilter old = this.cachedFilter;
            this.cachedContent = content;
            this.cachedFilter = this.parseText(content);
            return this.cachedFilter != old;
        }

        @Override
        public RowFilter getFilter() {
            return this.cachedFilter;
        }

        @Override
        public boolean focusGained(boolean gained) {
            this.textField.setCaretPosition(0);
            if (gained) {
                this.textField.moveCaretPosition(this.textField.getText().length());
            }
            return !this.editable;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.textField.setFocusable(enabled);
            this.ensureCorrectForegroundColor();
        }

        @Override
        public void setTextParser(IFilterTextParser parser) {
            this.parser = parser;
            if (this.textField.isEnabled()) {
                this.checkFilterUpdate(true);
            }
        }

        @Override
        public IFilterTextParser getTextParser() {
            return this.parser;
        }

        @Override
        public void setContent(Object content) {
            this.setControlledSet();
            this.textField.setText((String)content);
        }

        @Override
        public void setPosition(int position) {
            this.filterPosition = position;
        }

        @Override
        public int getPosition() {
            return this.filterPosition;
        }

        @Override
        public Object getContent() {
            return this.textField.getText();
        }

        @Override
        public void setEditable(boolean set) {
            if (this.isEditable()) {
                this.textField.getDocument().removeDocumentListener(this);
            } else {
                ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(null);
            }
            this.editable = set;
            if (set) {
                this.textField.getDocument().addDocumentListener(this);
            } else {
                String proposal = this.getProposalOnEdition(this.textField.getText(), false);
                this.textField.setText(proposal == null ? EditorComponent.EMPTY_FILTER : proposal);
                ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(this);
            }
            this.controlledSet = false;
        }

        @Override
        public boolean isEditable() {
            return this.editable;
        }

        @Override
        public void setErrorForeground(Color fg) {
            this.errorColor = fg;
            this.ensureCorrectForegroundColor();
        }

        @Override
        public Color getErrorForeground() {
            return this.errorColor;
        }

        @Override
        public void setDisabledForeground(Color fg) {
            this.disabledColor = fg;
            this.ensureCorrectForegroundColor();
        }

        @Override
        public Color getDisabledForeground() {
            return this.disabledColor;
        }

        @Override
        public void setForeground(Color fg) {
            this.foreground = fg;
            this.ensureCorrectForegroundColor();
        }

        @Override
        public Color getForeground() {
            return this.foreground;
        }

        private void ensureCorrectForegroundColor() {
            if (this.enabled) {
                this.parseText(this.textField.getText());
            } else {
                this.textField.setForeground(this.disabledColor);
            }
        }

        private RowFilter parseText(String content) {
            RowFilter ret;
            Color color = this.getForeground();
            if (content.length() == 0) {
                ret = null;
            } else {
                try {
                    ret = this.parser.parseText(this.cachedContent, this.filterPosition);
                }
                catch (ParseException pex) {
                    ret = null;
                    color = this.getErrorForeground();
                }
            }
            this.textField.setForeground(color);
            return ret;
        }

        public void setControlledSet() {
            this.controlledSet = true;
        }

        private String getProposalOnEdition(String hint, boolean perfectMatch) {
            String ret = this.popup.selectBestMatch(hint, perfectMatch);
            this.popup.setPopupFocused(false);
            return ret;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            int caret;
            String buffer = this.textField.getText();
            String newContentBegin = buffer.substring(0, offset) + text;
            String newContent = newContentBegin + buffer.substring(offset + length);
            String proposal = this.getProposalOnEdition(newContent, true);
            if (proposal == null) {
                proposal = this.getProposalOnEdition(newContentBegin, true);
                if (proposal == null) {
                    return;
                }
                newContent = newContentBegin;
            }
            if (this.controlledSet) {
                this.controlledSet = false;
                caret = 0;
            } else {
                caret = 1 + Math.min(this.textField.getCaret().getDot(), this.textField.getCaret().getMark());
            }
            super.replace(fb, 0, buffer.length(), proposal, attrs);
            this.textField.setCaretPosition(proposal.length());
            this.textField.moveCaretPosition(caret);
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            String proposal;
            int caret = this.textField.getCaret().getDot();
            int mark = this.textField.getCaret().getMark();
            String buffer = this.textField.getText();
            String newContent = buffer.substring(0, offset) + buffer.substring(offset + length);
            if (!newContent.equals(proposal = this.getProposalOnEdition(newContent, true))) {
                if (proposal == null && (proposal = this.getProposalOnEdition(newContent, false)) == null) {
                    return;
                }
                if (this.matchCount(proposal, newContent) <= this.matchCount(buffer, newContent)) {
                    proposal = buffer;
                }
            }
            super.replace(fb, 0, buffer.length(), proposal, null);
            AWTEvent ev = EventQueue.getCurrentEvent();
            if (ev instanceof KeyEvent && ((KeyEvent)ev).getKeyCode() == 8) {
                if (caret > mark) {
                    caret = mark;
                } else if (buffer == proposal) {
                    --caret;
                } else if (caret == mark) {
                    caret = offset;
                }
            }
            this.textField.setCaretPosition(proposal.length());
            this.textField.moveCaretPosition(caret);
        }

        private int matchCount(String a, String b) {
            int max = Math.min(a.length(), b.length());
            for (int i = 0; i < max; ++i) {
                if (a.charAt(i) == b.charAt(i)) continue;
                return i;
            }
            return max;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.getProposalOnEdition(this.textField.getText(), false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.getProposalOnEdition(this.textField.getText(), false);
        }
    }
}

