/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultRowSorter;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import net.coderazzi.filters.AndFilter;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;

public class TableFilter
extends AndFilter {
    int sendNotifications = 0;
    private boolean pendingNotifications;
    private AutoSelector autoSelector = new AutoSelector();
    JTable table;

    public TableFilter() {
        super(new IFilter[0]);
        this.addFilterObserver(new IFilterObserver(){

            @Override
            public void filterUpdated(IFilter obs) {
                TableFilter.this.notifyUpdatedFilter(false);
            }
        });
    }

    public TableFilter(JTable table) {
        this();
        this.setTable(table);
    }

    public void setTable(JTable table) {
        JTable oldTable = this.table;
        this.table = table;
        this.autoSelector.replacedTable(oldTable, table);
    }

    public JTable getTable() {
        return this.table;
    }

    public boolean enableNotifications(boolean enable) {
        this.sendNotifications += enable ? 1 : -1;
        if (enable && this.sendNotifications == 0 && this.pendingNotifications) {
            this.notifyUpdatedFilter(false);
        }
        return this.sendNotifications >= 0;
    }

    public void sendPendingNotifications() {
        if (this.pendingNotifications) {
            this.notifyUpdatedFilter(true);
        }
    }

    public void setAutoSelection(boolean enable) {
        this.autoSelector.setAutoSelection(enable);
    }

    public boolean isAutoSelection() {
        return this.autoSelector.autoSelection;
    }

    void notifyUpdatedFilter(boolean forced) {
        if (forced || this.sendNotifications < 0) {
            this.pendingNotifications = true;
            return;
        }
        this.pendingNotifications = this.sendFilterUpdateNotification();
    }

    private boolean sendFilterUpdateNotification() {
        if (this.autoSelector.sorter == null) {
            return true;
        }
        this.autoSelector.sorter.setRowFilter(this);
        return false;
    }

    class AutoSelector
    implements RowSorterListener,
    Runnable,
    PropertyChangeListener {
        DefaultRowSorter<?, ?> sorter;
        boolean autoSelection = true;

        AutoSelector() {
        }

        public void replacedTable(JTable oldTable, JTable newTable) {
            if (oldTable != null) {
                oldTable.removePropertyChangeListener("rowSorter", this);
            }
            if (newTable == null) {
                this.setSorter(null);
            } else {
                newTable.addPropertyChangeListener("rowSorter", this);
                this.setSorter((DefaultRowSorter)newTable.getRowSorter());
                if (this.sorter == null) {
                    newTable.setAutoCreateRowSorter(true);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setSorter((DefaultRowSorter)evt.getNewValue());
        }

        private void setSorter(DefaultRowSorter<?, ?> sorter) {
            if (this.sorter != null) {
                this.sorter.removeRowSorterListener(this);
                this.sorter.setRowFilter(null);
            }
            this.sorter = sorter;
            if (sorter != null) {
                if (TableFilter.this.sendNotifications >= 0) {
                    sorter.setRowFilter(TableFilter.this);
                }
                if (this.autoSelection) {
                    sorter.addRowSorterListener(this);
                }
            }
        }

        public void setAutoSelection(boolean enable) {
            if (this.autoSelection != enable && this.sorter != null) {
                if (enable) {
                    this.sorter.addRowSorterListener(this);
                } else {
                    this.sorter.removeRowSorterListener(this);
                }
            }
            this.autoSelection = enable;
        }

        @Override
        public void run() {
            if (this.sorter != null && this.sorter.getViewRowCount() == 1) {
                TableFilter.this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            if (e.getType() == RowSorterEvent.Type.SORTED && ((RowSorter)e.getSource()).getViewRowCount() == 1) {
                SwingUtilities.invokeLater(this);
            }
        }
    }
}

