/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.text.Format;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.artifacts.RowFilter;
import net.coderazzi.filters.gui.FiltersHandler;
import net.coderazzi.filters.gui.editor.FilterEditor;

abstract class ChoicesHandler
implements TableModelListener {
    private TableModel listenedModel;
    protected FiltersHandler handler;

    protected ChoicesHandler(FiltersHandler handler) {
        this.handler = handler;
    }

    public abstract RowFilter getRowFilter();

    public abstract boolean setInterrupted(boolean var1);

    public abstract void editorUpdated(FilterEditor var1);

    public abstract boolean filterUpdated(IFilter var1, boolean var2);

    public abstract void filterOperation(boolean var1);

    public abstract void filterEnabled(IFilter var1);

    public abstract void allFiltersDisabled();

    protected abstract void tableUpdated(TableModel var1, int var2, int var3, int var4, int var5);

    public void tableChanged(TableModelEvent e) {
        int firstRow = e.getFirstRow();
        if (firstRow != -1) {
            TableModel model = (TableModel)e.getSource();
            int lastRow = Math.min(model.getRowCount() - 1, e.getLastRow());
            this.tableUpdated(model, e.getType(), firstRow, lastRow, e.getColumn());
        }
    }

    protected void setEnableTableModelEvents(boolean set) {
        if (set) {
            JTable table = this.handler.getTable();
            if (table != null) {
                if (this.listenedModel != null) {
                    if (this.listenedModel == table.getModel()) {
                        return;
                    }
                    this.setEnableTableModelEvents(false);
                }
                this.listenedModel = table.getModel();
                this.listenedModel.addTableModelListener(this);
            }
        } else if (this.listenedModel != null) {
            this.listenedModel.removeTableModelListener(this);
            this.listenedModel = null;
        }
    }

    protected static class RowEntry
    extends RowFilter.Entry {
        private TableModel model;
        private int count;
        private Format[] formatters;
        public int row;

        public RowEntry(TableModel model, FilterEditor[] editors) {
            this.model = model;
            this.count = model.getColumnCount();
            int len = editors.length;
            this.formatters = new Format[len];
            while (len-- > 0) {
                this.formatters[len] = editors[len].getFormat();
            }
        }

        public int getModelRowCount() {
            return this.model.getRowCount();
        }

        public Format[] getFormatters() {
            return this.formatters;
        }

        public Object getIdentifier() {
            return this.row;
        }

        public TableModel getModel() {
            return this.model;
        }

        public Object getValue(int index) {
            return this.model.getValueAt(this.row, index);
        }

        public int getValueCount() {
            return this.count;
        }

        public String getStringValue(int index) {
            return this.formatters[index].format(this.getValue(index));
        }
    }
}

