/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui.editor;

import java.text.Collator;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import net.coderazzi.filters.gui.CustomChoice;
import net.coderazzi.filters.gui.editor.PopupComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoicesListModel
extends AbstractListModel {
    private static final long serialVersionUID = 3523952153693100563L;
    private List content;
    private Format format;
    private int customChoices;
    boolean useFormatter;
    Comparator comparator;
    private Comparator wrapperComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof CustomChoice) {
                if (o2 instanceof CustomChoice) {
                    CustomChoice c1 = (CustomChoice)o1;
                    CustomChoice c2 = (CustomChoice)o2;
                    int ret = c1.getPrecedence() - c2.getPrecedence();
                    if (ret == 0) {
                        ret = ChoicesListModel.this.useFormatter ? ChoicesListModel.this.comparator.compare(c1.toString(), c2.toString()) : o1.hashCode() - o2.hashCode();
                    }
                    return ret;
                }
                return -1;
            }
            if (o2 instanceof CustomChoice) {
                return 1;
            }
            return ChoicesListModel.this.comparator.compare(o1, o2);
        }
    };

    public ChoicesListModel() {
        this.content = new ArrayList();
        this.setStringContent(null, Collator.getInstance());
    }

    @Override
    public int getSize() {
        return this.content.size();
    }

    @Override
    public Object getElementAt(int i) {
        return this.content.get(i);
    }

    public void clearContent() {
        int size = this.getSize();
        if (size > 0) {
            this.customChoices = 0;
            this.content.clear();
            this.fireIntervalRemoved(this, 0, size);
        }
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public boolean isValidChoice(Object o) {
        return this.content.contains(o);
    }

    public Collection<?> getChoices() {
        return this.content;
    }

    public CustomChoice getCustomChoice(String s) {
        for (int i = 0; i < this.customChoices; ++i) {
            CustomChoice cc = (CustomChoice)this.content.get(i);
            if (0 != this.comparator.compare(s, cc.toString())) continue;
            return cc;
        }
        return null;
    }

    public PopupComponent.Match getClosestMatch(Object hint, boolean exact) {
        return this.useFormatter && hint instanceof String ? this.findOnSortedContent((String)hint, exact) : new PopupComponent.Match(this.content.indexOf(hint));
    }

    public boolean setStringContent(Format format, Comparator stringComparator) {
        boolean ret;
        boolean bl = ret = !this.useFormatter || format != this.format || this.comparator != stringComparator;
        if (ret) {
            this.useFormatter = true;
            this.format = format;
            this.comparator = stringComparator;
            this.clearContent();
        }
        return ret;
    }

    public boolean setRenderedContent(Comparator classComparator) {
        boolean ret;
        boolean bl = ret = this.useFormatter || this.comparator != classComparator;
        if (ret) {
            this.useFormatter = false;
            this.format = null;
            this.comparator = classComparator;
            this.clearContent();
        }
        return ret;
    }

    public boolean addContent(Collection addedContent) {
        boolean changed = false;
        for (Object o : addedContent) {
            if (!(o instanceof CustomChoice)) {
                if (o == null) {
                    o = CustomChoice.MATCH_EMPTY;
                } else if (this.useFormatter) {
                    String s = this.format == null ? o.toString() : this.format.format(o);
                    o = s.length() == 0 ? CustomChoice.MATCH_EMPTY : s;
                }
            }
            changed = this.addContent(o) || changed;
        }
        if (changed) {
            this.addContent(CustomChoice.MATCH_ALL);
            this.fireContentsChanged(this, 0, this.getSize());
        }
        return changed;
    }

    private boolean addContent(Object o) {
        int pos = Collections.binarySearch(this.content, o, this.wrapperComparator);
        if (pos < 0) {
            this.content.add(-1 - pos, o);
            if (o instanceof CustomChoice) {
                ++this.customChoices;
            }
            return true;
        }
        return false;
    }

    private PopupComponent.Match findOnSortedContent(String strStart, boolean fullMatch) {
        PopupComponent.Match ret;
        if (this.content.isEmpty()) {
            ret = new PopupComponent.Match(-1);
        } else {
            ret = PopupComponent.Match.findOnUnsortedContent(this.content, this.customChoices, this.comparator, strStart, fullMatch);
            if (!ret.exact) {
                int pos = Collections.binarySearch(this.content.subList(this.customChoices, this.content.size()), strStart, this.comparator);
                if (pos >= 0) {
                    ret.exact = true;
                    ret.index = this.customChoices + pos;
                } else if (!fullMatch) {
                    int len;
                    int suggested = this.customChoices - pos - 1;
                    if (suggested < this.content.size() && ((len = this.getMatchingLength(strStart, suggested)) > ret.len || ret.len == 0)) {
                        ret.index = suggested;
                        ret.len = len;
                    }
                    if (--suggested >= this.customChoices && ((len = this.getMatchingLength(strStart, suggested)) > ret.len || ret.len == 0)) {
                        ret.index = suggested;
                        ret.len = len;
                    }
                    if (ret.index >= this.customChoices) {
                        ret.exact = ret.len == this.content.get(ret.index).toString().length();
                    }
                }
            }
        }
        return ret;
    }

    private int getMatchingLength(String target, int contentPosition) {
        return PopupComponent.Match.getMatchingLength(target, this.content.get(contentPosition).toString(), this.comparator);
    }
}

