/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters.gui;

import java.awt.Color;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import net.coderazzi.filters.IParser;
import net.coderazzi.filters.gui.AutoChoices;
import net.coderazzi.filters.gui.CustomChoiceDecorator;
import net.coderazzi.filters.gui.IParserModel;
import net.coderazzi.filters.gui.ParserModel;
import net.coderazzi.filters.gui.TableFilterHeader;

public class FilterSettings {
    public static final String PROPERTIES_PREFIX = "net.coderazzi.filters.";
    public static boolean autoSelection = Boolean.parseBoolean(FilterSettings.getString("AutoSelection", "true"));
    public static AutoChoices autoChoices;
    public static boolean adaptiveChoices;
    public static boolean ignoreCase;
    public static TableFilterHeader.Position headerPosition;
    public static String dateFormat;
    public static int maxVisiblePopupRows;
    public static int maxPopupHistory;
    public static Icon matchEmptyFilterIcon;
    public static String matchEmptyFilterString;
    public static Color backgroundColor;
    public static Color foregroundColor;
    public static Color errorColor;
    public static Color gridColor;
    public static Color disabledColor;
    public static Color disabledBackgroundColor;
    public static Color selectionBackgroundColor;
    public static Color selectionForegroundColor;
    public static Color selectionColor;
    public static Font font;
    public static Class<? extends IParserModel> parserModelClass;
    public static Class<? extends CustomChoiceDecorator> customChoiceDecoratorClass;

    public static IParserModel newParserModel() {
        try {
            return parserModelClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating parser model of type " + parserModelClass, ex);
        }
    }

    public static CustomChoiceDecorator newCustomChoiceDecorator() {
        try {
            return customChoiceDecoratorClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error creating decorator of type " + customChoiceDecoratorClass, ex);
        }
    }

    private static String getString(String name, String defaultValue) {
        String ret = FilterSettings.getString(name);
        return ret == null ? defaultValue : ret;
    }

    private static String getString(String name) {
        try {
            return System.getProperty(PROPERTIES_PREFIX + name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static int getInteger(String name, int defaultValue) {
        String ret = FilterSettings.getString(name);
        if (ret != null) {
            try {
                return Integer.valueOf(ret);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static Color getColor(String name, Color defaultValue) {
        String prop = FilterSettings.getString(name);
        if (prop != null) {
            try {
                return Color.decode(prop);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    static {
        adaptiveChoices = Boolean.parseBoolean(FilterSettings.getString("AdaptiveChoices", "true"));
        ignoreCase = Boolean.parseBoolean(FilterSettings.getString("IgnoreCase", "true"));
        headerPosition = TableFilterHeader.Position.valueOf(FilterSettings.getString("Header.Position", "INLINE"));
        dateFormat = FilterSettings.getString("DateFormat", null);
        maxVisiblePopupRows = FilterSettings.getInteger("Popup.maxVisibleRows", 8);
        maxPopupHistory = FilterSettings.getInteger("Popup.maxHistory", 2);
        matchEmptyFilterIcon = new ImageIcon(IParser.class.getResource("resources/matchEmptyIcon.png"));
        matchEmptyFilterString = "=";
        backgroundColor = FilterSettings.getColor("backgroundColor", null);
        foregroundColor = FilterSettings.getColor("foregroundColor", null);
        errorColor = FilterSettings.getColor("errorColor", Color.red);
        gridColor = FilterSettings.getColor("gridColor", null);
        disabledColor = FilterSettings.getColor("disabledColor", null);
        disabledBackgroundColor = FilterSettings.getColor("disabledBackgroundColor", null);
        selectionBackgroundColor = FilterSettings.getColor("selectionBackgroundColor", null);
        selectionForegroundColor = FilterSettings.getColor("selectionForegroundColor", null);
        selectionColor = FilterSettings.getColor("selectionColor", null);
        try {
            font = Font.decode(FilterSettings.getString("font"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            autoChoices = AutoChoices.valueOf(FilterSettings.getString("AutoChoices", "ENUMS"));
        }
        catch (Exception ex) {
            autoChoices = AutoChoices.ENUMS;
        }
        parserModelClass = ParserModel.class;
        String cl = FilterSettings.getString("ParserModel.class", null);
        if (cl != null) {
            try {
                parserModelClass = Class.forName(cl);
            }
            catch (ClassNotFoundException cne) {
                throw new RuntimeException("Error finding filter model of class " + cl, cne);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("Filter model of class " + cl + " is not a valid IParserModel class");
            }
        }
        customChoiceDecoratorClass = CustomChoiceDecorator.DefaultDecorator.class;
        cl = FilterSettings.getString("CustomChoiceDecorator.class", null);
        if (cl != null) {
            try {
                customChoiceDecoratorClass = Class.forName(cl);
            }
            catch (ClassNotFoundException cne) {
                throw new RuntimeException("Error finding choice decorator of class " + cl, cne);
            }
            catch (ClassCastException cce) {
                throw new RuntimeException("CustomChoiceDecorator model of class " + cl + " is not a valid CustomChoiceDecorator class");
            }
        }
    }
}

