/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.coderazzi.filters.IFilter;
import net.coderazzi.filters.IFilterObserver;
import net.coderazzi.filters.artifacts.RowFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Filter
extends RowFilter
implements IFilter {
    private Set<IFilterObserver> filterObservers = new HashSet<IFilterObserver>();
    private boolean enabled = true;

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enable) {
        if (enable != this.enabled) {
            this.enabled = enable;
            this.reportFilterUpdatedToObservers();
        }
    }

    @Override
    public void addFilterObserver(IFilterObserver observer) {
        this.filterObservers.add(observer);
    }

    @Override
    public void removeFilterObserver(IFilterObserver observer) {
        this.filterObservers.remove(observer);
    }

    public Set<IFilterObserver> getFilterObservers() {
        return new HashSet<IFilterObserver>(this.filterObservers);
    }

    protected void reportFilterUpdatedToObservers() {
        for (IFilterObserver obs : new ArrayList<IFilterObserver>(this.filterObservers)) {
            obs.filterUpdated(this);
        }
    }
}

