/*
 * Decompiled with CFR 0.152.
 */
package net.coderazzi.openapi4aws.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.coderazzi.openapi4aws.Configuration;
import net.coderazzi.openapi4aws.O4A_Exception;
import net.coderazzi.openapi4aws.Openapi4AWS;
import net.coderazzi.openapi4aws.cli.Argument;
import net.coderazzi.openapi4aws.cli.AuthorizerParameter;
import net.coderazzi.openapi4aws.cli.CliException;
import net.coderazzi.openapi4aws.cli.IntegrationParameter;

public class CliParser
extends Configuration {
    public static final String CONFIGURATION = "configuration";
    public static final String AUTHORIZER = "authorizer.";
    public static final String AUTHORIZER_DEFINITION = "name";
    private static final Map<String, ArgumentConsumer> argumentHandlers = new HashMap<String, ArgumentConsumer>();
    private static final Map<String, AuthorizerConsumer> authorizerConsumers = new HashMap<String, AuthorizerConsumer>();
    private static final Map<String, Getter<AuthorizerParameter>> authorizerCheckers = new HashMap<String, Getter<AuthorizerParameter>>();
    private static final String AUTHORIZER_IDENTITY_SOURCE = "identity-source";
    private static final String AUTHORIZER_ISSUER = "issuer";
    private static final String AUTHORIZER_AUDIENCES = "audience";
    private static final String AUTHORIZER_AUTHORIZATION_TYPE = "authorization-type";
    private static final String AUTHORIZER_TYPE = "authorizer-type";
    private static final String TAG = "tag.";
    private static final String PATH = "path.";
    private static final String FILENAME = "filename";
    private static final String GLOB = "glob";
    private static final String OUTPUT = "output-folder";
    private final Map<String, AuthorizerParameter> authorizers = new LinkedHashMap<String, AuthorizerParameter>();
    private final Map<String, IntegrationParameter> tags = new HashMap<String, IntegrationParameter>();
    private final Map<String, IntegrationParameter> paths = new HashMap<String, IntegrationParameter>();
    private final Set<String> filenames = new HashSet<String>();
    private final Set<String> globs = new HashSet<String>();
    private final Pattern argPattern = Pattern.compile(String.format("^(--)?(%s)([^=]*)=(.+)$", String.join((CharSequence)"|", argumentHandlers.keySet())));
    private Path outputFolder;

    public CliParser(String filename) {
        this(CliParser.readFile(filename));
    }

    CliParser(String[] args) {
        this.handleArguments(args, false);
        this.authorizers.forEach((name, instance) -> {
            if (!name.isEmpty()) {
                authorizerCheckers.forEach((prop, checker) -> {
                    if (null == checker.get(instance)) {
                        String missing = AUTHORIZER + prop;
                        throw new CliException("Missing " + missing + " or " + missing + "." + name);
                    }
                });
            }
        });
    }

    private static List<String> convertToNonEmptyList(String arg) {
        String[] split = arg.split(",");
        ArrayList<String> ret = new ArrayList<String>(split.length);
        for (String each : split) {
            String trimmed = each.trim();
            if (trimmed.isEmpty()) continue;
            ret.add(trimmed);
        }
        if (ret.isEmpty()) {
            throw new CliException("invalid value: " + arg);
        }
        return ret;
    }

    private static String[] readFile(String filename) {
        try {
            return (String[])Files.readAllLines(Paths.get(filename, new String[0])).stream().map(String::trim).filter(x -> !x.isEmpty() && !x.startsWith("#")).toArray(String[]::new);
        }
        catch (IOException ex) {
            throw new O4A_Exception("Cannot read configuration file " + filename + " : " + ex);
        }
    }

    public static void main(String[] args) {
        try {
            CliParser configuration = new CliParser(args);
            new Openapi4AWS(configuration).handle(configuration.getPaths(), configuration.getOutputFolder());
        }
        catch (O4A_Exception ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
    }

    private void handleArguments(String[] args, boolean strict) {
        ArrayList<Argument> ret = new ArrayList<Argument>();
        Boolean usingDashes = strict ? Boolean.valueOf(false) : null;
        for (String arg : args) {
            String value;
            String type;
            String area;
            block7: {
                block6: {
                    boolean dashes;
                    Matcher m = this.argPattern.matcher(arg);
                    if (!m.matches()) break block6;
                    boolean bl = dashes = m.group(1) != null;
                    if (usingDashes != null && usingDashes != dashes) break block6;
                    usingDashes = dashes;
                    area = m.group(2);
                    type = m.group(3).trim();
                    value = m.group(4).trim();
                    if (!value.isEmpty() && area.endsWith(".") != type.isEmpty()) break block7;
                }
                throw CliException.unexpectedArgument();
            }
            ret.add(new Argument(arg, area, type, value, ret.size()));
        }
        Collections.sort(ret);
        for (Argument arg : ret) {
            try {
                argumentHandlers.get(arg.area).consume(this, arg.type, arg.value);
            }
            catch (CliException ex) {
                throw new CliException(arg.argument + " : " + ex.getMessage());
            }
        }
    }

    @Override
    public Map<String, Configuration.Authorizer> getAuthorizers() {
        return this.authorizers.entrySet().stream().filter(x -> !((String)x.getKey()).isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Configuration.Integration> getPathIntegrations() {
        return this.paths.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, Configuration.Integration> getTagIntegrations() {
        return this.tags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Configuration.Integration getIntegration(String path, List<String> pathTags) {
        return this.getIntegration(path, pathTags, this.paths, this.tags);
    }

    public Collection<Path> getPaths() {
        return this.getPaths(this.filenames, this.globs);
    }

    public Path getOutputFolder() {
        return this.outputFolder;
    }

    private void handleOutput(String empty, String definition) {
        this.outputFolder = Paths.get(definition, new String[0]);
    }

    private void handleConfiguration(String empty, String definition) {
        this.handleArguments(CliParser.readFile(definition), true);
    }

    private void handleFilename(String empty, String definition) {
        this.filenames.add(definition);
    }

    private void handleGlob(String empty, String definition) {
        this.globs.add(definition);
    }

    private void handleTag(String definition, String value) {
        this.handleTagOrPath(this.tags, value, false, definition.toLowerCase(Locale.ROOT));
    }

    private void handlePath(String definition, String value) {
        this.handleTagOrPath(this.paths, value, true, "/" + definition.replace(".", "/"));
    }

    private void handleTagOrPath(Map<String, IntegrationParameter> map, String value, boolean isPath, String definition) {
        List<String> parts = CliParser.convertToNonEmptyList(value);
        IntegrationParameter integration = new IntegrationParameter(parts.get(0), isPath);
        if (parts.size() > 1) {
            String authorizerName = parts.get(1);
            if (this.authorizers.get(authorizerName) == null) {
                throw new CliException(authorizerName + " is not a provided authorizer name");
            }
            integration.setAuthorization(parts.get(1), parts.subList(2, parts.size()));
        }
        map.put(definition, integration);
    }

    private AuthorizerParameter getDefaultAuthorizer() {
        AuthorizerParameter defaultAuthorizer = this.authorizers.get("");
        if (defaultAuthorizer == null) {
            defaultAuthorizer = new AuthorizerParameter(null);
            this.authorizers.put("", defaultAuthorizer);
        }
        return defaultAuthorizer;
    }

    private void handleAuthorizer(String definition, String value) {
        if (AUTHORIZER_DEFINITION.equals(definition)) {
            AuthorizerParameter defaultAuthorizer = this.getDefaultAuthorizer();
            CliParser.convertToNonEmptyList(value).forEach(x -> this.authorizers.put((String)x, new AuthorizerParameter(defaultAuthorizer)));
        } else {
            AuthorizerParameter authorizer;
            int last;
            String name = "";
            AuthorizerConsumer authorizerConsumer = authorizerConsumers.get(definition);
            if (authorizerConsumer == null && (last = definition.lastIndexOf(46)) != -1) {
                name = definition.substring(last + 1).trim();
                authorizerConsumer = authorizerConsumers.get(definition.substring(0, last).trim());
            }
            if ((authorizer = this.authorizers.get(name)) == null || authorizerConsumer == null) {
                throw CliException.unexpectedArgument();
            }
            authorizerConsumer.handle(authorizer, value);
        }
    }

    static {
        argumentHandlers.put(AUTHORIZER, CliParser::handleAuthorizer);
        argumentHandlers.put(TAG, CliParser::handleTag);
        argumentHandlers.put(PATH, CliParser::handlePath);
        argumentHandlers.put(FILENAME, CliParser::handleFilename);
        argumentHandlers.put(GLOB, CliParser::handleGlob);
        argumentHandlers.put(OUTPUT, CliParser::handleOutput);
        argumentHandlers.put(CONFIGURATION, CliParser::handleConfiguration);
        authorizerConsumers.put(AUTHORIZER_IDENTITY_SOURCE, AuthorizerParameter::setIdentitySource);
        authorizerConsumers.put(AUTHORIZER_ISSUER, AuthorizerParameter::setIssuer);
        authorizerConsumers.put(AUTHORIZER_AUDIENCES, (s, a) -> s.setAudiences(CliParser.convertToNonEmptyList(a)));
        authorizerConsumers.put(AUTHORIZER_AUTHORIZATION_TYPE, AuthorizerParameter::setAuthorizationType);
        authorizerConsumers.put(AUTHORIZER_TYPE, AuthorizerParameter::setType);
        authorizerCheckers.put(AUTHORIZER_IDENTITY_SOURCE, AuthorizerParameter::getIdentitySource);
        authorizerCheckers.put(AUTHORIZER_ISSUER, AuthorizerParameter::getIssuer);
        authorizerCheckers.put(AUTHORIZER_AUDIENCES, AuthorizerParameter::getAudience);
        authorizerCheckers.put(AUTHORIZER_AUTHORIZATION_TYPE, AuthorizerParameter::getAuthorizationType);
        authorizerCheckers.put(AUTHORIZER_TYPE, AuthorizerParameter::getType);
    }

    private static interface Getter<T> {
        public Object get(T var1);
    }

    private static interface AuthorizerConsumer {
        public void handle(AuthorizerParameter var1, String var2);
    }

    private static interface ArgumentConsumer {
        public void consume(CliParser var1, String var2, String var3);
    }
}

